/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderDtlConvert;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApHeadSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyApSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPayHeadSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplyPaySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecApplyApprovalDTO;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayHeadVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyVO;
import com.elitesland.fin.application.service.aporder.ApOrderDtlService;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.payorder.PayOrderDtlService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyApHeadService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyApService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyPayHeadService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyPayService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplySettleService;
import com.elitesland.fin.application.service.writeoff.OperationLogService;
import com.elitesland.fin.common.BusinessOperatiomEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyDO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.utils.ThreadLocalCopyUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class FinApPayVerApplyServiceImpl
implements FinApPayVerApplyService {
    private static final Logger log = LoggerFactory.getLogger(FinApPayVerApplyServiceImpl.class);
    private final FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;
    private final FinApPayVerApplyApService finApPayVerApplyApService;
    private final FinApPayVerApplyApHeadService finApPayVerApplyApHeadService;
    private final FinApPayVerApplyPayService finApPayVerApplyPayService;
    private final FinApPayVerApplyPayHeadService finApPayVerApplyPayHeadService;
    private final SeqNumProvider seqNumProvider;
    private final FinApPayVerApplySettleService finApPayVerApplySettleService;
    private final OperationLogService operationLogService;
    private final ThreadLocalCopyUtil threadLocalCopyUtil;
    private final ApOrderDtlService apOrderDtlService;
    private final PayOrderDtlService payOrderDtlService;
    private final ApOrderService apOrderService;
    private final PayOrderService payOrderService;
    public static final ThreadLocal<String> CURRENT_USER = new ThreadLocal();
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(FinApPayVerApplySaveDTO save) {
        if (save.getId() == null) {
            return this.doCreate(save);
        }
        return this.doUpdate(save);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(FinApPayVerApplySaveDTO save) {
        this.verifyDataNew(save);
        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.save(save);
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", id.toString(), OperationTypeEnum.APPROVE_SUBMIT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));
        this.updateArMiddleVerAmt(save.getApSaveList());
        this.updateRecMiddleVerAmt(save.getPaySaveList());
        this.finApPayVerApplySettleService.createBatch(id, this.settleApplyDetailListNew(save.getApSaveList(), save.getPaySaveList()));
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long writeOffSubmit(FinApPayVerApplySaveDTO save) {
        this.checkWriteOffParamNew(save);
        this.buildArAndRecSaveList(save);
        save.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode());
        Long id = this.saveFinArRecVerApply(save);
        this.operationLogService.simpleSendLog("Fin_ap_pay_apply:\u5e94\u4ed8\u4ed8\u6b3e\u6838\u9500\u7533\u8bf7", id.toString(), OperationTypeEnum.APPROVE_SUBMIT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_SUBMIT));
        List<FinApPayVerApplyApSaveDTO> finApPayVerApplyApSaveDTOList = save.getApHeadSaveList().stream().flatMap(item -> item.getApSaveList().stream()).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> finApPayVerApplyPaySaveDTOList = save.getPayHeadSaveList().stream().flatMap(item -> item.getPaySaveList().stream()).collect(Collectors.toList());
        this.updateArMiddleVerAmt(finApPayVerApplyApSaveDTOList);
        this.updateRecMiddleVerAmt(finApPayVerApplyPaySaveDTOList);
        List<FinApPayVerApplySettleSaveDTO> finApPayVerApplySettleSaveDTOList = this.settleApplyDetailListNew(finApPayVerApplyApSaveDTOList, finApPayVerApplyPaySaveDTOList);
        finApPayVerApplySettleSaveDTOList.forEach(finArRecVerApplySettleSaveDTO -> {
            finArRecVerApplySettleSaveDTO.setOuId(save.getOuId());
            finArRecVerApplySettleSaveDTO.setOuCode(save.getOuCode());
            finArRecVerApplySettleSaveDTO.setOuName(save.getOuName());
        });
        this.finApPayVerApplySettleService.createBatch(id, finApPayVerApplySettleSaveDTOList);
        save.setId(id);
        return id;
    }

    public Long saveFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        if (save.getId() == null) {
            return this.createFinArRecVerApply(save);
        }
        return this.updateFinArRecVerApply(save);
    }

    private Long updateFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        if (save.getSchemeId() == null) {
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }
        this.updateApplyOrder(save);
        List<FinApPayVerApplyApHeadVO> finApPayVerApplyApHeadVOList = this.finApPayVerApplyApHeadService.listByMasIds(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        Assert.notEmpty(finApPayVerApplyApHeadVOList, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355");
        List<FinApPayVerApplyPayHeadVO> finApPayVerApplyPayHeadVOList = this.finApPayVerApplyPayHeadService.listByMasIds(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        Assert.notEmpty(finApPayVerApplyPayHeadVOList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355");
        this.finApPayVerApplyApHeadService.deleteByMasId(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        this.finApPayVerApplyPayHeadService.deleteByMasId(Lists.newArrayList((Object[])new Long[]{save.getId()}));
        this.finApPayVerApplyApService.deleteByMasId(finApPayVerApplyApHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toSet()));
        this.finApPayVerApplyPayService.deleteByMasId(finApPayVerApplyPayHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toSet()));
        save.getApHeadSaveList().stream().forEach(item -> {
            Long masId = this.finApPayVerApplyApHeadService.create(save.getId(), (FinApPayVerApplyApHeadSaveDTO)item);
            this.finApPayVerApplyApService.createBatch(masId, item.getApSaveList());
        });
        save.getPayHeadSaveList().stream().forEach(item -> {
            Long masId = this.finApPayVerApplyPayHeadService.create(save.getId(), (FinApPayVerApplyPayHeadSaveDTO)item);
            this.finApPayVerApplyPayService.createBatch(masId, save.getPaySaveList());
        });
        return save.getId();
    }

    private Long createFinArRecVerApply(FinApPayVerApplySaveDTO save) {
        Optional<FinApPayVerApplyApHeadSaveDTO> arHeadSaveDTOOptional;
        if (save.getSchemeId() == null) {
            save.setVerMode(WriteoffUdcEnum.FIN_VER_MODE_MANUAL.getValueCode());
        }
        if ((arHeadSaveDTOOptional = save.getApHeadSaveList().stream().filter(arHeadSaveDTO -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)arHeadSaveDTO.getOuCode()) || Objects.nonNull(arHeadSaveDTO.getOuId())).findFirst()).isPresent()) {
            arHeadSaveDTOOptional.ifPresent(finArRecVerApplyArHeadSaveDTO -> {
                save.setOuId(finArRecVerApplyArHeadSaveDTO.getOuId());
                save.setOuCode(finArRecVerApplyArHeadSaveDTO.getOuCode());
                save.setOuName(finArRecVerApplyArHeadSaveDTO.getOuName());
            });
        } else {
            Optional<FinApPayVerApplyPayHeadSaveDTO> recHeadSaveDTOOptional = save.getPayHeadSaveList().stream().filter(recHeadSaveDTO -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recHeadSaveDTO.getOuCode()) || Objects.nonNull(recHeadSaveDTO.getOuId())).findFirst();
            if (recHeadSaveDTOOptional.isPresent()) {
                recHeadSaveDTOOptional.ifPresent(recVerApplyRecHeadSaveDTO -> {
                    save.setOuId(recVerApplyRecHeadSaveDTO.getOuId());
                    save.setOuCode(recVerApplyRecHeadSaveDTO.getOuCode());
                    save.setOuName(recVerApplyRecHeadSaveDTO.getOuName());
                });
            }
        }
        long id = this.createApplyOrder(save);
        save.getApHeadSaveList().stream().forEach(item -> {
            Long masId = this.finApPayVerApplyApHeadService.create(id, (FinApPayVerApplyApHeadSaveDTO)item);
            this.finApPayVerApplyApService.createBatch(masId, item.getApSaveList());
        });
        save.getPayHeadSaveList().stream().forEach(item -> {
            Long masId = this.finApPayVerApplyPayHeadService.create(id, (FinApPayVerApplyPayHeadSaveDTO)item);
            this.finApPayVerApplyPayService.createBatch(masId, item.getPaySaveList());
        });
        return id;
    }

    private void buildArAndRecSaveList(FinApPayVerApplySaveDTO save) {
        this.buildArHeadSaveList(save);
        this.buildRecHeadSaveList(save);
    }

    private void buildArHeadSaveList(FinApPayVerApplySaveDTO save) {
        List<FinApPayVerApplyApHeadSaveDTO> finApPayVerApplyApHeadSaveDTOList = save.getApHeadSaveList();
        List<Long> arOrderIds = finApPayVerApplyApHeadSaveDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        ApOrderDtlPageParam apOrderDtlPageParam = new ApOrderDtlPageParam();
        apOrderDtlPageParam.setMasIds(arOrderIds);
        apOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<ApOrderDtlVO> apOrderDtlVOPagingVO = this.apOrderDtlService.page(apOrderDtlPageParam);
        List apOrderDtlVOS = apOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty((Collection)apOrderDtlVOS, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355\u660e\u7ec6");
        finApPayVerApplyApHeadSaveDTOList.forEach(apOrder -> {
            List apOrderDtlVOList = apOrderDtlVOS.stream().filter(apOrderDtlVO -> apOrderDtlVO.getMasId().equals(apOrder.getId())).collect(Collectors.toList());
            Assert.notEmpty(apOrderDtlVOList, (String)"\u67e5\u4e0d\u5230\u5e94\u6536\u5355\u660e\u7ec6");
            apOrder.setApSaveList((List<FinApPayVerApplyApSaveDTO>)(CollectionUtils.isEmpty(apOrder.getApSaveList()) ? Lists.newArrayList() : apOrder.getApSaveList()));
            if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                ApOrderDtlVO apOrderDtlVO2 = (ApOrderDtlVO)apOrderDtlVOList.get(0);
                this.buildArSaveList(apOrderDtlVO2, apOrder.getVerAmt(), (FinApPayVerApplyApHeadSaveDTO)apOrder);
                return;
            }
            ApOrderDtlVO arOrderDtlVO = apOrderDtlVOList.stream().filter(item -> apOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst().orElse(null);
            if (arOrderDtlVO != null) {
                this.buildArSaveList(arOrderDtlVO, apOrder.getVerAmt(), (FinApPayVerApplyApHeadSaveDTO)apOrder);
            }
            if (arOrderDtlVO == null) {
                BigDecimal balance = apOrder.getVerAmt();
                for (ApOrderDtlVO item2 : apOrderDtlVOList) {
                    if (BigDecimal.ZERO.compareTo(item2.getUnVerAmt()) == 0) continue;
                    if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item2.getUnVerAmt()) <= 0) {
                            this.buildArSaveList(item2, balance, (FinApPayVerApplyApHeadSaveDTO)apOrder);
                            break;
                        }
                        if (balance.compareTo(item2.getUnVerAmt()) > 0) {
                            this.buildArSaveList(item2, item2.getUnVerAmt(), (FinApPayVerApplyApHeadSaveDTO)apOrder);
                            balance = balance.subtract(item2.getUnVerAmt());
                        }
                    }
                    if (apOrder.getVerAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) {
                        this.buildArSaveList(item2, balance, (FinApPayVerApplyApHeadSaveDTO)apOrder);
                        break;
                    }
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) continue;
                    this.buildArSaveList(item2, item2.getUnVerAmt(), (FinApPayVerApplyApHeadSaveDTO)apOrder);
                    balance = balance.subtract(item2.getUnVerAmt());
                }
            }
        });
    }

    private void buildArSaveList(ApOrderDtlVO apOrderDtlVO, BigDecimal amount, FinApPayVerApplyApHeadSaveDTO finApPayVerApplyApHeadSaveDTO) {
        apOrderDtlVO.setVerAmt(amount);
        FinApPayVerApplyApSaveDTO finApPayVerApplyApSaveDTO = ApOrderDtlConvert.INSTANCE.VO2DTO(apOrderDtlVO);
        finApPayVerApplyApSaveDTO.setApDId(apOrderDtlVO.getId());
        finApPayVerApplyApHeadSaveDTO.getApSaveList().add(finApPayVerApplyApSaveDTO);
        finApPayVerApplyApHeadSaveDTO.setSalesmanName(finApPayVerApplyApHeadSaveDTO.getBusinessName());
        finApPayVerApplyApHeadSaveDTO.setSalesmanCode(finApPayVerApplyApHeadSaveDTO.getSaleUser());
    }

    private void buildRecHeadSaveList(FinApPayVerApplySaveDTO save) {
        List<FinApPayVerApplyPayHeadSaveDTO> finApPayVerApplyPayHeadSaveDTOS = save.getPayHeadSaveList();
        List<Long> recIds = finApPayVerApplyPayHeadSaveDTOS.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        PayOrderDtlPageParam payOrderDtlPageParam = new PayOrderDtlPageParam();
        payOrderDtlPageParam.setMasIds(recIds);
        payOrderDtlPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<PayOrderDtlVO> payOrderDtlVOPagingVO = this.payOrderDtlService.page(payOrderDtlPageParam);
        List payOrderDtlVOS = payOrderDtlVOPagingVO.getRecords();
        Assert.notEmpty((Collection)payOrderDtlVOS, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355\u660e\u7ec6");
        finApPayVerApplyPayHeadSaveDTOS.forEach(payOrder -> {
            List payOrderDtlVOList = payOrderDtlVOS.stream().filter(payOrderDtlVO -> payOrderDtlVO.getMasId().equals(payOrder.getId())).collect(Collectors.toList());
            Assert.notEmpty(payOrderDtlVOList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355\u660e\u7ec6");
            payOrder.setPaySaveList((List<FinApPayVerApplyPaySaveDTO>)(CollectionUtils.isEmpty(payOrder.getPaySaveList()) ? Lists.newArrayList() : payOrder.getPaySaveList()));
            if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) == 0) {
                PayOrderDtlVO payOrderDtlVO2 = (PayOrderDtlVO)payOrderDtlVOList.get(0);
                this.buildRecSaveList(payOrderDtlVO2, payOrder.getVerAmt(), (FinApPayVerApplyPayHeadSaveDTO)payOrder);
                return;
            }
            PayOrderDtlVO recOrderDtlVO = payOrderDtlVOList.stream().filter(item -> payOrder.getVerAmt().compareTo(item.getUnVerAmt()) == 0).findFirst().orElse(null);
            if (recOrderDtlVO != null) {
                this.buildRecSaveList(recOrderDtlVO, payOrder.getVerAmt(), (FinApPayVerApplyPayHeadSaveDTO)payOrder);
            }
            if (recOrderDtlVO == null) {
                BigDecimal balance = payOrder.getVerAmt();
                for (PayOrderDtlVO item2 : payOrderDtlVOList) {
                    if (BigDecimal.ZERO.compareTo(item2.getUnVerAmt()) == 0) continue;
                    if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) > 0) {
                        if (balance.compareTo(item2.getUnVerAmt()) <= 0) {
                            this.buildRecSaveList(item2, balance, (FinApPayVerApplyPayHeadSaveDTO)payOrder);
                            break;
                        }
                        if (balance.compareTo(item2.getUnVerAmt()) > 0) {
                            this.buildRecSaveList(item2, item2.getUnVerAmt(), (FinApPayVerApplyPayHeadSaveDTO)payOrder);
                            balance = balance.subtract(item2.getUnVerAmt());
                        }
                    }
                    if (payOrder.getVerAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) {
                        this.buildRecSaveList(item2, balance, (FinApPayVerApplyPayHeadSaveDTO)payOrder);
                        break;
                    }
                    if (balance.compareTo(item2.getUnVerAmt()) >= 0) continue;
                    this.buildRecSaveList(item2, item2.getUnVerAmt(), (FinApPayVerApplyPayHeadSaveDTO)payOrder);
                    balance = balance.subtract(item2.getUnVerAmt());
                }
            }
        });
    }

    private void buildRecSaveList(PayOrderDtlVO payOrderDtlVO, BigDecimal amount, FinApPayVerApplyPayHeadSaveDTO finApPayVerApplyPayHeadSaveDTO) {
        payOrderDtlVO.setVerAmt(amount);
        FinApPayVerApplyPaySaveDTO finApPayVerApplyPaySaveDTO = PayOrderDtlConvert.INSTANCE.VO2DTO(payOrderDtlVO);
        finApPayVerApplyPaySaveDTO.setPayDId(payOrderDtlVO.getId());
        finApPayVerApplyPayHeadSaveDTO.getPaySaveList().add(finApPayVerApplyPaySaveDTO);
        finApPayVerApplyPayHeadSaveDTO.setSalesmanName(finApPayVerApplyPayHeadSaveDTO.getBusinessName());
        finApPayVerApplyPayHeadSaveDTO.setSalesmanCode(finApPayVerApplyPayHeadSaveDTO.getSaleUser());
    }

    private void checkWriteOffParam(FinApPayVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinApPayVerApplyApHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getApHeadSaveList();
        Assert.notEmpty(finArRecVerApplyArHeadSaveDTOList, (String)"\u5e94\u6536\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
        List<FinApPayVerApplyPayHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getPayHeadSaveList();
        Assert.notEmpty(finArRecVerApplyRecHeadSaveDTOList, (String)"\u6536\u6b3e\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        finArRecVerApplyRecHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
        BigDecimal arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinApPayVerApplyApHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinApPayVerApplyPayHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        Assert.isTrue((arVerAmt.compareTo(recVerAmt) == 0 ? 1 : 0) != 0, (String)"\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    private void checkWriteOffParamNew(FinApPayVerApplySaveDTO finArRecVerApplySaveDTO) {
        List<FinApPayVerApplyApHeadSaveDTO> finArRecVerApplyArHeadSaveDTOList = finArRecVerApplySaveDTO.getApHeadSaveList();
        List<FinApPayVerApplyPayHeadSaveDTO> finArRecVerApplyRecHeadSaveDTOList = finArRecVerApplySaveDTO.getPayHeadSaveList();
        if (CollectionUtils.isEmpty(finArRecVerApplyArHeadSaveDTOList) && CollectionUtils.isEmpty(finArRecVerApplyRecHeadSaveDTOList)) {
            throw new BusinessException("\u5e94\u6536\u5355\u548c\u6536\u6b3e\u5355\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadSaveDTOList)) {
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
            arVerAmt = finArRecVerApplyArHeadSaveDTOList.stream().map(FinApPayVerApplyApHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty(finArRecVerApplyRecHeadSaveDTOList)) {
            finArRecVerApplyArHeadSaveDTOList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
            recVerAmt = finArRecVerApplyRecHeadSaveDTOList.stream().map(FinApPayVerApplyPayHeadSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        Assert.isTrue((arVerAmt.compareTo(recVerAmt) == 0 ? 1 : 0) != 0, (String)"\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        finArRecVerApplySaveDTO.setVerAmt(arVerAmt);
    }

    @Override
    @SysCodeProc
    public FinApPayVerApplyVO detail(Long id) {
        FinApPayVerApplyDO entity = this.findApplyOrder(id);
        FinApPayVerApplyVO result = FinApPayVerApplyConvert.INSTANCE.entity2Vo(entity);
        result.setApList(this.finApPayVerApplyApService.listByMasIds(Collections.singletonList(id)));
        result.setPayList(this.finApPayVerApplyPayService.listByMasIds(Collections.singletonList(id)));
        return result;
    }

    @Override
    @SysCodeProc
    public FinApPayVerApplyVO writeOffDetail(Long id) {
        FinApPayVerApplyDO entity = this.findApplyOrder(id);
        FinApPayVerApplyVO result = FinApPayVerApplyConvert.INSTANCE.entity2Vo(entity);
        FinApPayVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(Lists.newArrayList((Object[])new Long[]{id}));
        result.setApHeadList(headAndDetailInfo.getApHeadList());
        result.setPayHeadList(headAndDetailInfo.getPayHeadList());
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinApPayVerApplyVO> page(FinApPayVerApplyQuery query) {
        List<FinApPayVerApplyPayVO> recVOList;
        ArrayList masIds = new ArrayList();
        ArrayList<Long> arIds = new ArrayList<Long>();
        ArrayList<Long> recIds = new ArrayList<Long>();
        List<FinApPayVerApplyApVO> arVOList = this.finApPayVerApplyApService.listByOutArDocNoOrDId(query);
        if (CollUtil.isNotEmpty(arVOList)) {
            masIds.addAll(arVOList.stream().map(FinApPayVerApplyApVO::getMasId).distinct().collect(Collectors.toList()));
            arIds.addAll(arVOList.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(recVOList = this.finApPayVerApplyPayService.listByOutRecDocNoOrDId(query))) {
            masIds.addAll(recVOList.stream().map(FinApPayVerApplyPayVO::getMasId).distinct().collect(Collectors.toList()));
            recIds.addAll(recVOList.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(masIds)) {
            query.setIds(masIds.stream().distinct().collect(Collectors.toList()));
        }
        if ((StrUtil.isNotEmpty((CharSequence)query.getOutApDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutApDId()) || StrUtil.isNotEmpty((CharSequence)query.getOutPayDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutPayDId())) && CollUtil.isEmpty(masIds)) {
            return PagingVO.empty();
        }
        PagingVO<FinApPayVerApplyDO> page = this.finApPayVerApplyRepoProc.joinPage(query);
        if (page.isEmpty()) {
            return PagingVO.empty();
        }
        PagingVO result = page.map(FinApPayVerApplyConvert.INSTANCE::entity2Vo);
        List<Long> ids = result.getRecords().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<FinApPayVerApplyApVO> arList = this.finApPayVerApplyApService.listByQuery(FinApPayVerApplyApQuery.builder().ids(arIds).masIds(ids).build());
        List<FinApPayVerApplyPayVO> recList = this.finApPayVerApplyPayService.listByQuery(FinApPayVerApplyPayQuery.builder().ids(recIds).masIds(ids).build());
        if (arList.isEmpty() && recList.isEmpty()) {
            return result;
        }
        result.getRecords().forEach(e -> {
            e.setApList(arList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
            e.setPayList(recList.stream().filter(fi -> fi.getMasId().equals(e.getId())).collect(Collectors.toList()));
        });
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<FinApPayVerApplyVO> writeOffPage(FinApPayVerApplyQuery query) {
        List<FinApPayVerApplyPayVO> recVOList;
        ArrayList masIds = new ArrayList();
        ArrayList<Long> arIds = new ArrayList<Long>();
        ArrayList<Long> recIds = new ArrayList<Long>();
        List<FinApPayVerApplyApVO> arVOList = this.finApPayVerApplyApService.listByOutArDocNoOrDId(query);
        if (CollUtil.isNotEmpty(arVOList)) {
            List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOS = this.finApPayVerApplyApHeadService.listByIds(arVOList.stream().map(FinApPayVerApplyApVO::getMasId).distinct().collect(Collectors.toList()));
            if (CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)) {
                masIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinApPayVerApplyApHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            arIds.addAll(arVOList.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(recVOList = this.finApPayVerApplyPayService.listByOutRecDocNoOrDId(query))) {
            List<FinApPayVerApplyPayHeadVO> finArRecVerApplyArHeadVOS = this.finApPayVerApplyPayHeadService.listByIds(recVOList.stream().map(FinApPayVerApplyPayVO::getMasId).distinct().collect(Collectors.toList()));
            if (CollUtil.isNotEmpty(finArRecVerApplyArHeadVOS)) {
                masIds.addAll(finArRecVerApplyArHeadVOS.stream().map(FinApPayVerApplyPayHeadVO::getMasId).distinct().collect(Collectors.toList()));
            }
            masIds.addAll(recVOList.stream().map(FinApPayVerApplyPayVO::getMasId).distinct().collect(Collectors.toList()));
            recIds.addAll(recVOList.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(masIds)) {
            query.setIds(masIds.stream().distinct().collect(Collectors.toList()));
        }
        if ((StrUtil.isNotEmpty((CharSequence)query.getOutApDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutApDId()) || StrUtil.isNotEmpty((CharSequence)query.getOutPayDocNo()) || StrUtil.isNotEmpty((CharSequence)query.getOutPayDId())) && CollUtil.isEmpty(masIds)) {
            return PagingVO.empty();
        }
        PagingVO<FinApPayVerApplyDO> page = this.finApPayVerApplyRepoProc.writeOffJoinPage(query);
        if (page.isEmpty()) {
            return PagingVO.empty();
        }
        PagingVO result = page.map(FinApPayVerApplyConvert.INSTANCE::entity2Vo);
        List<Long> ids = result.getRecords().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        FinApPayVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfoByQuery(arIds, recIds, ids);
        result.getRecords().forEach(record -> {
            record.setApHeadList(headAndDetailInfo.getApHeadList().stream().filter(finArRecVerApplyArHeadVO -> record.getId().equals(finArRecVerApplyArHeadVO.getMasId())).collect(Collectors.toList()));
            record.setPayHeadList(headAndDetailInfo.getPayHeadList().stream().filter(finArRecVerApplyRecHeadVO -> record.getId().equals(finArRecVerApplyRecHeadVO.getMasId())).collect(Collectors.toList()));
        });
        return result;
    }

    private FinApPayVerApplyVO queryHeadAndDetailInfoByQuery(List<Long> arIds, List<Long> recIds, List<Long> masIds) {
        List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOList = this.finApPayVerApplyApHeadService.listByMasIds(masIds);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyApVO> finArRecVerApplyArVOList = this.finApPayVerApplyApService.listByQuery(FinApPayVerApplyApQuery.builder().masIds(arMasIds).ids(arIds).build());
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinApPayVerApplyApVO> resultList = finArRecVerApplyArVOList.stream().filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyArHeadVO.setApList(resultList);
            });
        }
        List<FinApPayVerApplyPayHeadVO> finArRecVerApplyRecHeadVOList = this.finApPayVerApplyPayHeadService.listByMasIds(masIds);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyPayVO> finArRecVerApplyRecVOList = this.finApPayVerApplyPayService.listByQuery(FinApPayVerApplyPayQuery.builder().masIds(recMasIds).ids(recIds).build());
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinApPayVerApplyPayVO> resultList = finArRecVerApplyRecVOList.stream().filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyRecHead.setPayList(resultList);
            });
        }
        FinApPayVerApplyVO finArRecVerApplyVO = new FinApPayVerApplyVO();
        finArRecVerApplyVO.setApHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setPayHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    private FinApPayVerApplyVO queryHeadAndDetailInfo(Collection<Long> ids) {
        List<FinApPayVerApplyApHeadVO> finArRecVerApplyArHeadVOList = this.finApPayVerApplyApHeadService.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> arMasIds = finArRecVerApplyArHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyApVO> finArRecVerApplyArVOList = this.finApPayVerApplyApService.listByMasIds(arMasIds);
            finArRecVerApplyArHeadVOList.stream().forEach(finArRecVerApplyArHeadVO -> {
                List<FinApPayVerApplyApVO> resultList = finArRecVerApplyArVOList.stream().filter(finArRecVerApplyArVO -> finArRecVerApplyArHeadVO.getId().equals(finArRecVerApplyArVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyArHeadVO.setApList(resultList);
            });
        }
        List<FinApPayVerApplyPayHeadVO> finArRecVerApplyRecHeadVOList = this.finApPayVerApplyPayHeadService.listByMasIds(ids);
        if (CollectionUtils.isNotEmpty(finArRecVerApplyArHeadVOList)) {
            List<Long> recMasIds = finArRecVerApplyRecHeadVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            List<FinApPayVerApplyPayVO> finArRecVerApplyRecVOList = this.finApPayVerApplyPayService.listByMasIds(recMasIds);
            finArRecVerApplyRecHeadVOList.stream().forEach(finArRecVerApplyRecHead -> {
                List<FinApPayVerApplyPayVO> resultList = finArRecVerApplyRecVOList.stream().filter(finArRecVerApplyRecVO -> finArRecVerApplyRecHead.getId().equals(finArRecVerApplyRecVO.getMasId())).collect(Collectors.toList());
                finArRecVerApplyRecHead.setPayList(resultList);
            });
        }
        FinApPayVerApplyVO finArRecVerApplyVO = new FinApPayVerApplyVO();
        finArRecVerApplyVO.setApHeadList(finArRecVerApplyArHeadVOList);
        finArRecVerApplyVO.setPayHeadList(finArRecVerApplyRecHeadVOList);
        return finArRecVerApplyVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(FinApPayApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinApPayVerApplyDO> applyList = this.finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finApPayVerApplyRepoProc.save(applyList);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO != null ? sysUserDTO.getLastName() : principal.getUsername();
        this.threadLocalCopyUtil.asyncTask(() -> {
            CURRENT_USER.set(user);
            SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
            TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e -> {
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
                e.setErpLog(finalErpLog);
            });
            this.finApPayVerApplyRepoProc.save(applyList);
            applyList.forEach(apply -> {
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_OK, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            CURRENT_USER.remove();
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffApprove(FinApPayApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.APPROVE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinApPayVerApplyDO> applyList = this.finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finApPayVerApplyRepoProc.save(applyList);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        SysUserDTO sysUserDTO = principal.getUser();
        String user = sysUserDTO != null ? sysUserDTO.getLastName() : principal.getUsername();
        this.threadLocalCopyUtil.asyncTask(() -> {
            CURRENT_USER.set(user);
            SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
            String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
            String erpLog = "";
            try {
                this.updateAmount(applyList.stream().map(BaseModel::getId).collect(Collectors.toList()), "1");
            }
            catch (Exception e2) {
                log.error("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25", (Throwable)e2);
                applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode();
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_FAILED.getValueCode();
                erpLog = e2.getMessage();
            }
            String finalApplyState = applyState;
            String finalVerState = verState;
            String finalErpLog = erpLog;
            applyList.forEach(e -> {
                e.setState(finalApplyState);
                e.setVerState(finalVerState);
                e.setErpLog(finalErpLog);
            });
            this.finApPayVerApplyRepoProc.save(applyList);
            applyList.forEach(apply -> {
                if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(apply.getState())) {
                    this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_OK, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_OK));
                }
            });
            CURRENT_USER.remove();
        });
    }

    public ApiResult<String> reTryApprove(Long id) {
        FinApPayVerApplyDO applyDO = (FinApPayVerApplyDO)((Object)this.finApPayVerApplyRepoProc.get(id));
        SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
        TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
        String applyState = WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVED.getValueCode();
        String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode();
        String erpLog = "";
        Boolean isSuccess = Boolean.TRUE;
        String finalApplyState = applyState;
        String finalVerState = verState;
        String finalErpLog = erpLog;
        applyDO.setState(finalApplyState);
        applyDO.setVerState(finalVerState);
        applyDO.setErpLog(finalErpLog);
        this.finApPayVerApplyRepoProc.save((Serializable)((Object)applyDO));
        return isSuccess != false ? ApiResult.ok((Object)"\u91cd\u63a8\u6838\u9500\u5ba1\u6279\u6210\u529f") : ApiResult.fail((String)erpLog);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAmount(Collection<Long> ids, String verType) {
        BigDecimal factor = BigDecimal.ONE;
        FinApPayVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(ids);
        List<Long> arMasIds = headAndDetailInfo.getApHeadList().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<Long> recMasIds = headAndDetailInfo.getPayHeadList().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<FinApPayVerApplyApVO> arVOList = this.finApPayVerApplyApService.listByMasIds(arMasIds);
        arVOList.forEach(e -> this.apOrderService.updateVerAmt(e.getApDId(), e.getVerAmt().multiply(factor), verType));
        List<FinApPayVerApplyPayVO> recVOList = this.finApPayVerApplyPayService.listByMasIds(recMasIds);
        recVOList.forEach(e -> this.payOrderService.updateVerAmt(e.getPayDId(), e.getVerAmt().multiply(factor), verType));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refuse(FinApPayApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinApPayVerApplyDO> applyList = this.finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, (String)"\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u5355");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        this.finApPayVerApplyApService.listByMasIds(masIds).forEach(e -> this.apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt().negate()));
        this.finApPayVerApplyPayService.listByMasIds(masIds).forEach(e -> this.payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt().negate()));
        this.finApPayVerApplyRepoProc.save(applyList);
        applyList.forEach(apply -> this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffRefuse(FinApPayApplyApprovalDTO dto) {
        if (!FinArRecApplyApprovalDTO.ApprovalType.REFUSE.equals((Object)dto.getApprovalType())) {
            throw new BusinessException("\u975e\u6cd5\u7684approvalType");
        }
        List<FinApPayVerApplyDO> applyList = this.finApPayVerApplyRepoProc.getListByApplyNos(dto.getApplyNos());
        Assert.notEmpty(applyList, (String)"\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u5355");
        List<Long> masIds = applyList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.preCheckForApproval(dto.getApplyNos(), applyList);
        this.setApprovalMsg(dto, applyList);
        FinApPayVerApplyVO headAndDetailInfo = this.queryHeadAndDetailInfo(masIds);
        List<Long> arMasIds = headAndDetailInfo.getApHeadList().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<Long> recMasIds = headAndDetailInfo.getPayHeadList().stream().map(BaseModelVO::getId).collect(Collectors.toList());
        this.finApPayVerApplyApService.listByMasIds(arMasIds).forEach(e -> this.apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt().negate()));
        this.finApPayVerApplyPayService.listByMasIds(recMasIds).forEach(e -> this.payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt().negate()));
        this.finApPayVerApplyRepoProc.save(applyList);
        applyList.forEach(apply -> this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", apply.getId().toString(), OperationTypeEnum.APPROVE_REJECT, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.APPROVE_REJECT)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(Long id) {
        FinApPayVerApplyDO entity = this.findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("\u4ec5\u6838\u9500\u72b6\u6001\u4e3a\u5df2\u6838\u9500\u6216\u8005\u53d6\u6d88\u5931\u8d25\u7684\u5355\u636e\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c!");
        }
        this.updateOrderForVerCancel(entity);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String user = principal.getUsername();
        ThreadUtil.execute(() -> {
            CURRENT_USER.set(user);
            log.info("\u53d6\u6d88\u6838\u9500\u5f02\u6b65\u6267\u884c");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String erpLog = "";
            try {
                SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
                TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u6838\u9500,\u63a8\u9001nc\u5931\u8d25,{}", (Object)e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                erpLog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            entity.setErpLog(erpLog);
            log.info("\u53d6\u6d88\u6838\u9500\u66f4\u65b0\u72b6\u6001,{}", (Object)JSONUtil.toJsonStr((Object)((Object)entity)));
            this.finApPayVerApplyRepoProc.save((Serializable)((Object)entity));
            CURRENT_USER.remove();
        });
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, "\u53d6\u6d88\u6838\u9500");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void writeOffCancel(Long id) {
        FinApPayVerApplyDO entity = this.findApplyOrder(id);
        List<String> verStateList = Arrays.asList(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode(), WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_COMPLETE.getValueCode());
        if (!verStateList.contains(entity.getVerState())) {
            throw new BusinessException("\u4ec5\u6838\u9500\u72b6\u6001\u4e3a\u5df2\u6838\u9500\u6216\u8005\u53d6\u6d88\u5931\u8d25\u7684\u5355\u636e\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c!");
        }
        if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(entity.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(entity.getProposedStatus())) {
            throw new BusinessException("\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
        }
        this.updateOrderForVerCancel(entity);
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String user = principal.getUsername();
        ThreadUtil.execute(() -> {
            CURRENT_USER.set(user);
            log.info("\u53d6\u6d88\u6838\u9500\u5f02\u6b65\u6267\u884c");
            String verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode();
            String errlog = "";
            try {
                SysTenantDTO sysTenantDTO = TenantSession.getCurrentTenant();
                TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
                this.updateAmount(Collections.singleton(id), "2");
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u6838\u9500\u5931\u8d25,{}", (Object)e.getMessage());
                verState = WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL_FAILED.getValueCode();
                errlog = e.getMessage();
            }
            String finalVerState = verState;
            entity.setVerState(finalVerState);
            entity.setErpLog(errlog);
            log.info("\u53d6\u6d88\u6838\u9500\u66f4\u65b0\u72b6\u6001,{}", (Object)JSONUtil.toJsonStr((Object)((Object)entity)));
            this.finApPayVerApplyRepoProc.save((Serializable)((Object)entity));
            CURRENT_USER.remove();
        });
        this.updateAmount(Collections.singleton(id), "2");
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, "\u53d6\u6d88\u6838\u9500");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        List list = this.finApPayVerApplyRepoProc.get(ids);
        Assert.notEmpty((Collection)list, (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e\u4fe1\u606f");
        list.forEach(e -> {
            if (!WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode().equals(e.getState())) {
                throw new BusinessException("\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff0c\u8bf7\u6838\u5bf9\u5355\u636e\u72b6\u6001");
            }
        });
        this.finApPayVerApplyRepoProc.delete(ids);
        this.finApPayVerApplyApService.deleteByMasId(ids);
        this.finApPayVerApplyPayService.deleteByMasId(ids);
    }

    @Override
    public List<FinApPayVerApplySettleVO> settleList(Long id) {
        return this.finApPayVerApplySettleService.listByMasIds(Collections.singletonList(id));
    }

    private void updateArMiddleVerAmt(List<FinApPayVerApplyApSaveDTO> list) {
        list.forEach(e -> this.apOrderService.updateMiddleVerAmt(e.getApDId(), e.getVerAmt()));
    }

    private void updateRecMiddleVerAmt(List<FinApPayVerApplyPaySaveDTO> list) {
        list.forEach(e -> this.payOrderService.updateMiddleVerAmt(e.getPayDId(), e.getVerAmt()));
    }

    private void updateOrderForVerCancel(FinApPayVerApplyDO entity) {
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_CANCEL.getValueCode());
        this.finApPayVerApplyRepoProc.save((Serializable)((Object)entity));
    }

    private void verifyDataNew(FinApPayVerApplySaveDTO save) {
        List<FinApPayVerApplyApSaveDTO> arSaveList = save.getApSaveList();
        List<FinApPayVerApplyPaySaveDTO> recSaveList = save.getPaySaveList();
        if (CollectionUtils.isEmpty(arSaveList) && CollectionUtils.isEmpty(recSaveList)) {
            throw new BusinessException("\u5e94\u6536\u5355\u548c\u6536\u6b3e\u5355\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        save.setVerAmt(this.checkAndGetTotalVerAmtNew(arSaveList, recSaveList));
        if (CollectionUtils.isNotEmpty(arSaveList)) {
            List<Long> arDIds = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getApDId).collect(Collectors.toList());
            List<ApOrderDtlVO> arOrderDtlExVos = this.apOrderService.listApOrderDetail(FinApOrderDetailQuery.builder().apDIds(arDIds).build());
            if (arDIds.size() != arOrderDtlExVos.size()) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u5e94\u6536\u5355\u5355\u53f7");
            }
            arSaveList.forEach(arSave -> arOrderDtlExVos.stream().filter(fi -> fi.getId().equals(arSave.getApDId())).findFirst().ifPresent(ar -> {
                if (ZERO.compareTo(ar.getUnVerAmt().multiply(arSave.getVerAmt())) >= 0) {
                    throw new BusinessException("\u8bf7\u6821\u9a8c\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + arSave.getApDocNo());
                }
                if (ar.getUnVerAmt().abs().compareTo(arSave.getVerAmt().abs()) < 0) {
                    throw new BusinessException("\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + arSave.getApDocNo());
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(recSaveList)) {
            List<Long> recDId = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getPayDId).collect(Collectors.toList());
            List<PayOrderDtlVO> recOrderDtlExVos = this.payOrderService.listPayOrderDetail(FinPayOrderDetailQuery.builder().payDIds(recDId).build());
            if (recOrderDtlExVos.size() != recDId.size()) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u6536\u6b3e\u5355\u5355\u53f7");
            }
            recSaveList.forEach(recSave -> recOrderDtlExVos.stream().filter(fi -> fi.getId().equals(recSave.getPayDId())).findFirst().ifPresent(rec -> {
                if (ZERO.compareTo(rec.getUnVerAmt().multiply(recSave.getVerAmt())) >= 0) {
                    throw new BusinessException("\u8bf7\u6821\u9a8c\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u6570\u636e\uff0c\u5355\u53f7:" + recSave.getPayDocNo());
                }
                if (rec.getUnVerAmt().abs().compareTo(recSave.getVerAmt().abs()) < 0) {
                    throw new BusinessException("\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d\uff0c\u5355\u53f7:" + recSave.getPayDocNo());
                }
            }));
        }
    }

    private BigDecimal checkAndGetTotalVerAmt(List<FinApPayVerApplyApSaveDTO> arSaveList, List<FinApPayVerApplyPaySaveDTO> recSaveList) {
        BigDecimal recVerAmt;
        BigDecimal arVerAmt = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (arVerAmt.compareTo(recVerAmt = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
            throw new BusinessException("\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        }
        return arVerAmt;
    }

    private BigDecimal checkAndGetTotalVerAmtNew(List<FinApPayVerApplyApSaveDTO> arSaveList, List<FinApPayVerApplyPaySaveDTO> recSaveList) {
        BigDecimal arVerAmt = BigDecimal.ZERO;
        BigDecimal recVerAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(arSaveList)) {
            arSaveList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
            arVerAmt = arSaveList.stream().map(FinApPayVerApplyApSaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty(recSaveList)) {
            recSaveList.stream().forEach(item -> Assert.notNull((Object)item.getVerAmt(), (String)"\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
            recVerAmt = recSaveList.stream().map(FinApPayVerApplyPaySaveDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (arVerAmt.compareTo(recVerAmt) != 0) {
            throw new BusinessException("\u5e94\u6536\u5355\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d\u4e0d\u76f8\u7b49");
        }
        return arVerAmt;
    }

    private void releaseVerAmt(Collection<Long> ids) {
        this.updateVerAmt(ids, "2");
    }

    private void addVerAmt(Collection<Long> ids) {
        this.updateVerAmt(ids, "1");
    }

    public void updateVerAmt(Collection<Long> ids, String verType) {
        BigDecimal factor = BigDecimal.ONE;
        List<FinApPayVerApplyApVO> arVOList = this.finApPayVerApplyApService.listByMasIds(ids);
        arVOList.forEach(e -> this.apOrderService.updateVerAmt(e.getApDId(), e.getVerAmt().multiply(factor), verType));
        List<FinApPayVerApplyPayVO> recVOList = this.finApPayVerApplyPayService.listByMasIds(ids);
        recVOList.forEach(e -> this.payOrderService.updateVerAmt(e.getPayDId(), e.getVerAmt().multiply(factor), verType));
    }

    private Long doUpdate(FinApPayVerApplySaveDTO save) {
        this.updateApplyOrder(save);
        this.finApPayVerApplyApService.deleteByMasId(Collections.singleton(save.getId()));
        this.finApPayVerApplyPayService.deleteByMasId(Collections.singleton(save.getId()));
        this.finApPayVerApplyApService.createBatch(save.getId(), save.getApSaveList());
        this.finApPayVerApplyPayService.createBatch(save.getId(), save.getPaySaveList());
        return save.getId();
    }

    @NotNull
    private FinApPayVerApplyDO findApplyOrder(Long id) {
        FinApPayVerApplyDO entity = (FinApPayVerApplyDO)((Object)this.finApPayVerApplyRepoProc.get(id));
        Assert.notNull((Object)((Object)entity), (String)("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u4fe1\u606f\uff0cid:" + id));
        return entity;
    }

    private Long doCreate(FinApPayVerApplySaveDTO save) {
        long id = this.createApplyOrder(save);
        this.finApPayVerApplyApService.createBatch(id, save.getApSaveList());
        this.finApPayVerApplyPayService.createBatch(id, save.getPaySaveList());
        return id;
    }

    private long createApplyOrder(FinApPayVerApplySaveDTO save) {
        FinApPayVerApplyDO entity = FinApPayVerApplyConvert.INSTANCE.save2Do(save);
        entity.setApplyDocNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
        entity.setState(save.getState() == null ? WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_NEW.getValueCode() : save.getState());
        entity.setVerState(WriteoffUdcEnum.AR_REC_VER_APPLY_VER_STATUS_NOT.getValueCode());
        entity.setApplyDate(LocalDateTime.now());
        entity.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        entity.setApplyUserId(principal.getUserId());
        SysUserDTO user = principal.getUser();
        if (user != null) {
            entity.setApplyUserName(user.getLastName());
        }
        this.finApPayVerApplyRepoProc.save((Serializable)((Object)entity));
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.ADD, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.ADD));
        save.setApplyDocNo(entity.getApplyDocNo());
        return entity.getId();
    }

    private void updateApplyOrder(FinApPayVerApplySaveDTO save) {
        FinApPayVerApplyDO entity = (FinApPayVerApplyDO)((Object)this.finApPayVerApplyRepoProc.get(save.getId()));
        Assert.notNull((Object)((Object)entity), (String)("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6838\u9500\u7533\u8bf7\u5355\uff0cID:" + save.getId()));
        FinApPayVerApplyConvert.INSTANCE.save2Do(save, entity);
        this.finApPayVerApplyRepoProc.save((Serializable)((Object)entity));
        this.operationLogService.simpleSendLog("Interact_Fin_apply:\u5e94\u6536\u6536\u6b3e\u6838\u9500\u7533\u8bf7", entity.getId().toString(), OperationTypeEnum.UPDATE, BusinessOperatiomEnum.INTERACT_FIN_APPLY.getOperationMap().get(OperationTypeEnum.UPDATE));
    }

    private void setApprovalMsg(FinApPayApplyApprovalDTO dto, List<FinApPayVerApplyDO> applyList) {
        applyList.forEach(e -> {
            if (dto.getApprovalType() == FinApPayApplyApprovalDTO.ApprovalType.APPROVE) {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVALING.getValueCode());
            } else {
                e.setState(WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_REFUSE.getValueCode());
            }
            GeneralUserDetails principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            e.setApprovalUserId(principal.getUserId());
            SysUserDTO user = principal.getUser();
            if (user != null) {
                e.setApprovalUserName(user.getLastName());
            }
            e.setApprovalDate(LocalDateTime.now());
            if (StringUtils.hasText((String)dto.getApprovalRemark())) {
                e.setApprovalRemark(dto.getApprovalRemark());
            }
        });
    }

    private void preCheckForApproval(List<String> applyNos, List<FinApPayVerApplyDO> applyList) {
        if (applyNos.size() > applyList.size() && applyNos.removeAll(applyList.stream().map(FinApPayVerApplyDO::getApplyDocNo).collect(Collectors.toList()))) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6838\u9500\u7533\u8bf7\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u4ee5\u4e0b\u5355\u53f7:" + applyNos);
        }
        List fiRes = applyList.stream().filter(fi -> !WriteoffUdcEnum.AR_REC_VER_APPLY_STATUS_APPROVAL.getValueCode().equals(fi.getState())).map(FinApPayVerApplyDO::getApplyDocNo).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(fiRes)) {
            throw new BusinessException("\u4ee5\u4e0b\u6838\u9500\u7533\u8bf7\u5355\u65e0\u6cd5\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c:" + fiRes);
        }
    }

    private List<FinApPayVerApplySettleSaveDTO> settleApplyDetailList(List<FinApPayVerApplyApSaveDTO> ars, List<FinApPayVerApplyPaySaveDTO> recs) {
        List<FinApPayVerApplyApSaveDTO> arList = ars.stream().sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt)).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> recList = recs.stream().sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt)).collect(Collectors.toList());
        return this.doSettle(arList, recList);
    }

    private List<FinApPayVerApplySettleSaveDTO> settleApplyDetailListNew(List<FinApPayVerApplyApSaveDTO> ars, List<FinApPayVerApplyPaySaveDTO> recs) {
        ArrayList<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<FinApPayVerApplySettleSaveDTO>();
        ArrayList<FinApPayVerApplyApSaveDTO> leftAllArlist = new ArrayList<FinApPayVerApplyApSaveDTO>();
        ArrayList<FinApPayVerApplyPaySaveDTO> leftAllReclist = new ArrayList<FinApPayVerApplyPaySaveDTO>();
        List zeroArlist = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        List zeroReclist = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        List<FinApPayVerApplyApSaveDTO> arListPositive = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<FinApPayVerApplyApSaveDTO> arListNegative = ars.stream().filter(ar -> ar.getVerAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(arListPositive) && CollectionUtils.isNotEmpty(arListNegative)) {
            List<FinApPayVerApplyApSaveDTO> leftArlist = this.doSettleForApOffset(arListPositive, arListNegative, settles);
            if (CollectionUtils.isNotEmpty(leftArlist)) {
                leftAllArlist.addAll(leftArlist);
            }
        } else {
            if (CollectionUtils.isNotEmpty(arListPositive)) {
                leftAllArlist.addAll(arListPositive);
            }
            if (CollectionUtils.isNotEmpty(arListNegative)) {
                leftAllArlist.addAll(arListNegative);
            }
        }
        List<FinApPayVerApplyPaySaveDTO> recListPositive = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> recListNegative = recs.stream().filter(rec -> rec.getVerAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(recListPositive) && CollectionUtils.isNotEmpty(recListNegative)) {
            List<FinApPayVerApplyPaySaveDTO> leftReclist = this.doSettleForPayOffset(recListPositive, recListNegative, settles);
            if (CollectionUtils.isNotEmpty(leftReclist)) {
                leftAllReclist.addAll(leftReclist);
            }
        } else {
            if (CollectionUtils.isNotEmpty(recListPositive)) {
                leftAllReclist.addAll(recListPositive);
            }
            if (CollectionUtils.isNotEmpty(recListNegative)) {
                leftAllReclist.addAll(recListNegative);
            }
        }
        if (CollectionUtils.isEmpty(leftAllArlist) || CollectionUtils.isEmpty(leftAllReclist)) {
            return settles;
        }
        List<FinApPayVerApplyApSaveDTO> arList = leftAllArlist.stream().sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt)).collect(Collectors.toList());
        List<FinApPayVerApplyPaySaveDTO> recList = leftAllReclist.stream().sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt)).collect(Collectors.toList());
        settles.addAll(this.doSettleNew(arList, recList));
        return settles;
    }

    private List<FinApPayVerApplyApSaveDTO> doSettleForApOffset(List<FinApPayVerApplyApSaveDTO> arListPositive, List<FinApPayVerApplyApSaveDTO> arListNegative, List<FinApPayVerApplySettleSaveDTO> settles) {
        arListPositive.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        arListNegative.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        List arListPositiveSorted = arListPositive.stream().sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt)).collect(Collectors.toList());
        List arListNegativeSorted = arListNegative.stream().sorted(Comparator.comparing(FinApPayVerApplyApSaveDTO::getVerAmt)).collect(Collectors.toList());
        Collections.reverse(arListNegativeSorted);
        ArrayList arListPositiveRm = new ArrayList();
        ArrayList arListNegativeRm = new ArrayList();
        arListNegativeSorted.stream().forEach(arn -> arListPositiveSorted.stream().forEach(arp -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = BigDecimal.ZERO.compareTo(arn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(arp.getVerAmt()) == 0;
            if (writeOffFlag) {
                return;
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(this.buildSettleForApOffset((FinApPayVerApplyApSaveDTO)arp, null));
                arn.setVerAmt(arn.getVerAmt().add(arp.getVerAmt()));
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(this.buildSettleForApOffset((FinApPayVerApplyApSaveDTO)arn, null));
                settles.add(this.buildSettleForApOffset((FinApPayVerApplyApSaveDTO)arp, null));
                arn.setVerAmt(BigDecimal.ZERO);
                arp.setVerAmt(BigDecimal.ZERO);
                arListPositiveRm.add(arp);
                arListNegativeRm.add(arn);
            }
            if (arn.getVerAmt().add(arp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(this.buildSettleForApOffset((FinApPayVerApplyApSaveDTO)arn, null));
                arp.setVerAmt(arp.getVerAmt().add(arn.getVerAmt()));
                arn.setVerAmt(BigDecimal.ZERO);
                arListNegativeRm.add(arn);
            }
        }));
        arListPositive.removeAll(arListPositiveRm);
        arListNegative.removeAll(arListNegativeRm);
        if (CollectionUtils.isNotEmpty(arListPositive)) {
            Optional<FinApPayVerApplyApSaveDTO> first = arListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForApOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListPositive;
        }
        if (CollectionUtils.isNotEmpty(arListNegative)) {
            Optional<FinApPayVerApplyApSaveDTO> first = arListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForApOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return arListNegative;
        }
        return null;
    }

    private List<FinApPayVerApplyPaySaveDTO> doSettleForPayOffset(List<FinApPayVerApplyPaySaveDTO> recListPositive, List<FinApPayVerApplyPaySaveDTO> recListNegative, List<FinApPayVerApplySettleSaveDTO> settles) {
        recListPositive.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        recListNegative.forEach(v -> v.setOrigVerAmt(v.getVerAmt()));
        List recListPositiveSorted = recListPositive.stream().sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt)).collect(Collectors.toList());
        List recListNegativeSorted = recListNegative.stream().sorted(Comparator.comparing(FinApPayVerApplyPaySaveDTO::getVerAmt)).collect(Collectors.toList());
        Collections.reverse(recListNegativeSorted);
        ArrayList recListPositiveRm = new ArrayList();
        ArrayList recListNegativeRm = new ArrayList();
        recListNegativeSorted.stream().forEach(recn -> recListPositiveSorted.stream().forEach(recp -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = BigDecimal.ZERO.compareTo(recn.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(recp.getVerAmt()) == 0;
            if (writeOffFlag) {
                return;
            }
            if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) < 0) {
                settles.add(this.buildSettleForPayOffset((FinApPayVerApplyPaySaveDTO)recp, null));
                recn.setVerAmt(recn.getVerAmt().add(recp.getVerAmt()));
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
            } else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) == 0) {
                settles.add(this.buildSettleForPayOffset((FinApPayVerApplyPaySaveDTO)recn, null));
                settles.add(this.buildSettleForPayOffset((FinApPayVerApplyPaySaveDTO)recp, null));
                recn.setVerAmt(BigDecimal.ZERO);
                recp.setVerAmt(BigDecimal.ZERO);
                recListPositiveRm.add(recp);
                recListNegativeRm.add(recn);
            } else if (recn.getVerAmt().add(recp.getVerAmt()).compareTo(BigDecimal.ZERO) > 0) {
                settles.add(this.buildSettleForPayOffset((FinApPayVerApplyPaySaveDTO)recn, null));
                recp.setVerAmt(recp.getVerAmt().add(recn.getVerAmt()));
                recn.setVerAmt(BigDecimal.ZERO);
                recListNegativeRm.add(recn);
            }
        }));
        recListPositive.removeAll(recListPositiveRm);
        recListNegative.removeAll(recListNegativeRm);
        if (CollectionUtils.isNotEmpty(recListPositive)) {
            Optional<FinApPayVerApplyPaySaveDTO> first = recListPositive.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForPayOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListPositive;
        }
        if (CollectionUtils.isNotEmpty(recListNegative)) {
            Optional<FinApPayVerApplyPaySaveDTO> first = recListNegative.stream().filter(v -> !v.getVerAmt().equals(v.getOrigVerAmt())).findFirst();
            if (first.isPresent()) {
                settles.add(this.buildSettleForPayOffset(first.get(), first.get().getOrigVerAmt().subtract(first.get().getVerAmt())));
            }
            return recListNegative;
        }
        return null;
    }

    private List<FinApPayVerApplySettleSaveDTO> doSettle(List<FinApPayVerApplyApSaveDTO> arList, List<FinApPayVerApplyPaySaveDTO> recList) {
        ArrayList<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<FinApPayVerApplySettleSaveDTO>();
        arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
            boolean writeOffFlag;
            boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
            if (writeOffFlag) {
                return;
            }
            if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                ar.setVerAmt(BigDecimal.ZERO);
                rec.setVerAmt(BigDecimal.ZERO);
            } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, rec.getVerAmt()));
                ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                rec.setVerAmt(BigDecimal.ZERO);
            }
        }));
        return settles;
    }

    private List<FinApPayVerApplySettleSaveDTO> doSettleNew(List<FinApPayVerApplyApSaveDTO> arList, List<FinApPayVerApplyPaySaveDTO> recList) {
        boolean isPositive = arList.get(0).getVerAmt().compareTo(BigDecimal.ZERO) > 0;
        ArrayList<FinApPayVerApplySettleSaveDTO> settles = new ArrayList<FinApPayVerApplySettleSaveDTO>();
        if (isPositive) {
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                boolean writeOffFlag;
                boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                }
            }));
        } else {
            arList.stream().forEach(ar -> recList.stream().forEach(rec -> {
                boolean writeOffFlag;
                boolean bl = writeOffFlag = (BigDecimal.ZERO.compareTo(ar.getVerAmt()) == 0 || BigDecimal.ZERO.compareTo(rec.getVerAmt()) == 0) && settles.size() != 0;
                if (writeOffFlag) {
                    return;
                }
                if (ar.getVerAmt().compareTo(rec.getVerAmt()) < 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, rec.getVerAmt()));
                    ar.setVerAmt(ar.getVerAmt().subtract(rec.getVerAmt()));
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) == 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                    rec.setVerAmt(BigDecimal.ZERO);
                } else if (ar.getVerAmt().compareTo(rec.getVerAmt()) > 0) {
                    settles.add(this.buildSettle((FinApPayVerApplyApSaveDTO)ar, (FinApPayVerApplyPaySaveDTO)rec, ar.getVerAmt()));
                    rec.setVerAmt(rec.getVerAmt().subtract(ar.getVerAmt()));
                    ar.setVerAmt(BigDecimal.ZERO);
                }
            }));
        }
        return settles;
    }

    private FinApPayVerApplySettleSaveDTO buildSettle(FinApPayVerApplyApSaveDTO ap, FinApPayVerApplyPaySaveDTO pay, BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
        settle.setApId(ap.getApId());
        settle.setApDocNo(ap.getApDocNo());
        settle.setOutApDocNo(ap.getOutApDocNo());
        settle.setApDId(ap.getApDId());
        settle.setOutApDId(ap.getOutApDId());
        settle.setPayId(pay.getPayId());
        settle.setPayDocNo(pay.getPayDocNo());
        settle.setOutPayDocNo(pay.getOutPayDocNo());
        settle.setPayDId(pay.getPayDId());
        settle.setOutPayDId(pay.getOutPayDId());
        settle.setApCustCode(ap.getCustCode());
        settle.setPayCustCode(pay.getCustCode());
        settle.setApNotVerAmt(ap.getNotVerAmt());
        settle.setPayNotVerAmt(pay.getNotVerAmt());
        settle.setVerAmt(verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_NORMAL.getValueCode());
        return settle;
    }

    private FinApPayVerApplySettleSaveDTO buildSettleForApOffset(FinApPayVerApplyApSaveDTO apOffset, BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
        settle.setApId(apOffset.getApId());
        settle.setApDocNo(apOffset.getApDocNo());
        settle.setOutApDocNo(apOffset.getOutApDocNo());
        settle.setApDId(apOffset.getApDId());
        settle.setOutApDId(apOffset.getOutApDId());
        settle.setApCustCode(apOffset.getCustCode());
        settle.setApNotVerAmt(apOffset.getNotVerAmt());
        settle.setVerAmt(verAmt == null ? apOffset.getOrigVerAmt() : verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }

    private FinApPayVerApplySettleSaveDTO buildSettleForPayOffset(FinApPayVerApplyPaySaveDTO payOffset, BigDecimal verAmt) {
        FinApPayVerApplySettleSaveDTO settle = new FinApPayVerApplySettleSaveDTO();
        settle.setPayId(payOffset.getPayId());
        settle.setPayDocNo(payOffset.getPayDocNo());
        settle.setOutPayDocNo(payOffset.getOutPayDocNo());
        settle.setPayDId(payOffset.getPayDId());
        settle.setOutPayDId(payOffset.getOutPayDId());
        settle.setPayCustCode(payOffset.getCustCode());
        settle.setPayNotVerAmt(payOffset.getNotVerAmt());
        settle.setVerAmt(verAmt == null ? payOffset.getOrigVerAmt() : verAmt);
        settle.setVerFlag(WriteoffUdcEnum.FIN_VERIFY_FLAG_INTERNAL.getValueCode());
        return settle;
    }

    public FinApPayVerApplyServiceImpl(FinApPayVerApplyRepoProc finApPayVerApplyRepoProc, FinApPayVerApplyApService finApPayVerApplyApService, FinApPayVerApplyApHeadService finApPayVerApplyApHeadService, FinApPayVerApplyPayService finApPayVerApplyPayService, FinApPayVerApplyPayHeadService finApPayVerApplyPayHeadService, SeqNumProvider seqNumProvider, FinApPayVerApplySettleService finApPayVerApplySettleService, OperationLogService operationLogService, ThreadLocalCopyUtil threadLocalCopyUtil, ApOrderDtlService apOrderDtlService, PayOrderDtlService payOrderDtlService, ApOrderService apOrderService, PayOrderService payOrderService) {
        this.finApPayVerApplyRepoProc = finApPayVerApplyRepoProc;
        this.finApPayVerApplyApService = finApPayVerApplyApService;
        this.finApPayVerApplyApHeadService = finApPayVerApplyApHeadService;
        this.finApPayVerApplyPayService = finApPayVerApplyPayService;
        this.finApPayVerApplyPayHeadService = finApPayVerApplyPayHeadService;
        this.seqNumProvider = seqNumProvider;
        this.finApPayVerApplySettleService = finApPayVerApplySettleService;
        this.operationLogService = operationLogService;
        this.threadLocalCopyUtil = threadLocalCopyUtil;
        this.apOrderDtlService = apOrderDtlService;
        this.payOrderDtlService = payOrderDtlService;
        this.apOrderService = apOrderService;
        this.payOrderService = payOrderService;
    }
}

