/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlConvert;
import com.elitesland.fin.application.convert.aporder.ApOrderDtlGroupConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroup;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlGroupDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlGroupDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.factory.aporder.ApOrderFactory;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlGroupRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.pur.dto.PurAccountDTO;
import com.elitesland.workflow.ProcessInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderDomainServiceImpl
implements ApOrderDomainService {
    private final ApOrderRepo apOrderRepo;
    private final ApOrderRepoProc apOrderRepoProc;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ApOrderFactory apOrderFactory;
    private final ApOrderDtlGroupRepo apOrderDtlGroupRepo;
    private final ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc;
    private final SeqNumProvider sysNumberRuleService;
    private final ApOrderToPayDomainService apOrderToPayDomainService;
    private final RmiPurRpcService rmiPurRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApOrder apOrder) {
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            apOrder.checkAmt();
            apOrder.checkAmtSum();
        }
        if (apOrder.getCreateMode().equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            apOrder.setPacckDef();
            apOrder.countByPacck();
            List<ApOrderDtlGroup> apOrderDtlGroups = this.genDtlGroup(apOrder);
            apOrder.setApOrderDtlGroupList(apOrderDtlGroups);
        }
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    public List<ApOrderDtlGroup> genDtlGroup(ApOrder apOrder) {
        List<ApOrderDtl> res = apOrder.getApOrderDtlList();
        Map<String, List<ApOrderDtl>> collectMaps = res.stream().collect(Collectors.groupingBy(ApOrderDtl::getItemCode));
        ArrayList<ApOrderDtlGroup> resList = new ArrayList<ApOrderDtlGroup>();
        for (Map.Entry<String, List<ApOrderDtl>> entry : collectMaps.entrySet()) {
            ApOrderDtlGroup apOrderDtlGroup = new ApOrderDtlGroup();
            List<ApOrderDtl> apOrderDtlList = entry.getValue();
            BigDecimal qtySum = apOrderDtlList.stream().map(ApOrderDtl::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal exclTaxCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCurAmtSum = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            apOrderDtlGroup.setItemId(apOrderDtlList.get(0).getItemId());
            apOrderDtlGroup.setItemCode(apOrderDtlList.get(0).getItemCode());
            apOrderDtlGroup.setItemName(apOrderDtlList.get(0).getItemName());
            apOrderDtlGroup.setSmallCateCode(apOrderDtlList.get(0).getSmallCateCode());
            apOrderDtlGroup.setSmallCateName(apOrderDtlList.get(0).getSmallCateName());
            apOrderDtlGroup.setQty(qtySum);
            apOrderDtlGroup.setTotalAmt(totalAmtSum);
            apOrderDtlGroup.setExclTaxAmt(exclTaxAmtSum);
            apOrderDtlGroup.setTaxAmt(taxAmtSum);
            apOrderDtlGroup.setTotalCurAmt(totalCurAmtSum);
            apOrderDtlGroup.setExclTaxCurAmt(exclTaxCurAmtSum);
            apOrderDtlGroup.setTaxCurAmt(taxCurAmtSum);
            resList.add(apOrderDtlGroup);
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApOrderDO saveOrUpdate(ApOrder apOrder) {
        ApOrderDO apOrderDO;
        if (CharSequenceUtil.isBlank((CharSequence)apOrder.getApOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YFD", null);
            apOrder.setApOrderNo(apOrderNo);
        }
        if ((apOrderDO = ApOrderConvert.INSTANCE.convert(apOrder)).getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ApOrderDO apOrderRes = (ApOrderDO)this.apOrderRepo.save(apOrderDO);
        this.apOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtl> apOrderDtlList = apOrder.getApOrderDtlList();
        List<ApOrderDtlDO> apOrderDtlDOS = ApOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        apOrderDtlDOS.stream().forEach(x -> {
            x.setMasId(apOrderRes.getId());
            if (Objects.isNull(x.getId())) {
                x.setVerAmt(x.getTotalAmt());
                x.setUnVerAmt(BigDecimal.ZERO);
                x.setApplyVerAmTing(BigDecimal.ZERO);
            } else {
                if (Objects.isNull(x.getVerAmt())) {
                    x.setVerAmt(x.getTotalAmt());
                }
                if (Objects.isNull(x.getUnVerAmt())) {
                    x.setUnVerAmt(BigDecimal.ZERO);
                }
                if (Objects.isNull(x.getApplyVerAmTing())) {
                    x.setApplyVerAmTing(BigDecimal.ZERO);
                }
            }
            this.apOrderDtlRepo.save(x);
        });
        this.apOrderDtlGroupRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ApOrderDtlGroup> apOrderDtlGroups = apOrder.getApOrderDtlGroupList();
        if (null != apOrderDtlGroups) {
            List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = ApOrderDtlGroupConvert.INSTANCE.convert(apOrderDtlGroups);
            apOrderDtlGroupDOS.stream().forEach(x -> {
                x.setMasId(apOrderRes.getId());
                this.apOrderDtlGroupRepo.save(x);
            });
        }
        return apOrderRes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long commit(ApOrder apOrder) {
        apOrder.check();
        apOrder.checkDtlList();
        if (apOrder.getVerAmt() == null) {
            apOrder.setDef();
        }
        apOrder.checkAmt();
        apOrder.checkAmtSum();
        apOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        ApOrderDO apOrderRes = this.saveOrUpdate(apOrder);
        return apOrderRes.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.apOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    @Override
    public ApOrderDTO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.get(id);
        List<ApOrderDtlDTO> apOrderDtlDOS = this.apOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlDTOList(apOrderDtlDOS);
        List<ApOrderDtlGroupDTO> apOrderDtlGroupDTOS = this.apOrderDtlGroupRepoProc.listByMisId(id);
        apOrderDTO.setApOrderDtlGroupDTOList(apOrderDtlGroupDTOS);
        return apOrderDTO;
    }

    @Override
    public List<ApOrderDTO> queryByIds(List<Long> ids) {
        return this.apOrderRepoProc.queryByIds(ids);
    }

    @Override
    public List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam) {
        List<ApOrderDTO> res = this.apOrderRepoProc.getApOrderList(apOrderParam);
        return res;
    }

    @Override
    public Boolean queryByApTypeId(Long apTypeId) {
        return this.apOrderRepoProc.queryByApTypeId(apTypeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Retryable(value={BusinessException.class}, maxAttempts=5, backoff=@Backoff(value=500L))
    public void updateVerAmt(Long id, BigDecimal amt) {
        BigDecimal totalAmt;
        ApVerDTO apVerDTO = this.apOrderRepoProc.queryVerAmtById(id);
        if (Objects.isNull(apVerDTO)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u4fe1\u606f");
        }
        BigDecimal bigDecimal = totalAmt = Objects.isNull(apVerDTO.getTotalAmt()) ? BigDecimal.ZERO : apVerDTO.getTotalAmt();
        if (apVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u4ed8\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        apVerDTO.setAmtAndVerState(amt);
        long rows = this.apOrderRepoProc.updateVerAmt(apVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = this.apOrderFactory.page(apOrderPageParam);
        return res;
    }

    @Override
    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> res = this.apOrderFactory.writeoffPage(apOrderPageParam);
        return res;
    }

    @Override
    public ApOrderDTO get(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderRepoProc.get(id);
        return apOrderDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.apOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<ApOrderDTO> apOrderDTOList = this.apOrderRepoProc.queryByIds(ids);
        HashMap createSourceMap = new HashMap();
        apOrderDTOList.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            if (Objects.nonNull(x.getRedSourceNo())) {
                this.apOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });
        for (Map.Entry entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AP_DOC_CLS", (String)entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                case FIN_AP_DOC_CLS_PACCK: {
                    this.rmiPurRpcService.batchUpdateDocStatus(PurAccountDTO.builder().docStatus(UdcEnum.PUR_ACCOUNT_CHECK_STATUS_DONE.getValueCode()).docNos((List)entry.getValue()).build());
                    break;
                }
            }
        }
        Long res = this.apOrderRepoProc.del(ids);
        this.apOrderDtlRepoProc.delByMasId(ids);
        this.apOrderDtlGroupRepoProc.delByMasId(ids);
        return res;
    }

    @Override
    public void restDocState(List<Long> ids) {
        List apOrderDOS = this.apOrderRepo.findAllById(ids);
        this.checkCancelDoc(apOrderDOS);
        apOrderDOS.forEach(apOrderDO -> {
            apOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            apOrderDO.setProposedStatus(null);
            apOrderDO.setProcInstId(null);
            apOrderDO.setProcInstStatus(null);
        });
        this.apOrderRepo.saveAll(apOrderDOS);
    }

    void checkCancelDoc(List<ApOrderDO> apOrderDOS) {
        if (CollectionUtils.isEmpty(apOrderDOS)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        List<Long> ids = apOrderDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map<Long, List<ApOrderToPayDTO>> apOrderPayMap = this.apOrderToPayDomainService.queryByApId(ids).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        apOrderDOS.forEach(apOrderDO -> {
            String perfix = "\u5355\u53f7\uff1a" + apOrderDO.getApOrderNo() + "-";
            if (CollectionUtils.isNotEmpty((Collection)((Collection)apOrderPayMap.get(apOrderDO.getId())))) {
                throw new BusinessException(perfix + "\u5df2\u7ecf\u751f\u6210\u4ed8\u6b3e\u5355");
            }
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(apOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(apOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (BigDecimal.ZERO.compareTo(apOrderDO.getVerAmt()) != 0) {
                throw new BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(apOrderDO.getRedState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApOrder redPunchCreate(Long id) {
        ApOrderDO apOrderDO = (ApOrderDO)this.apOrderRepo.findById(id).get();
        apOrderDO.setRedState(Boolean.TRUE);
        this.apOrderRepo.save(apOrderDO);
        ApOrder newApOrder = (ApOrder)BeanUtils.toBean((Object)apOrderDO, ApOrder.class);
        newApOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newApOrder.setProcInstId(null);
        newApOrder.setProcInstStatus(null);
        newApOrder.setRedState(null);
        newApOrder.setRedSourceNo(apOrderDO.getApOrderNo());
        newApOrder.setRedSourceId(apOrderDO.getId());
        newApOrder.setTaxAmt(apOrderDO.getTaxAmt().negate());
        newApOrder.setTotalAmt(apOrderDO.getTotalAmt().negate());
        newApOrder.setExclTaxAmt(apOrderDO.getExclTaxAmt().negate());
        newApOrder.setTotalCurAmt(apOrderDO.getTotalCurAmt().negate());
        newApOrder.setTaxCurAmt(apOrderDO.getTaxCurAmt().negate());
        newApOrder.setExclTaxCurAmt(apOrderDO.getExclTaxCurAmt().negate());
        newApOrder.setId(null);
        newApOrder.setApOrderNo(null);
        newApOrder.setProposedStatus(null);
        newApOrder.setAuditUser(null);
        newApOrder.setApprovedTime(null);
        newApOrder.setAuditUserId(null);
        newApOrder.setRemark(null);
        List<ApOrderDtlDO> dtls = this.apOrderDtlRepo.findAllByMasId(id);
        List<ApOrderDtl> newDtls = dtls.stream().map(dtl -> {
            ApOrderDtl dtlDO = (ApOrderDtl)BeanUtils.toBean((Object)dtl, ApOrderDtl.class);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlList(newDtls);
        List<ApOrderDtlGroupDO> apOrderDtlGroupDOS = this.apOrderDtlGroupRepo.findAllByMasId(id);
        List<ApOrderDtlGroup> groupList = apOrderDtlGroupDOS.stream().map(dtl -> {
            ApOrderDtlGroup dtlDO = (ApOrderDtlGroup)BeanUtils.toBean((Object)dtl, ApOrderDtlGroup.class);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            return dtlDO;
        }).collect(Collectors.toList());
        newApOrder.setApOrderDtlGroupList(groupList);
        return newApOrder;
    }

    public ApOrderDomainServiceImpl(ApOrderRepo apOrderRepo, ApOrderRepoProc apOrderRepoProc, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDtlRepo apOrderDtlRepo, ApOrderFactory apOrderFactory, ApOrderDtlGroupRepo apOrderDtlGroupRepo, ApOrderDtlGroupRepoProc apOrderDtlGroupRepoProc, SeqNumProvider sysNumberRuleService, ApOrderToPayDomainService apOrderToPayDomainService, RmiPurRpcService rmiPurRpcService) {
        this.apOrderRepo = apOrderRepo;
        this.apOrderRepoProc = apOrderRepoProc;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.apOrderFactory = apOrderFactory;
        this.apOrderDtlGroupRepo = apOrderDtlGroupRepo;
        this.apOrderDtlGroupRepoProc = apOrderDtlGroupRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
        this.apOrderToPayDomainService = apOrderToPayDomainService;
        this.rmiPurRpcService = rmiPurRpcService;
    }
}

