/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arverconfig;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigDtlConvert;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfig;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfigDO;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfigDtlDO;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepo;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepoProc;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigRepo;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigRepoProc;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArVerConfigDomainServiceImpl
implements ArVerConfigDomainService {
    private final ArVerConfigRepo arVerConfigRepo;
    private final ArVerConfigRepoProc arVerConfigRepoProc;
    private final ArVerConfigDtlRepo arVerConfigDtlRepo;
    private final ArVerConfigDtlRepoProc arVerConfigDtlRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(ArVerConfig arVerConfig) {
        arVerConfig.checkNotNull();
        arVerConfig.defaultValue();
        if (arVerConfig.getId() == null) {
            arVerConfig.setDefaultFlag(this.arVerConfigRepoProc.isFirst() == false);
            Boolean nameByName = this.arVerConfigRepoProc.existNameByName(arVerConfig.getSchemeName());
            if (nameByName.booleanValue()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u65b9\u6848\u540d\u79f0!");
            }
        } else {
            Boolean existNameById = this.arVerConfigRepoProc.existNameById(arVerConfig.getSchemeName(), arVerConfig.getId());
            if (existNameById.booleanValue()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u65b9\u6848\u540d\u79f0!");
            }
        }
        return this.saveOrUpdate(arVerConfig).toString();
    }

    @Override
    public ArVerConfigDTO queryById(Long id) {
        ArVerConfigDTO apVerConfigDTO = this.arVerConfigRepoProc.queryById(id);
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = this.arVerConfigDtlRepoProc.queryByMasId(id);
        apVerConfigDTO.setArVerConfigDtlDTOS(arVerConfigDtlDTOS);
        return apVerConfigDTO;
    }

    @Override
    public PagingVO<ArVerConfigDTO> page(ArVerConfigPageParam param) {
        return this.arVerConfigRepoProc.page(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEnable(List<Long> ids) {
        List<ArVerConfigDTO> arVerConfigDTOS = this.arVerConfigRepoProc.queryByIds(ids);
        arVerConfigDTOS.forEach(dto -> {
            if (!dto.getEnableFlag().booleanValue()) {
                throw new BusinessException("\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u505c\u7528!");
            }
        });
        this.arVerConfigRepoProc.updateEnable(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDef(Long id) {
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigRepoProc.queryById(id);
        if (arVerConfigDTO.getDefaultFlag().booleanValue()) {
            throw new BusinessException("\u5df2\u9ed8\u8ba4\u72b6\u6001\u4e0d\u5141\u8bb8\u518d\u6b21\u9ed8\u8ba4!");
        }
        this.arVerConfigRepoProc.updateDefault();
        return this.arVerConfigRepoProc.updateDefaultById(id, true);
    }

    @Override
    public List<ArVerConfigDTO> queryAll() {
        return this.arVerConfigRepoProc.queryAll();
    }

    @Override
    public ArVerConfigDTO queryDef() {
        return this.arVerConfigRepoProc.queryDef();
    }

    @Override
    public List<ArVerConfigDtlDTO> queryDtl() {
        return this.arVerConfigDtlRepoProc.queryNoMasId();
    }

    @Override
    public List<ArVerConfigDtlDTO> queryByMasId(Long masId) {
        return this.arVerConfigDtlRepoProc.queryByMasId(masId);
    }

    private Long saveOrUpdate(ArVerConfig arVerConfig) {
        ArVerConfigDO arVerConfigDO = ArVerConfigConvert.INSTANCE.convert(arVerConfig);
        if (arVerConfig.getId() != null) {
            this.arVerConfigDtlRepoProc.deleteByMasId(arVerConfig.getId());
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "HXFA", null);
            arVerConfigDO.setSchemeNo(payOrderNo);
        }
        ArVerConfigDO arVerConfigDO1 = (ArVerConfigDO)this.arVerConfigRepo.save(arVerConfigDO);
        arVerConfig.getConfigDtlList().forEach(dtl -> dtl.setMasId(arVerConfigDO1.getId()));
        List<ArVerConfigDtlDO> arVerConfigDtlDOS = ArVerConfigDtlConvert.INSTANCE.convertDo(arVerConfig.getConfigDtlList());
        this.arVerConfigDtlRepo.saveAll(arVerConfigDtlDOS);
        return arVerConfigDO1.getId();
    }

    public ArVerConfigDomainServiceImpl(ArVerConfigRepo arVerConfigRepo, ArVerConfigRepoProc arVerConfigRepoProc, ArVerConfigDtlRepo arVerConfigDtlRepo, ArVerConfigDtlRepoProc arVerConfigDtlRepoProc, SeqNumProvider sysNumberRuleService) {
        this.arVerConfigRepo = arVerConfigRepo;
        this.arVerConfigRepoProc = arVerConfigRepoProc;
        this.arVerConfigDtlRepo = arVerConfigDtlRepo;
        this.arVerConfigDtlRepoProc = arVerConfigDtlRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

