/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.aporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ApOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.param.aporder.FinApOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderDtlVO;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.common.WriteoffUdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepoProc;
import com.elitesland.fin.repo.writeoff.ApOrderDetailRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ApOrderServiceImpl
implements ApOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderServiceImpl.class);
    private final ApOrderDomainService apOrderDomainService;
    private final ApOrderDtlDomainService apOrderDtlDomainService;
    private final WorkflowRpcService workflowRpcService;
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDetailRepoProc apOrderDetailRepoProc;
    private final ApVerConfigDomainService apVerConfigDomainService;
    private final ApVerConfigDtlRepoProc apVerConfigDtlRepoProc;
    private final PayOrderService payOrderService;
    private final FinApPayVerApplyService finApPayVerApplyService;

    @Override
    @SysCodeProc
    public PagingVO<ApOrderVO> page(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<ApOrderVO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.writeoffPage(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        if (res.isEmpty()) {
            return res;
        }
        List<Long> masIds = res.getRecords().stream().map(ApOrderVO::getId).collect(Collectors.toList());
        List<ApOrderDtlDTO> apOrderDtlDTOS = this.apOrderDtlRepoProc.listByMasIds(masIds);
        Map apOrderDtlDTOMap = apOrderDtlDTOS.stream().collect(Collectors.groupingBy(ApOrderDtlDTO::getMasId, Collectors.toList()));
        res.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List arOrderDtlDTOS1 = (List)apOrderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)arOrderDtlDTOS1)) {
                for (ApOrderDtlDTO apOrderDtlDTO : arOrderDtlDTOS1) {
                    verAmt = verAmt.add(apOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(apOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(apOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        return res;
    }

    @Override
    @SysCodeProc
    public ApOrderVO get(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.get(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.apOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.apOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ApOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> commit(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long resId = this.apOrderDomainService.commit(apOrder);
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u4ed8\u5355\u5ba1\u6838-" + apOrder.getApOrderNo();
            String procKey = WorkFlowDefKey.FIN_AP_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.apOrderDomainService.updateWorkInfo(processInfo, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ApOrderSaveParam apOrderSaveParam) {
        ApOrder apOrder = ApOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.apOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApOrderVO getApOrderAndDtl(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.getApOrderAndDtl(id);
        ApOrderVO res = ApOrderConvert.INSTANCE.convert(apOrderDTO);
        return res;
    }

    @Override
    @SysCodeProc
    public void exportExl(HttpServletResponse response, ApOrderPageParam apOrderPageParam) {
        PagingVO<ApOrderDTO> page = this.apOrderDomainService.page(apOrderPageParam);
        PagingVO<ApOrderVO> res = ApOrderConvert.INSTANCE.convertPage(page);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u91c7\u8d2d\u7ed3\u7b97\u5355", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write((OutputStream)response.getOutputStream(), ApOrderVO.class).sheet("\u91c7\u8d2d\u7ed3\u7b97\u5355").doWrite(res.getRecords());
        }
        catch (IOException e) {
            log.error("\u91c7\u8d2d\u7ed3\u7b97\u5355\u5bfc\u51fa\u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
        }
    }

    @Override
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        this.apOrderDomainService.restDocState(ids);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Long> redPunch(Long id) {
        ApOrderDTO apOrderDTO = this.apOrderDomainService.get(id);
        this.checkRedPunch(apOrderDTO);
        ApOrder apOrder = this.apOrderDomainService.redPunchCreate(id);
        apOrder.setCheck(false);
        return this.commit(ApOrderConvert.INSTANCE.convertParam(apOrder));
    }

    void checkRedPunch(ApOrderDTO apOrderDTO) {
        if (Objects.isNull(apOrderDTO)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(apOrderDTO.getRedState())) {
            throw new BusinessException("\u5355\u636e\u5df2\u7ea2\u51b2");
        }
        if (Objects.nonNull(apOrderDTO.getRedSourceNo())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u4e3a\u7ea2\u51b2\u5355\u636e");
        }
        if (BigDecimal.ZERO.compareTo(apOrderDTO.getVerAmt()) != 0) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(apOrderDTO.getOrderState())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long apDId, BigDecimal amt) {
        ApOrderDtlDO detail = this.findDetail(apDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    @NotNull
    private ApOrderDtlDO findDetail(Long arDId) {
        ApOrderDtlDO detail = this.apOrderDetailRepoProc.getApOrderDetailAmt(arDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u5e94\u6536\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + arDId));
        return detail;
    }

    private void doUpdateVerAmt(ApOrderAmtUpdateDTO update) {
        if (this.apOrderDetailRepoProc.updateVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getAuditDataVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long apDId, BigDecimal amt, String verType) {
        ApOrderDtlDO detail = this.findDetail(apDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @NotNull
    private ApOrderAmtUpdateDTO.ApOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ApOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return ApOrderAmtUpdateDTO.builder().apDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    @Override
    public List<ApOrderDtlVO> listApOrderDetail(FinApOrderDetailQuery query) {
        return this.apOrderDetailRepoProc.listArOrderDetail(query);
    }

    @Override
    public void autoWriteoff(ApOrderDTO apOrderDTO) {
        Long apId = apOrderDTO.getId();
        ApOrderDTO apOrderDTO1 = this.apOrderDomainService.get(apId);
        if (apOrderDTO1 == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u4ed8\u5355\uff0c\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25\uff0c\u5355\u636eID\uff1a{}", (Object)apId);
            return;
        }
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigDomainService.queryDef();
        if (apVerConfigDTO == null) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u4ed8\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)apOrderDTO1.getApOrderNo());
            return;
        }
        List<ApVerConfigDtlDTO> arVerConfigDtlDTOS = this.apVerConfigDtlRepoProc.queryByMasId(apVerConfigDTO.getId());
        if (CollectionUtils.isEmpty(arVerConfigDtlDTOS)) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u4ed8\u5355\uff0c\u672a\u67e5\u8be2\u5230\u6838\u9500\u65b9\u6848\u660e\u7ec6\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)apOrderDTO1.getApOrderNo());
            return;
        }
        Boolean redOffsetFlag = apVerConfigDTO.getRedOffsetFlag();
        String writeoffOrder = apVerConfigDTO.getWriteoffOrder();
        String ou_code = null;
        Long ou_id = null;
        String supp_code = null;
        Long supp_id = null;
        String curr_code = null;
        String so_doc_no = null;
        for (ApVerConfigDtlDTO arVerConfigDtlDTO : arVerConfigDtlDTOS) {
            if ("ou_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                ou_code = apOrderDTO1.getOuCode();
                ou_id = apOrderDTO1.getOuId();
                continue;
            }
            if ("supp_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                supp_id = apOrderDTO1.getSuppId();
                supp_code = apOrderDTO1.getSuppCode();
                continue;
            }
            if ("curr_code".equals(arVerConfigDtlDTO.getFieldNo()) && arVerConfigDtlDTO.getMatchFlag().booleanValue()) {
                curr_code = apOrderDTO1.getCurrCode();
                continue;
            }
            if (!"so_doc_no".equals(arVerConfigDtlDTO.getFieldNo()) || !arVerConfigDtlDTO.getMatchFlag().booleanValue()) continue;
            so_doc_no = apOrderDTO1.getSourceNo();
        }
        boolean asc = true;
        if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_FRONT_BACK.getValueCode().equals(writeoffOrder)) {
            asc = true;
        } else if (WriteoffUdcEnum.FIN_WRITEOFF_ORDER_BUDATE_BACK_FRONT.getValueCode().equals(writeoffOrder)) {
            asc = false;
        }
        boolean finAsc = asc;
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("buDate");
        orderItem.setAsc(asc);
        orders.add(orderItem);
        PagingVO<ApOrderVO> apOrderVOPagingVO = null;
        if (redOffsetFlag.booleanValue()) {
            ApOrderPageParam apOrderPageParam = new ApOrderPageParam();
            apOrderPageParam.setOuCode(ou_code);
            apOrderPageParam.setSuppCode(supp_code);
            apOrderPageParam.setCurrCode(curr_code);
            apOrderPageParam.setOrders(orders);
            apOrderPageParam.setSize(Integer.MAX_VALUE);
            apOrderVOPagingVO = this.writeoffPage(apOrderPageParam);
        }
        PayOrderPageParam payOrderPageParam = new PayOrderPageParam();
        payOrderPageParam.setOuId(ou_id);
        payOrderPageParam.setSuppId(supp_id);
        payOrderPageParam.setCurrCode(curr_code);
        orderItem.setColumn("buDate");
        payOrderPageParam.setOrders(orders);
        payOrderPageParam.setSize(Integer.MAX_VALUE);
        PagingVO<PayOrderVO> payOrderVOPagingVO = this.payOrderService.writeoffPage(payOrderPageParam);
        ArrayList allList = new ArrayList();
        List apOrderVOS = null;
        if (apOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)apOrderVOPagingVO.getRecords())) {
            apOrderVOS = apOrderVOPagingVO.getRecords().stream().filter(v -> !v.getId().equals(apId)).collect(Collectors.toList());
            allList.addAll(apOrderVOS);
        }
        if (payOrderVOPagingVO != null && CollectionUtils.isNotEmpty((Collection)payOrderVOPagingVO.getRecords())) {
            allList.addAll(payOrderVOPagingVO.getRecords());
        }
        if (CollectionUtils.isEmpty(allList)) {
            log.error("\u81ea\u52a8\u6838\u9500\u5e94\u4ed8\u5355\uff0c\u672a\u5339\u914d\u5230\u5f85\u6838\u9500\u5355\u636e\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)apOrderDTO1.getApOrderNo());
            return;
        }
        CollUtil.sort(allList, (o1, o2) -> {
            if (finAsc) {
                return o1.getBuDate().compareTo(o2.getBuDate());
            }
            return o2.getBuDate().compareTo(o1.getBuDate());
        });
        BigDecimal unVerAmtBalance = apOrderDTO1.getTotalAmt();
        List matchList = null;
        for (WriteoffVO writeoffVO : allList) {
            if (writeoffVO.getUnVerAmt().equals(unVerAmtBalance)) {
                matchList.add(writeoffVO);
                break;
            }
            if (writeoffVO.getUnVerAmt().compareTo(unVerAmtBalance) < 0) {
                matchList.add(writeoffVO);
                unVerAmtBalance = unVerAmtBalance.subtract(writeoffVO.getUnVerAmt());
                continue;
            }
            writeoffVO.setUnVerAmt(unVerAmtBalance);
            matchList.add(writeoffVO);
            break;
        }
        if (unVerAmtBalance.compareTo(BigDecimal.ZERO) > 0) {
            log.info("\u81ea\u52a8\u6838\u9500\u5e94\u4ed8\u5355\uff0c\u672a\u5339\u914d\u5230\u8db3\u591f\u7684\u6838\u9500\u91d1\u989d\uff0c\u5355\u636e\u7f16\u7801\uff1a{}", (Object)apOrderDTO1.getApOrderNo());
            return;
        }
        this.finApPayVerApplyService.autoWriteoff(matchList);
    }

    public ApOrderServiceImpl(ApOrderDomainService apOrderDomainService, ApOrderDtlDomainService apOrderDtlDomainService, WorkflowRpcService workflowRpcService, ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDetailRepoProc apOrderDetailRepoProc, ApVerConfigDomainService apVerConfigDomainService, ApVerConfigDtlRepoProc apVerConfigDtlRepoProc, PayOrderService payOrderService, FinApPayVerApplyService finApPayVerApplyService) {
        this.apOrderDomainService = apOrderDomainService;
        this.apOrderDtlDomainService = apOrderDtlDomainService;
        this.workflowRpcService = workflowRpcService;
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDetailRepoProc = apOrderDetailRepoProc;
        this.apVerConfigDomainService = apVerConfigDomainService;
        this.apVerConfigDtlRepoProc = apVerConfigDtlRepoProc;
        this.payOrderService = payOrderService;
        this.finApPayVerApplyService = finApPayVerApplyService;
    }
}

