/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.arorder;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.workflow.arorder.ArOrderProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderProcessServiceImpl
implements ArOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(ArOrderProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final ArOrderRepoProc arOrderRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final ArOrderService arOrderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        if (arOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QArOrderDO qRecOrderDO = QArOrderDO.arOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qRecOrderDO).set(qRecOrderDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qRecOrderDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set((Path)qRecOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(qRecOrderDO.submitTime, (Object)LocalDateTime.now());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditRejection, (Object)commentInfo.getComment()).set((Path)qRecOrderDO.procInstId, (Object)null).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName()).set((Path)qRecOrderDO.procInstId, (Object)null);
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qRecOrderDO.orderState, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set((Path)qRecOrderDO.proposedStatus, (Object)UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode()).set(qRecOrderDO.approvedTime, (Object)LocalDateTime.now()).set(qRecOrderDO.auditDate, (Object)LocalDateTime.now()).set(qRecOrderDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)qRecOrderDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            this.arOrderService.autoWriteoff(arOrderDTO);
        }
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(businessId);
        if (arOrderDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(arOrderDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArOrderProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, ArOrderRepoProc arOrderRepoProc, JPAQueryFactory jpaQueryFactory, ArOrderService arOrderService) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.arOrderRepoProc = arOrderRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.arOrderService = arOrderService;
    }
}

