/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.factory.aporder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ApOrderFactory {
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;

    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam) {
        List<Long> masId = this.apOrderDtlRepoProc.findBySourceId(apOrderPageParam.getSourceNoDtl());
        PagingVO<ApOrderDTO> page = this.apOrderRepoProc.page(apOrderPageParam, masId);
        page.getRecords().forEach(x -> x.setTotalCount(this.apOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
        return page;
    }

    public PagingVO<ApOrderDTO> writeoffPage(ApOrderPageParam apOrderPageParam) {
        List<Long> masIds = this.apOrderDtlRepoProc.findUnverBySourceId(apOrderPageParam.getSourceNoDtl());
        PagingVO<ApOrderDTO> page = null;
        if (CollUtil.isEmpty(masIds)) {
            return new PagingVO(0L, new ArrayList());
        }
        page = this.apOrderRepoProc.unverPage(apOrderPageParam, masIds);
        return page;
    }

    public ApOrderFactory(ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderRepoProc apOrderRepoProc) {
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
    }
}

