/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.invoice.InvoiceRuleConfigConvert;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRuleConfigVO;
import com.elitesland.fin.application.service.invoice.InvoiceRuleConfigService;
import com.elitesland.fin.entity.invoice.InvoiceRuleConfigDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepo;
import com.elitesland.fin.repo.invoice.InvoiceRuleConfigRepoProc;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceRuleConfigServiceImpl
implements InvoiceRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceRuleConfigServiceImpl.class);
    private final InvoiceRuleConfigRepo invoiceRuleConfigRepo;
    private final InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceRuleConfigVO> page(InvoiceRuleConfigQueryParam param) {
        PagingVO<InvoiceRuleConfigDTO> pagingDTO = this.invoiceRuleConfigRepoProc.queryPaging(param);
        return InvoiceRuleConfigConvert.INSTANCE.dto2PagingVO(pagingDTO);
    }

    @Override
    @SysCodeProc
    public InvoiceRuleConfigVO detail(Long masId) {
        Optional byId = this.invoiceRuleConfigRepo.findById(masId);
        if (byId.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u53d1\u7968\u8bbe\u7f6e\u4fe1\u606f");
        }
        InvoiceRuleConfigVO detailVO = InvoiceRuleConfigConvert.INSTANCE.do2DetailVO((InvoiceRuleConfigDO)byId.get());
        return detailVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(InvoiceRuleConfigSaveParam param) {
        this.validateSaveOrUpdateParam(param);
        if (ObjectUtil.isNull((Object)param.getId()) && this.invoiceRuleConfigRepo.existsByOptDocClsAndOptDocTypeAndOptDocStatus(param.getOptDocCls(), param.getOptDocType(), param.getOptDocStatus())) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u53d1\u7968\u8bbe\u7f6e");
        }
        InvoiceRuleConfigDO invoiceRuleConfigDO = InvoiceRuleConfigConvert.INSTANCE.param2DO(param);
        InvoiceRuleConfigDO save = (InvoiceRuleConfigDO)this.invoiceRuleConfigRepo.save(invoiceRuleConfigDO);
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delById(Long id) {
        if (ObjUtil.isNull((Object)id)) {
            throw new BusinessException("\u9700\u8981\u5220\u9664\u7684\u53d1\u7968\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.invoiceRuleConfigRepo.deleteById(id);
    }

    private void validateSaveOrUpdateParam(InvoiceRuleConfigSaveParam param) {
        Assert.notBlank((CharSequence)param.getOptDocCls(), (String)"\u9002\u7528\u5355\u636e\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOptDocType(), (String)"\u5355\u636e\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getOptDocStatus(), (String)"\u5355\u636e\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getInvoiceLimit(), (String)"\u53ef\u5f00\u7968\u65f6\u9650\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getAutoReview(), (String)"\u662f\u5426\u81ea\u52a8\u5ba1\u6838\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getAutoInvoice(), (String)"\u662f\u5426\u81ea\u52a8\u5f00\u7968\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getNeedRedraft(), (String)"\u53d1\u7968\u7ea2\u51b2\u524d\u662f\u5426\u9700\u8981\u6362\u5f00\u7533\u8bf7\u5ba1\u6838\u5fc5\u586b", (Object[])new Object[0]);
    }

    public InvoiceRuleConfigServiceImpl(InvoiceRuleConfigRepo invoiceRuleConfigRepo, InvoiceRuleConfigRepoProc invoiceRuleConfigRepoProc) {
        this.invoiceRuleConfigRepo = invoiceRuleConfigRepo;
        this.invoiceRuleConfigRepoProc = invoiceRuleConfigRepoProc;
    }
}

