/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDTO;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.order.param.SalDoDFinQueryDTO;
import com.elitesland.order.param.SalDoDFinRespDTO;
import com.elitesland.order.service.SalDoDRpcService;
import com.elitesland.pur.dto.gr.PurGrDParamRpcDTO;
import com.elitesland.pur.dto.gr.PurGrDRpcDTO;
import com.elitesland.pur.provider.PurGrDProvider;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ApArOrderServiceImpl
implements ApArOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApArOrderServiceImpl.class);
    private final InvStkProvider invStkProvider;
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final TransactionTemplate transactionTemplate;
    private final SystemRpcService systemRpcService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final SalDoDRpcService salDoDRpcService;
    private final PurGrDProvider purGrDProvider;

    @Override
    public void logicInvIoJobAutoCreateApArOrder(String param) {
        JSONObject jsonObject;
        ApArOrderParam apArOrderJobParam;
        ApArOrderParam apArOrderParam = new ApArOrderParam();
        if (StringUtils.isNotBlank((CharSequence)param) && Objects.nonNull(apArOrderJobParam = (ApArOrderParam)JSONObject.toJavaObject((JSON)(jsonObject = JSONObject.parseObject((String)param)), ApArOrderParam.class))) {
            ArOrderRecordConvert.INSTANCE.oldApArOrderToNewParam(apArOrderJobParam, apArOrderParam);
        }
        this.logicInvIoCreateApArOrder(apArOrderParam);
    }

    @Override
    public void logicInvIoCreateApArOrder(ApArOrderParam param) {
        log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
        log.info("\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e\u4efb\u52a1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)param));
        InvIoFinReceiptRpcDtoParam invIoFinReceiptRpcDtoParam = new InvIoFinReceiptRpcDtoParam();
        invIoFinReceiptRpcDtoParam.setIdList(null);
        invIoFinReceiptRpcDtoParam.setSceneCodeList(param.getSceneCodeList());
        invIoFinReceiptRpcDtoParam.setFinInterFlagList(param.getFinInterFlagList());
        List invIoFinReceiptRpcDTOList = this.invStkProvider.selectLogicInvIoByParam(invIoFinReceiptRpcDtoParam);
        if (CollectionUtil.isEmpty((Collection)invIoFinReceiptRpcDTOList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34");
            return;
        }
        Map<String, List<InvIoFinReceiptRpcDTO>> srcDocNoListMap = invIoFinReceiptRpcDTOList.stream().collect(Collectors.groupingBy(i -> i.getSrcDocNo()));
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> srcDocNoEntry : srcDocNoListMap.entrySet()) {
            String srcDocNoKey = srcDocNoEntry.getKey();
            List<InvIoFinReceiptRpcDTO> srcDocNoList = srcDocNoEntry.getValue();
            Boolean logicInvIoCreateFlag = false;
            this.transactionTemplate.setPropagationBehavior(3);
            logicInvIoCreateFlag = (Boolean)this.transactionTemplate.execute(trans -> {
                try {
                    List soLogicDeliveryList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "SO_LOGIC_DELIVERY")).collect(Collectors.toList());
                    List soLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "SO_LOGIC_RECEIPT")).collect(Collectors.toList());
                    List poLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "PO_LOGIC_RECEIPT")).collect(Collectors.toList());
                    List poLogicReturnList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(), "PO_LOGIC_RETURN")).collect(Collectors.toList());
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicDeliveryListMap = soLogicDeliveryList.stream().collect(Collectors.groupingBy(i -> this.arSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicReceiptListMap = soLogicReceiptList.stream().collect(Collectors.groupingBy(i -> this.arSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReceiptListMap = poLogicReceiptList.stream().collect(Collectors.groupingBy(i -> this.apSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReturnListMap = poLogicReturnList.stream().collect(Collectors.groupingBy(i -> this.apSpliceGroupKey((InvIoFinReceiptRpcDTO)i)));
                    if (MapUtil.isNotEmpty(soLogicDeliveryListMap)) {
                        this.logicInvIoHandle(soLogicDeliveryListMap, srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(soLogicReceiptListMap)) {
                        this.logicInvIoHandle(soLogicReceiptListMap, srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(poLogicReceiptListMap)) {
                        this.logicInvIoHandle(poLogicReceiptListMap, srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(poLogicReturnListMap)) {
                        this.logicInvIoHandle(poLogicReturnListMap, srcDocNoKey);
                    }
                    return true;
                }
                catch (Exception e) {
                    log.error("\u6765\u6e90\u5355\u636e\u7f16\u53f7: {} \u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u81ea\u52a8\u751f\u6210\u5bf9\u5e94\u8d22\u52a1\u5355\u636e\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u539f\u56e0: {}", (Object)srcDocNoKey, (Object)e.getMessage());
                    trans.setRollbackOnly();
                    return false;
                }
            });
            List invIoIds = srcDocNoList.stream().map(InvIoFinReceiptRpcDTO::getId).collect(Collectors.toList());
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIds);
            if (logicInvIoCreateFlag.booleanValue()) {
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_1);
                this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
                continue;
            }
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_2);
            this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }
    }

    private void logicInvIoHandle(Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap, String srcDocNoKey) {
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> spliceGroupEntry : spliceGroupListMap.entrySet()) {
            String spliceGroupKey = spliceGroupEntry.getKey();
            List<InvIoFinReceiptRpcDTO> spliceGroupList = spliceGroupEntry.getValue();
            String sceneCode = spliceGroupList.get(0).getSceneCode();
            if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
                this.assembleArOrder(spliceGroupList);
                continue;
            }
            if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
                this.assembleArOrder(spliceGroupList);
                continue;
            }
            if (Objects.equals(sceneCode, "PO_LOGIC_RECEIPT")) {
                this.assembleApOrder(spliceGroupList);
                continue;
            }
            if (Objects.equals(sceneCode, "PO_LOGIC_RETURN")) {
                this.assembleApOrder(spliceGroupList);
                continue;
            }
            log.info("\u8be5\u5355\u53f7(" + srcDocNoKey + ")\u7684\u573a\u666f\u7801(" + sceneCode + ")\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u573a\u666f");
            throw new BusinessException("\u8be5\u5355\u53f7(" + srcDocNoKey + ")\u7684\u573a\u666f\u7801(" + sceneCode + ")\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u6027\u5e93\u5b58\u6d41\u6c34\u573a\u666f");
        }
    }

    private Long assembleArOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList) {
        ArOrder arOrder = new ArOrder();
        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();
        ArTypeDTO arTypeDTO = this.selectArType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(), sceneCode, UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(), invIoFinReceiptRpcDTO.getOuId(), invIoFinReceiptRpcDTO.getOuCode());
        Boolean isAuto = arTypeDTO.getAutoAudit();
        arOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        arOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        arOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        arOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        if (isAuto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        arOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());
        arOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        arOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("\u4eba\u6c11\u5e01");
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setExchangeRate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setAuditRejection(null);
        arOrder.setCustId(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setCustCode(invIoFinReceiptRpcDTO.getCustCode());
        arOrder.setCustName(invIoFinReceiptRpcDTO.getCustName());
        arOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setBuType(null);
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);
        arOrder.setOrgId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setOrgCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setOrgName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        arOrder.setArOrderType(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setApprovedTime(null);
        arOrder.setDocType2("B");
        if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
            arOrder.setDocCls("SO");
        } else if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
            arOrder.setDocCls("RSO");
        }
        arOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        arOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        arOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setSettlementType(null);
        String es1 = Objects.isNull(invIoFinReceiptRpcDTO.getCustId()) ? null : String.valueOf(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setEs1(es1);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        arOrder.setEs6(UdcEnum.RED_STATE_NO.getValueCode());
        List<Long> srcDocDids = spliceGroupList.stream().map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDFinRespDTOList = this.selectSalDodById(srcDocDids);
        List<ArOrderDtl> arOrderDtlList = this.assembleArOrderDtl(spliceGroupList, salDoDFinRespDTOList, null, sceneCode);
        arOrder.setDtlList(arOrderDtlList);
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);
        String docType = salDoDFinRespDTOList.get(0).getDocType();
        arOrder.setDocType(docType);
        Long arOrderId = null;
        if (isAuto.booleanValue()) {
            arOrder.setAuditDate(LocalDateTime.now());
            arOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            arOrder.setAuditUserId(user.getId());
            arOrderId = this.arOrderDomainService.commit(arOrder, isAuto);
        } else {
            arOrderId = this.arOrderDomainService.save(arOrder);
        }
        return arOrderId;
    }

    private List<ArOrderDtl> assembleArOrderDtl(List<InvIoFinReceiptRpcDTO> spliceGroupList, List<SalDoDFinRespDTO> salDoDFinRespDTOList, Long masId, String sceneCode) {
        Map<Long, SalDoDFinRespDTO> salDoDFinMap = salDoDFinRespDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));
        List<ArOrderDtl> arOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            SalDoDFinRespDTO salDoDFinRespDTO = (SalDoDFinRespDTO)salDoDFinMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            if (Objects.nonNull(salDoDFinRespDTO) && Objects.nonNull(salDoDFinRespDTO.getLineNo())) {
                arOrderDtl.setSourceLine(salDoDFinRespDTO.getLineNo().intValue());
            } else {
                arOrderDtl.setSourceLine(null);
            }
            arOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            arOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            arOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            arOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            arOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            arOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            arOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            arOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());
            BigDecimal qty = invIoFinReceiptRpcDTO.getQty();
            BigDecimal price = invIoFinReceiptRpcDTO.getSalePrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRateOut();
            if (Objects.isNull(price)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(taxRate)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
            }
            BigDecimal exclTaxPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide(BigDecimal.ONE.add(taxRate).setScale(2, RoundingMode.HALF_UP));
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.equals(sceneCode, "SO_LOGIC_DELIVERY")) {
                arOrderDtl.setQty(qty);
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt);
                arOrderDtl.setExclTaxAmt(exclTaxAmt);
                arOrderDtl.setTaxAmt(taxAmt);
                arOrderDtl.setTotalCurAmt(totalAmt);
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                arOrderDtl.setTaxCurAmt(taxAmt);
            } else if (Objects.equals(sceneCode, "SO_LOGIC_RECEIPT")) {
                arOrderDtl.setQty(qty.negate());
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt.negate());
                arOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxAmt(taxAmt.negate());
                arOrderDtl.setTotalCurAmt(totalAmt.negate());
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxCurAmt(taxAmt.negate());
            }
            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            arOrderDtl.setExpensesType(null);
            arOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            arOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            arOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            arOrderDtl.setEs11(invIoFinReceiptRpcDTO.getSrcDocNo());
            arOrderDtl.setEs12(invIoFinReceiptRpcDTO.getSrcDocDid());
            arOrderDtl.setEs13(String.valueOf(invIoFinReceiptRpcDTO.getCustId()));
            arOrderDtl.setEs14(invIoFinReceiptRpcDTO.getCustCode());
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            arOrderDtl.setRelateId(null);
            return arOrderDtl;
        }).collect(Collectors.toList());
        return arOrderDtlList;
    }

    private Long assembleApOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList) {
        ApOrder apOrder = new ApOrder();
        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();
        apOrder.setId(null);
        apOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        apOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        apOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        apOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        ApTypeDTO apTypeDTO = this.selectApType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(), sceneCode, UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(), invIoFinReceiptRpcDTO.getOuId(), invIoFinReceiptRpcDTO.getOuCode());
        Boolean isAuto = false;
        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        if (isAuto.booleanValue()) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        apOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());
        apOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setExchangeRate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setAuditRejection(null);
        apOrder.setSuppId(invIoFinReceiptRpcDTO.getSuppId());
        apOrder.setSuppCode(invIoFinReceiptRpcDTO.getSuppCode());
        apOrder.setSuppName(invIoFinReceiptRpcDTO.getSuppName());
        apOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        apOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        apOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        apOrder.setBuType(null);
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setLocalCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        apOrder.setVerAmt(BigDecimal.ZERO);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        apOrder.setApprovedTime(null);
        apOrder.setAddrNo(null);
        apOrder.setSuppAddrNo(null);
        apOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        apOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        apOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        List<Long> srcDocDids = spliceGroupList.stream().map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = this.selectPurGrdById(srcDocDids);
        List<ApOrderDtl> apOrderDtlList = this.assembleApOrderDtl(spliceGroupList, purGrDRpcDTOList, null, sceneCode);
        apOrder.setApOrderDtlList(apOrderDtlList);
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);
        Long apOrderId = null;
        if (isAuto.booleanValue()) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
        } else {
            apOrderId = this.apOrderDomainService.save(apOrder);
        }
        return apOrderId;
    }

    private List<ApOrderDtl> assembleApOrderDtl(List<InvIoFinReceiptRpcDTO> spliceGroupList, List<PurGrDRpcDTO> purGrDRpcDTOList, Long masId, String sceneCode) {
        Map<Long, PurGrDRpcDTO> purGrDMap = purGrDRpcDTOList.stream().collect(Collectors.toMap(PurGrDRpcDTO::getId, t -> t, (t1, t2) -> t1));
        List<ApOrderDtl> apOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = (PurGrDRpcDTO)purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());
            ApOrderDtl apOrderDtl = new ApOrderDtl();
            apOrderDtl.setMasId(masId);
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            if (Objects.nonNull(purGrDRpcDTO) && Objects.nonNull(purGrDRpcDTO.getLineNo())) {
                apOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
            } else {
                apOrderDtl.setSourceLine(null);
            }
            apOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            apOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            apOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            apOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            apOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            apOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            apOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            apOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());
            BigDecimal qty = invIoFinReceiptRpcDTO.getQty();
            BigDecimal price = invIoFinReceiptRpcDTO.getPurchsaPrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRate();
            if (Objects.isNull(price)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
            }
            if (Objects.isNull(taxRate)) {
                log.info("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
                throw new BusinessException("\u6d41\u6c34(" + invIoFinReceiptRpcDTO.getId() + ")\u7684\u7a0e\u7387\u4e3a\u7a7a");
            }
            BigDecimal exclTaxPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide(BigDecimal.ONE.add(taxRate).setScale(2, RoundingMode.HALF_UP));
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.equals(sceneCode, "PO_LOGIC_RECEIPT")) {
                apOrderDtl.setQty(qty);
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt);
                apOrderDtl.setExclTaxAmt(exclTaxAmt);
                apOrderDtl.setTaxAmt(taxAmt);
                apOrderDtl.setTotalCurAmt(totalAmt);
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                apOrderDtl.setTaxCurAmt(taxAmt);
            } else if (Objects.equals(sceneCode, "PO_LOGIC_RETURN")) {
                apOrderDtl.setQty(qty.negate());
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt.negate());
                apOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxAmt(taxAmt.negate());
                apOrderDtl.setTotalCurAmt(totalAmt.negate());
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxCurAmt(taxAmt.negate());
            }
            apOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            apOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            apOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            apOrderDtl.setSourceNoDid(invIoFinReceiptRpcDTO.getSrcDocDid());
            return apOrderDtl;
        }).collect(Collectors.toList());
        return apOrderDtlList;
    }

    private ArTypeDTO selectArType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId, String ouCode) {
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(sourceDoc);
        arTypePageParam.setSourceDocType(sourceDocType);
        arTypePageParam.setSourceDocStatus(sourceDocStatus);
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = this.arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)) {
            log.error("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a, \u5e94\u6536\u5355\u7f16\u7801: {}", (Object)arTypeDTOList.get(0).getArTypeCode());
            throw new BusinessException("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
        }
        List arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List arTypeOuIdList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!arTypeOuIdList.contains(ouId) && !arTypeOuCodeList.contains(ouCode)) {
            log.error("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8, \u5e94\u6536\u5355\u7f16\u7801: {},\u516c\u53f8ID: {},\u516c\u53f8\u7f16\u7801: {}", new Object[]{arTypeDTOList.get(0).getArTypeCode(), ouId, ouCode});
            throw new BusinessException("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
        }
        return arTypeDTOList.get(0);
    }

    private ApTypeDTO selectApType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId, String ouCode) {
        ApTypePageParam apTypeParam = new ApTypePageParam();
        apTypeParam.setApTypeCode("YFD05_SYS");
        List<ApTypeDTO> apTypeDTOList = this.apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            log.error("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            log.error("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{sourceDoc, sourceDocType, sourceDocStatus});
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        Long apTypeId = apTypeDTOList.get(0).getId();
        List<ApTypeOuDTO> apTypeOuDTOList = this.apTypeOuDomainService.queryByApTypeId(apTypeId);
        if (CollectionUtil.isEmpty(apTypeOuDTOList)) {
            log.error("\u5e94\u4ed8\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a, \u5e94\u4ed8\u5355\u7f16\u7801: {}", (Object)apTypeDTOList.get(0).getApTypeCode());
            throw new BusinessException("\u5e94\u4ed8\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
        }
        List apTypeOuCodeList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List apTypeOuIdList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!apTypeOuIdList.contains(ouId) && !apTypeOuCodeList.contains(ouCode)) {
            log.error("\u5e94\u4ed8\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8, \u5e94\u4ed8\u5355\u7f16\u7801: {},\u516c\u53f8ID: {},\u516c\u53f8\u7f16\u7801: {}", new Object[]{apTypeDTOList.get(0).getApTypeCode(), ouId, ouCode});
            throw new BusinessException("\u5e94\u4ed8\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
        }
        return apTypeDTOList.get(0);
    }

    private String arSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO) {
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + "-" + invIoFinReceiptRpcDTO.getBuId() + "-" + invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + "-" + invIoFinReceiptRpcDTO.getCustId() + "-" + invIoFinReceiptRpcDTO.getCurrCode() + "--" + invIoFinReceiptRpcDTO.getSrcDocCls() + "-" + invIoFinReceiptRpcDTO.getSrcDocId() + "-" + invIoFinReceiptRpcDTO.getSrcDocNo() + "-" + invIoFinReceiptRpcDTO.getSceneCode();
        return spliceGroupKey;
    }

    private String apSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO) {
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + "-" + invIoFinReceiptRpcDTO.getBuId() + "-" + invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + "-" + invIoFinReceiptRpcDTO.getSuppId() + "-" + invIoFinReceiptRpcDTO.getIoCode() + "-" + invIoFinReceiptRpcDTO.getCurrCode() + "--" + invIoFinReceiptRpcDTO.getSrcDocCls() + "-" + invIoFinReceiptRpcDTO.getSrcDocId() + "-" + invIoFinReceiptRpcDTO.getSrcDocNo() + "-" + invIoFinReceiptRpcDTO.getSceneCode();
        return spliceGroupKey;
    }

    private List<SalDoDFinRespDTO> selectSalDodById(List<Long> srcDocDids) {
        if (CollectionUtil.isEmpty(srcDocDids)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
        }
        SalDoDFinQueryDTO salDoDFinQueryDTO = new SalDoDFinQueryDTO();
        salDoDFinQueryDTO.setIds(srcDocDids);
        ApiResult apiResult = this.salDoDRpcService.queryDodByFinParam(salDoDFinQueryDTO);
        if (!apiResult.isSuccess()) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff1a" + apiResult.getMsg());
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355\u5931\u8d25\uff1a" + apiResult.getMsg());
        }
        List salDoDFinRespDTOList = (List)apiResult.getData();
        if (CollectionUtil.isEmpty((Collection)salDoDFinRespDTOList)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID :{}", srcDocDids);
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u8ba2\u5355(sal_do_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID: " + srcDocDids);
        }
        return salDoDFinRespDTOList;
    }

    private List<PurGrDRpcDTO> selectPurGrdById(List<Long> srcDocDids) {
        if (CollectionUtil.isEmpty(srcDocDids)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u5165\u53c2\u4e3a\u7a7a");
        }
        PurGrDParamRpcDTO purGrDParamRpcDTO = new PurGrDParamRpcDTO();
        purGrDParamRpcDTO.setIds(srcDocDids);
        List purGrDRpcDTOList = this.purGrDProvider.findGrdByParam(purGrDParamRpcDTO);
        if (CollectionUtil.isEmpty((Collection)purGrDRpcDTOList)) {
            log.info("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID :{}", srcDocDids);
            throw new BusinessException("\u6839\u636e\u660e\u7ec6ID\u67e5\u8be2\u91c7\u8d2d(pur_gr_d)\u7684\u51fa\u53c2\u4e3a\u7a7a,\u660e\u7ec6ID: " + srcDocDids);
        }
        return purGrDRpcDTOList;
    }

    public ApArOrderServiceImpl(InvStkProvider invStkProvider, ArTypeDomainService arTypeDomainService, ArTypeOuDomainService arTypeOuDomainService, ApTypeDomainService apTypeDomainService, ApTypeOuDomainService apTypeOuDomainService, TransactionTemplate transactionTemplate, SystemRpcService systemRpcService, ArOrderDomainService arOrderDomainService, ApOrderDomainService apOrderDomainService, SalDoDRpcService salDoDRpcService, PurGrDProvider purGrDProvider) {
        this.invStkProvider = invStkProvider;
        this.arTypeDomainService = arTypeDomainService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.apTypeDomainService = apTypeDomainService;
        this.apTypeOuDomainService = apTypeOuDomainService;
        this.transactionTemplate = transactionTemplate;
        this.systemRpcService = systemRpcService;
        this.arOrderDomainService = arOrderDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.salDoDRpcService = salDoDRpcService;
        this.purGrDProvider = purGrDProvider;
    }
}

