/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.artype;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.fin.application.convert.artype.ArTypeDtlConvert;
import com.elitesland.fin.application.facade.param.artype.ArTypeParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeDtlVO;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.application.service.artype.ArTypeService;
import com.elitesland.fin.domain.entity.artype.ArType;
import com.elitesland.fin.domain.entity.artype.ArTypeDtl;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDtlDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ArTypeServiceImpl
implements ArTypeService {
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final ArTypeDtlDomainService arTypeDtlDomainService;

    @Override
    public ApiResult<Long> save(ArTypeParam arTypeParam) {
        ArType arType = ArTypeConvert.INSTANCE.convert(arTypeParam);
        if (CollectionUtil.isNotEmpty(arTypeParam.getDtlList())) {
            List<ArTypeDtl> arTypeDtlList = arTypeParam.getDtlList().stream().map(ArTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            arType.setDtlList(arTypeDtlList);
        }
        Long res = this.arTypeDomainService.save(arType);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> update(ArTypeParam arTypeParam) {
        if (null == arTypeParam.getId()) {
            throw new BusinessException("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArType arType = ArTypeConvert.INSTANCE.convert(arTypeParam);
        if (CollectionUtil.isNotEmpty(arTypeParam.getDtlList())) {
            List<ArTypeDtl> arTypeDtlList = arTypeParam.getDtlList().stream().map(ArTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            arType.setDtlList(arTypeDtlList);
        }
        Long res = this.arTypeDomainService.update(arType);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApiResult<ArTypeVO> get(Long id) {
        ArTypeDTO res = this.arTypeDomainService.get(id);
        ArTypeVO arTypeVO = ArTypeConvert.INSTANCE.convert(res);
        List<ArTypeDtlDTO> arTypeDtlDTOList = this.arTypeDtlDomainService.selectByMasId(res.getId());
        if (CollectionUtil.isNotEmpty(arTypeDtlDTOList)) {
            List<ArTypeDtlVO> arTypeDtlVOList = arTypeDtlDTOList.stream().map(ArTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            arTypeVO.setDtlList(arTypeDtlVOList);
        }
        return ApiResult.ok((Object)arTypeVO);
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<ArTypeVO>> page(ArTypePageParam arTypePageParam) {
        if (StringUtils.isNotBlank((CharSequence)arTypePageParam.getSourceDoc()) || CollectionUtil.isNotEmpty(arTypePageParam.getSourceDocList())) {
            ArrayList<String> sourceDocList = new ArrayList<String>();
            sourceDocList.add(arTypePageParam.getSourceDoc());
            sourceDocList.addAll(arTypePageParam.getSourceDocList());
            ArTypeDtlPageParam arTypeDtlPageParam = new ArTypeDtlPageParam();
            arTypeDtlPageParam.setSourceDocList(sourceDocList);
            List<ArTypeDtlDTO> arTypeDtlDTOList = this.arTypeDtlDomainService.selectListByParam(arTypeDtlPageParam);
            if (CollectionUtil.isEmpty(arTypeDtlDTOList)) {
                return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build());
            }
            List<Long> masIds = arTypeDtlDTOList.stream().map(ArTypeDtlDTO::getMasId).distinct().collect(Collectors.toList());
            arTypePageParam.setIdList(masIds);
        }
        PagingVO<ArTypeDTO> res = this.arTypeDomainService.page(arTypePageParam);
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ArTypeDTO> arTypeDTOS = this.arTypeDomainService.findByIds(ids);
        if (enable) {
            this.checkEnableRule(arTypeDTOS);
        }
        if (!enable) {
            this.checkStopRule(arTypeDTOS);
        }
        Boolean res = this.arTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long res = this.arTypeDomainService.updateDef(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> del(Long id) {
        List<ArTypeOuDTO> arTypeOuDTOS = this.arTypeOuDomainService.queryByArTypeId(id);
        if (CollUtil.isNotEmpty(arTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5206\u914d\u516c\u53f8!");
        }
        Boolean aBoolean = this.arOrderDomainService.queryByArTypeId(id);
        if (aBoolean.booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5173\u8054\u5e94\u6536\u5355!");
        }
        Long res = this.arTypeDomainService.del(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApiResult<List<ArTypeVO>> getList() {
        List<ArTypeDTO> res = this.arTypeDomainService.getList();
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertList(res));
    }

    @Override
    @SysCodeProc
    public ApiResult<ArTypeVO> getDef() {
        ArTypeDTO res = this.arTypeDomainService.getDef();
        if (res == null) {
            return ApiResult.ok((Object)new ArTypeVO());
        }
        ArTypeVO arTypeVO = ArTypeConvert.INSTANCE.convert(res);
        arTypeVO.setDtlList(Collections.EMPTY_LIST);
        List<ArTypeDtlDTO> arTypeDtlDTOList = this.arTypeDtlDomainService.selectByMasId(arTypeVO.getId());
        if (CollectionUtil.isNotEmpty(arTypeDtlDTOList)) {
            List<ArTypeDtlVO> arTypeDtlVOList = arTypeDtlDTOList.stream().map(ArTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            arTypeVO.setDtlList(arTypeDtlVOList);
        }
        return ApiResult.ok((Object)arTypeVO);
    }

    private void checkStopRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            if (arTypeDTO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u505c\u7528");
        }
    }

    private void checkEnableRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            if (arTypeDTO.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u542f\u52a8");
            }
            List<ArTypeOuDTO> arTypeOuDTOS = this.arTypeOuDomainService.queryByArTypeId(arTypeDTO.getId());
            if (!CollUtil.isEmpty(arTypeOuDTOS)) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7c7b\u578b\u4ee3\u7801" + arTypeDTO.getArTypeCode() + "\u542f\u7528\u524d\u9700\u8981\u5206\u914d\u516c\u53f8");
        }
    }

    public ArTypeServiceImpl(ArTypeDomainService arTypeDomainService, ArTypeOuDomainService arTypeOuDomainService, ArOrderDomainService arOrderDomainService, ArTypeDtlDomainService arTypeDtlDomainService) {
        this.arTypeDomainService = arTypeDomainService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.arOrderDomainService = arOrderDomainService;
        this.arTypeDtlDomainService = arTypeDtlDomainService;
    }
}

