package com.elitesland.fin.application.facade.excel.convert;

import com.elitesland.fin.utils.excel.convert.Converter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.math.BigDecimal;

public class BigDecimalPruneZeroConverter extends Converter<BigDecimal, String, Void> {
    @Override
    public String convert(BigDecimal value) {
        if(value == null) { return null; }
        return value.stripTrailingZeros().toString();
    }
    @Override
    public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.stripTrailingZeros().toPlainString());
    }
}
