package com.elitesland.fin.application.facade.param.creditaccount;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@ApiModel(description = "信用账户状态修改参数")
public class CreditAccountStatusParam {

    @ApiModelProperty("信用账户ID")
    @NotEmpty(message = "没有选择信用账户")
    private List<Long> id;


    @ApiModelProperty("信用账户状态 [UDC]FIN:ACTIVE_STATUS ACTIVE-启用 CLOSED-禁用")
    @NotBlank(message = "没有选择账户状态")
    private String status;
}