package com.elitesland.fin.application.facade.vo.writeoff;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 查询结果.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "查询结果")
public class FinArRecVerApplySettleVO implements Serializable {

    private static final long serialVersionUID = -3176878999874782684L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long id;

    /**
     * 主表ID
     */
    @ApiModelProperty(value = "主表ID")
    private Long masId;

    /**
     * 应收单ID
     */
    @ApiModelProperty(value = "应收单ID")
    private Long arId;

    /**
     * 应收单单号
     */
    @ApiModelProperty(value = "应收单单号")
    private String arDocNo;

    /**
     * 外部应收单ID
     */
    @ApiModelProperty(value = "外部应收单ID")
    private String outArId;

    /**
     * 外部应收单单号
     */
    @ApiModelProperty(value = "外部应收单单号")
    private String outArDocNo;

    /**
     * 应收单明细ID
     */
    @ApiModelProperty(value = "应收单明细ID")
    private Long arDId;

    /**
     * 外部应收单明细ID
     */
    @ApiModelProperty(value = "外部应收单明细ID")
    private String outArDId;

    /**
     * 应收单明细ID
     */
    @ApiModelProperty(value = "应收单明细ID")
    private String arCustCode;

    /**
     * 收款单ID
     */
    @ApiModelProperty(value = "收款单ID")
    private Long recId;

    /**
     * 收款单单号
     */
    @ApiModelProperty(value = "收款单单号")
    private String recDocNo;

    /**
     * 外部收款单ID
     */
    @ApiModelProperty(value = "外部收款单ID")
    private String outRecId;

    /**
     * 外部收款单单号
     */
    @ApiModelProperty(value = "外部收款单单号")
    private String outRecDocNo;

    /**
     * 收款单明细ID
     */
    @ApiModelProperty(value = "收款单明细ID")
    private Long recDId;

    /**
     * 外部收款单明细ID
     */
    @ApiModelProperty(value = "外部收款单明细ID")
    private String outRecDId;

    /**
     * 收款客户编码
     */
    @ApiModelProperty(value = "收款客户编码")
    private String recCustCode;

    /**
     * 核销处理编号
     */
    @ApiModelProperty(value = "核销处理编号")
    private String batchNo;

    /**
     * 应收单未核销金额
     */
    @ApiModelProperty(value = "应收单未核销金额")
    private BigDecimal arNotVerAmt;

    /**
     * 收款单未核销金额
     */
    @ApiModelProperty(value = "收款单未核销金额")
    private BigDecimal recNotVerAmt;

    /**
     * 核销金额
     */
    @ApiModelProperty(value = "核销金额")
    private BigDecimal verAmt;

    /**
     * 核销标记，NORMA：应收单和收款单核销，CANCEL：消核销，INTERNAL：应收单和应收单对冲或收款单和收款单对冲
     */
    @ApiModelProperty(value = "核销标记")
    private String verFlag;
}
