package com.elitesland.fin.application.facade.vo.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询结果.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "查询结果")
public class FinArRecVerApplyVO extends BaseModel {

    private static final long serialVersionUID = 962175813359061804L;

    /**
     * 核销申请单号
     */
    @ApiModelProperty(value = "核销申请单号")
    private String applyDocNo;

    /**
     * 单据状态
     */
    @ApiModelProperty(value = "单据状态")
    @SysCode(sys = "yst-fin", mod = "AR_REC_VER_APPLY_STATUS")
    private String state;
    private String stateName;

    /**
     * 核销状态
     */
    @ApiModelProperty(value = "核销状态")
    @SysCode(sys = "yst-fin", mod = "AR_REC_VER_APPLY_VER_STATUS")
    private String verState;
    private String verStateName;

    /**
     * 核销金额
     */
    @ApiModelProperty(value = "核销金额")
    private BigDecimal verAmt;

    /**
     * 申请日期
     */
    @ApiModelProperty(value = "申请日期")
    private LocalDateTime applyDate;

    /**
     * 申请人ID
     */
    @ApiModelProperty(value = "申请人ID")
    private Long applyUserId;

    /**
     * 申请人编码
     */
    @ApiModelProperty(value = "申请人编码")
    private String applyUserCode;

    /**
     * 申请人名称
     */
    @ApiModelProperty(value = "申请人名称")
    private String applyUserName;

    /**
     * 推送nc失败原因
     */
    @ApiModelProperty(value = "推送NC失败原因")
    private String erpLog;

    /**
     * 审批人ID
     */
    @ApiModelProperty(value = "审批人ID")
    private Long approvalUserId;

    /**
     * 审批人编码
     */
    @ApiModelProperty(value = "审批人编码")
    private String approvalUserCode;

    /**
     * 审批人名称
     */
    @ApiModelProperty(value = "审批人名称")
    private String approvalUserName;

    /**
     * 审批日期
     */
    @ApiModelProperty(value = "审批日期")
    private LocalDateTime approvalDate;

    /**
     * 应收单明细
     */
    @ApiModelProperty(value = "应收单明细")
    private List<FinArRecVerApplyArVO> arList;

    /**
     * 收款单明细
     */
    @ApiModelProperty(value = "收款单明细")
    private List<FinArRecVerApplyRecVO> recList;

    @ApiModelProperty(value = "应收单")
    private List<FinArRecVerApplyArHeadVO> arHeadList;

    @ApiModelProperty(value = "收款单")
    private List<FinArRecVerApplyRecHeadVO> recHeadList;

    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("核销方案ID")
    private Long schemeId;
    @ApiModelProperty("核销方案名称")
    private String schemeName;
    @SysCode(sys = "yst-fin", mod = "VER_MODE")
    @ApiModelProperty("核销方式")
    private String verMode;
    private String verModeName;

}
