package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDTO;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptRpcDtoParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.order.param.SalDoDFinQueryDTO;
import com.elitesland.order.param.SalDoDFinRespDTO;
import com.elitesland.order.service.SalDoDRpcService;
import com.elitesland.pur.dto.gr.PurGrDParamRpcDTO;
import com.elitesland.pur.dto.gr.PurGrDRpcDTO;
import com.elitesland.pur.provider.PurGrDProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/27
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ApArOrderServiceImpl implements ApArOrderService{

    private final InvStkProvider invStkProvider;
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final TransactionTemplate transactionTemplate;
    private final SystemRpcService systemRpcService;
    private final ArOrderDomainService arOrderDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final SalDoDRpcService salDoDRpcService;
    private final PurGrDProvider purGrDProvider;

    /**
     * 逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)
     *
     * @param param 入参
     * @return 出参
     */
    @Override
    public void logicInvIoJobAutoCreateApArOrder(String param){

        ApArOrderParam apArOrderParam = new ApArOrderParam();
        if (StringUtils.isNotBlank(param)) {
            JSONObject jsonObject = JSONObject.parseObject(param);
            ApArOrderParam apArOrderJobParam = JSONObject.toJavaObject(jsonObject, ApArOrderParam.class);
            if (Objects.nonNull(apArOrderJobParam)) {
                ArOrderRecordConvert.INSTANCE.oldApArOrderToNewParam(apArOrderJobParam,apArOrderParam);
            }
        }

        logicInvIoCreateApArOrder(apArOrderParam);
    }

    @Override
    public void logicInvIoCreateApArOrder(ApArOrderParam param) {
        log.info("登录人信息：{}", SecurityContextUtil.currentUser());
        log.info("逻辑性库存流水自动生成对应财务单据任务参数:{}", JSON.toJSONString(param));

        InvIoFinReceiptRpcDtoParam invIoFinReceiptRpcDtoParam = new InvIoFinReceiptRpcDtoParam();
        invIoFinReceiptRpcDtoParam.setIdList(null);
        invIoFinReceiptRpcDtoParam.setSceneCodeList(param.getSceneCodeList());
        invIoFinReceiptRpcDtoParam.setFinInterFlagList(param.getFinInterFlagList());
        List<InvIoFinReceiptRpcDTO> invIoFinReceiptRpcDTOList = invStkProvider.selectLogicInvIoByParam(invIoFinReceiptRpcDtoParam);
        if (CollectionUtil.isEmpty(invIoFinReceiptRpcDTOList)){
            log.info("未查询到逻辑性库存流水");
            return;
        }

        Map<String, List<InvIoFinReceiptRpcDTO>> srcDocNoListMap = invIoFinReceiptRpcDTOList.stream().collect(Collectors.groupingBy(i -> i.getSrcDocNo()));
        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> srcDocNoEntry : srcDocNoListMap.entrySet()) {

            String srcDocNoKey = srcDocNoEntry.getKey();
            List<InvIoFinReceiptRpcDTO> srcDocNoList = srcDocNoEntry.getValue();

            Boolean logicInvIoCreateFlag = false;
            //设置事务传播行为
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            logicInvIoCreateFlag = transactionTemplate.execute(trans -> {
                //ApArOrderHandleDTO handleDTO = new ApArOrderHandleDTO();

                try {

                    List<InvIoFinReceiptRpcDTO> soLogicDeliveryList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> soLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> poLogicReceiptList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)).collect(Collectors.toList());
                    List<InvIoFinReceiptRpcDTO> poLogicReturnList = srcDocNoList.stream().filter(invIoFinReceiptRpcDTO -> Objects.equals(invIoFinReceiptRpcDTO.getSceneCode(),FinConstant.SCENE_CODE_PO_LOGIC_RETURN)).collect(Collectors.toList());

                    //Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap = srcDocNoList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));

                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicDeliveryListMap = soLogicDeliveryList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> soLogicReceiptListMap = soLogicReceiptList.stream().collect(Collectors.groupingBy(i -> arSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReceiptListMap = poLogicReceiptList.stream().collect(Collectors.groupingBy(i -> apSpliceGroupKey(i)));
                    Map<String, List<InvIoFinReceiptRpcDTO>> poLogicReturnListMap = poLogicReturnList.stream().collect(Collectors.groupingBy(i -> apSpliceGroupKey(i)));

                    //src_doc_no生成应收单和应付单必须同时生成，并且含税金额相等
                    if (MapUtil.isNotEmpty(soLogicDeliveryListMap)){
                        logicInvIoHandle(soLogicDeliveryListMap,srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(soLogicReceiptListMap)){
                        logicInvIoHandle(soLogicReceiptListMap,srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(poLogicReceiptListMap)){
                        logicInvIoHandle(poLogicReceiptListMap,srcDocNoKey);
                    }
                    if (MapUtil.isNotEmpty(poLogicReturnListMap)){
                        logicInvIoHandle(poLogicReturnListMap,srcDocNoKey);
                    }


                    return true;
                } catch (Exception e) {
                    log.error("来源单据编号: {} 逻辑性库存流水自动生成对应财务单据发生错误,错误原因: {}",srcDocNoKey, e.getMessage());
                    trans.setRollbackOnly();
                    //throw new BusinessException("来源单据编号:("+srcDocNoKey+")生成对应财务单据失败:"+e.getMessage());
                }

                return false;
            });

            List<Long> invIoIds = srcDocNoList.stream().map(InvIoFinReceiptRpcDTO::getId).collect(Collectors.toList());
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIds);
            if (logicInvIoCreateFlag){
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_1);
                invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
            }else {
                invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_2);
                invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
            }
        }

    }

    private void logicInvIoHandle(Map<String, List<InvIoFinReceiptRpcDTO>> spliceGroupListMap, String srcDocNoKey){

        for (Map.Entry<String, List<InvIoFinReceiptRpcDTO>> spliceGroupEntry : spliceGroupListMap.entrySet()) {
            String spliceGroupKey = spliceGroupEntry.getKey();
            List<InvIoFinReceiptRpcDTO> spliceGroupList = spliceGroupEntry.getValue();

            //同一key的场景编码是一致的
            String sceneCode = spliceGroupList.get(0).getSceneCode();
            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
                assembleArOrder(spliceGroupList);

            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
                assembleArOrder(spliceGroupList);

            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)){
                assembleApOrder(spliceGroupList);

            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RETURN)){
                assembleApOrder(spliceGroupList);

            }else {
                log.info("该单号("+srcDocNoKey+")的场景码("+sceneCode+")未匹配到对应的逻辑性库存流水场景");
                throw new BusinessException("该单号("+srcDocNoKey+")的场景码("+sceneCode+")未匹配到对应的逻辑性库存流水场景");

            }


        }
    }


    /**
     *
     *  应收单
     */
    private Long assembleArOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList){
        ArOrder arOrder = new ArOrder();

        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();


        //来源单据配库存流水  来源单据类型  取对应流水的场景码（逻辑性出入库那个）
        // 状态审核通过（流水都默认审核通过） 匹配后取对应的应收单类型
        ArTypeDTO arTypeDTO = selectArType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(),sceneCode,UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(),invIoFinReceiptRpcDTO.getOuId(),invIoFinReceiptRpcDTO.getOuCode());
        //是否自动审核
        Boolean isAuto = arTypeDTO.getAutoAudit();

        arOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        //自动生成
        arOrder.setArOrderNo(null);
        arOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        arOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        arOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        arOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());
        arOrder.setArTypeId(arTypeDTO.getId());
        arOrder.setArTypeName(arTypeDTO.getArTypeName());
        arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
        if (isAuto) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }

        arOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());

        arOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        arOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        arOrder.setLocalCurrCode("CNY");
        arOrder.setLocalCurrName("人民币");
        arOrder.setAuditUserId(null);
        arOrder.setAuditUser(null);
        arOrder.setAuditDate(null);
        arOrder.setExchangeRate(null);
        arOrder.setOperUserId(null);
        arOrder.setOperator(null);
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);
        arOrder.setAuditRejection(null);
        arOrder.setCustId(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setCustCode(invIoFinReceiptRpcDTO.getCustCode());
        arOrder.setCustName(invIoFinReceiptRpcDTO.getCustName());
        arOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setBuType(null);
        //TODO 付款条件
        //arOrder.setPayMentName();
        //arOrder.setPayMentId();
        //arOrder.setPayMentCode();
        arOrder.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        arOrder.setVerAmt(BigDecimal.ZERO);
        arOrder.setOrgId(invIoFinReceiptRpcDTO.getBuId());
        arOrder.setOrgCode(invIoFinReceiptRpcDTO.getBuCode());
        arOrder.setOrgName(invIoFinReceiptRpcDTO.getBuName());
        arOrder.setSaleUserId(null);
        arOrder.setSaleUser(null);
        arOrder.setArOrderType(null);
        arOrder.setProcInstId(null);
        arOrder.setProcInstStatus(null);
        arOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        arOrder.setApprovedTime(null);

        arOrder.setDocType2("B");//B端订单
        if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
            arOrder.setDocCls("SO");
        }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
            arOrder.setDocCls("RSO");
        }
        /*arOrder.settenantId();
        arOrder.setBelongOrgId();
        arOrder.setTenantOrgId);
        arOrder.setRemark();*/
        arOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        arOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        arOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        /*arOrder.setModifyUserId();
        arOrder.setUpdater();
        arOrder.setModifyTime();
        arOrder.setDeleteFlag();
        arOrder.setAuditDataVersion();
        arOrder.setSecBuId();
        arOrder.setSecUserId();
        arOrder.setSecOuId();*/
        arOrder.setSettlementType(null);
        String es1 = Objects.isNull(invIoFinReceiptRpcDTO.getCustId()) ? null : String.valueOf(invIoFinReceiptRpcDTO.getCustId());
        arOrder.setEs1(es1);
        arOrder.setEs2(null);
        arOrder.setEs3(null);
        arOrder.setEs4(null);
        arOrder.setEs5(null);
        arOrder.setEs6(UdcEnum.RED_STATE_NO.getValueCode());
        /*arOrder.setEs7();
        arOrder.setEs8();
        arOrder.setEs9();
        arOrder.setEs10();
        arOrder.RelateId();
        arOrder.setJournalState();*/

        List<Long> srcDocDids = spliceGroupList.stream().map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<SalDoDFinRespDTO> salDoDFinRespDTOList = selectSalDodById(srcDocDids);

        //处理组装明细
        List<ArOrderDtl> arOrderDtlList = assembleArOrderDtl(spliceGroupList,salDoDFinRespDTOList,null,sceneCode);
        arOrder.setDtlList(arOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = arOrderDtlList.stream().map(ArOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        arOrder.setTotalAmt(totalAmt);
        arOrder.setExclTaxAmt(exclTaxAmt);
        arOrder.setTaxAmt(taxAmt);
        arOrder.setTotalCurAmt(totalCurAmt);
        arOrder.setExclTaxCurAmt(exclTaxCurAmt);
        arOrder.setTaxCurAmt(taxCurAmt);


        //订单的UDC值 SY SY2
        String docType = salDoDFinRespDTOList.get(0).getDocType();
        arOrder.setDocType(docType);

        Long arOrderId = null;
        //自动审核
        if (isAuto) {
            arOrder.setAuditDate(LocalDateTime.now());
            arOrder.setAuditUser("系统自动审核");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            arOrder.setAuditUserId(user.getId());
            arOrderId = arOrderDomainService.commit(arOrder, isAuto);
        }else {
            //新增为草稿
            arOrderId = arOrderDomainService.save(arOrder);
        }

        return arOrderId;
    }

    /**
     *
     *  应收单明细
     */
    private List<ArOrderDtl> assembleArOrderDtl(List<InvIoFinReceiptRpcDTO> spliceGroupList,List<SalDoDFinRespDTO> salDoDFinRespDTOList,
                                                Long masId, String sceneCode){

        Map<Long,SalDoDFinRespDTO> salDoDFinMap = salDoDFinRespDTOList.stream().collect(Collectors.toMap(SalDoDFinRespDTO::getId, t -> t, (t1, t2) -> t1));

        List<ArOrderDtl> arOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            SalDoDFinRespDTO salDoDFinRespDTO = salDoDFinMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());

            ArOrderDtl arOrderDtl = new ArOrderDtl();
            arOrderDtl.setId(null);
            arOrderDtl.setMasId(masId);
            arOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            //根据inv_io.src_doc_did获取
            if (Objects.nonNull(salDoDFinRespDTO) && Objects.nonNull(salDoDFinRespDTO.getLineNo())){
                arOrderDtl.setSourceLine(salDoDFinRespDTO.getLineNo().intValue());
            }else {
                arOrderDtl.setSourceLine(null);
            }
            arOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            arOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            arOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            //库存流水没有就根据对应发货单明细查找
            arOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            //库存流水没有就根据对应发货单明细查找
            arOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            arOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            arOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            arOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());

            BigDecimal qty = invIoFinReceiptRpcDTO.getQty();

            BigDecimal price = invIoFinReceiptRpcDTO.getSalePrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRateOut();
            if(Objects.isNull(price)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
            }
            if(Objects.isNull(taxRate)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
            }
            BigDecimal exclTaxPrice = price.divide((BigDecimal.ONE.add(taxRate)), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide((BigDecimal.ONE.add(taxRate)).setScale(2, RoundingMode.HALF_UP));
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);

            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_DELIVERY)){
                arOrderDtl.setQty(qty);
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt);
                arOrderDtl.setExclTaxAmt(exclTaxAmt);
                arOrderDtl.setTaxAmt(taxAmt);
                arOrderDtl.setTotalCurAmt(totalAmt);
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                arOrderDtl.setTaxCurAmt(taxAmt);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_SO_LOGIC_RECEIPT)){
                arOrderDtl.setQty(qty.negate());
                arOrderDtl.setExclTaxPrice(exclTaxPrice);
                arOrderDtl.setPrice(price);
                arOrderDtl.setTaxRate(taxRate);
                arOrderDtl.setTotalAmt(totalAmt.negate());
                arOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxAmt(taxAmt.negate());
                arOrderDtl.setTotalCurAmt(totalAmt.negate());
                arOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                arOrderDtl.setTaxCurAmt(taxAmt.negate());
            }


            arOrderDtl.setBuCode(null);
            arOrderDtl.setBuId(null);
            arOrderDtl.setBuName(null);
            arOrderDtl.setExpensesType(null);
             /*arOrderDtl.settenantId();
            arOrderDtl.setBelongOrgId();
            arOrderDtl.setTenantOrgId);
            arOrderDtl.setRemark();*/
            arOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            arOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            arOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            /*arOrderDtl.setModifyUserId();
            arOrderDtl.setUpdater();
            arOrderDtl.setModifyTime();
            arOrderDtl.setDeleteFlag();
            arOrderDtl.setAuditDataVersion();
            arOrderDtl.setSecBuId();
            arOrderDtl.setSecUserId();
            arOrderDtl.setSecOuId();*/
            arOrderDtl.setEs11(invIoFinReceiptRpcDTO.getSrcDocNo());
            arOrderDtl.setEs12(invIoFinReceiptRpcDTO.getSrcDocDid());
            arOrderDtl.setEs13(String.valueOf(invIoFinReceiptRpcDTO.getCustId()));
            arOrderDtl.setEs14(invIoFinReceiptRpcDTO.getCustCode());
            arOrderDtl.setEs15(null);
            arOrderDtl.setEs16(null);
            arOrderDtl.setEs17(null);
            arOrderDtl.setEs18(null);
            arOrderDtl.setEs19(null);
            arOrderDtl.setEs20(null);
            arOrderDtl.setEs21(null);
            arOrderDtl.setEs22(null);
            arOrderDtl.setEs23(null);
            arOrderDtl.setEs24(null);
            //arOrderDtl.setEs25();
            arOrderDtl.setRelateId(null);

            return arOrderDtl;
        }).collect(Collectors.toList());

        return arOrderDtlList;
    }

    /**
     *
     *  应付单
     */
    private Long assembleApOrder(List<InvIoFinReceiptRpcDTO> spliceGroupList){
        ApOrder apOrder = new ApOrder();

        InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO = spliceGroupList.get(0);
        String sceneCode = invIoFinReceiptRpcDTO.getSceneCode();

        apOrder.setId(null);
        apOrder.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
        //自动生成
        apOrder.setApOrderNo(null);
        apOrder.setOuCode(invIoFinReceiptRpcDTO.getOuCode());
        apOrder.setOuId(invIoFinReceiptRpcDTO.getOuId());
        apOrder.setOuName(invIoFinReceiptRpcDTO.getOuName());
        apOrder.setCreateMode(invIoFinReceiptRpcDTO.getSrcDocCls());

        //来源单据配库存流水  来源单据类型  取对应流水的场景码（逻辑性出入库那个）
        // 状态审核通过（流水都默认审核通过） 匹配后取对应的应收单类型
        // 应付单怎么匹配类型配置，没有自动审核 传一个默认编码
        ApTypeDTO apTypeDTO = selectApType(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode(),sceneCode,UdcEnum.DOC_STATUS_INVIO_SUCCESS.getValueCode(),invIoFinReceiptRpcDTO.getOuId(),invIoFinReceiptRpcDTO.getOuCode());
        //是否自动审核
        //Boolean isAuto = apTypeDTO.getAutoAudit();
        Boolean isAuto = false;

        apOrder.setApTypeId(apTypeDTO.getId());
        apOrder.setApTypeCode(apTypeDTO.getApTypeCode());
        apOrder.setApTypeName(apTypeDTO.getApTypeName());
        if (isAuto) {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        }else {
            apOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        apOrder.setBuDate(invIoFinReceiptRpcDTO.getIoDate());

        apOrder.setCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setAuditUserId(null);
        apOrder.setAuditUser(null);
        apOrder.setAuditDate(null);
        apOrder.setExchangeRate(null);
        apOrder.setOperUserId(null);
        apOrder.setOperator(null);
        apOrder.setTaxFlag(true);
        apOrder.setInitFlag(false);
        apOrder.setAuditRejection(null);
        apOrder.setSuppId(invIoFinReceiptRpcDTO.getSuppId());
        apOrder.setSuppCode(invIoFinReceiptRpcDTO.getSuppCode());
        apOrder.setSuppName(invIoFinReceiptRpcDTO.getSuppName());
        apOrder.setBuId(invIoFinReceiptRpcDTO.getBuId());
        apOrder.setBuCode(invIoFinReceiptRpcDTO.getBuCode());
        apOrder.setBuName(invIoFinReceiptRpcDTO.getBuName());
        apOrder.setBuType(null);
        //TODO 付款条件
        //pOrder.setPayMentName();
        //apOrder.setPayMentId();
        //apOrder.setPayMentCode();
        apOrder.setTaxRate(null);
        apOrder.setLocalCurrCode(invIoFinReceiptRpcDTO.getCurrCode());
        apOrder.setLocalCurrName(invIoFinReceiptRpcDTO.getCurrCodeName());
        apOrder.setVerState((UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode()));
        apOrder.setVerAmt(BigDecimal.ZERO);
        apOrder.setProcInstId(null);
        apOrder.setProcInstStatus(null);
        apOrder.setSubmitTime(invIoFinReceiptRpcDTO.getCreateTime());
        apOrder.setApprovedTime(null);
        apOrder.setAddrNo(null);
        apOrder.setSuppAddrNo(null);
        /*apOrder.setTenantId();
        apOrder.setBelongOrgId();
        apOrder.setTenantOrgId);
        apOrder.setRemark();*/
        apOrder.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
        apOrder.setCreator(invIoFinReceiptRpcDTO.getCreator());
        apOrder.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
        /*apOrder.setModifyUserId();
        apOrder.setUpdater();
        apOrder.setModifyTime();
        apOrder.setDeleteFlag();
        apOrder.setAuditDataVersion();
        apOrder.setSecBuId();
        apOrder.setSecUserId();
        apOrder.setSecOuId();*/
        List<Long> srcDocDids = spliceGroupList.stream().map(InvIoFinReceiptRpcDTO::getSrcDocDid).distinct().collect(Collectors.toList());
        List<PurGrDRpcDTO> purGrDRpcDTOList = selectPurGrdById(srcDocDids);


        List<ApOrderDtl> apOrderDtlList = assembleApOrderDtl(spliceGroupList,purGrDRpcDTOList,null,sceneCode);
        apOrder.setApOrderDtlList(apOrderDtlList);
        //根据明细汇总
        BigDecimal totalAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exclTaxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getExclTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal taxCurAmt = apOrderDtlList.stream().map(ApOrderDtl::getTaxCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        apOrder.setTotalAmt(totalAmt);
        apOrder.setExclTaxAmt(exclTaxAmt);
        apOrder.setTaxAmt(taxAmt);
        apOrder.setTotalCurAmt(totalCurAmt);
        apOrder.setExclTaxCurAmt(exclTaxCurAmt);
        apOrder.setTaxCurAmt(taxCurAmt);


        Long apOrderId = null;
        //TODO 应付单目前没有自动审核，
        //自动审核
        if (isAuto) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("系统自动审核");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
            //apOrderId = apOrderDomainService.commit(apOrder);

        }else {
            //新增为草稿
            apOrderId = apOrderDomainService.save(apOrder);
        }

        return apOrderId;
    }

    /**
     *
     *  应付单明细
     */
    private List<ApOrderDtl> assembleApOrderDtl(List<InvIoFinReceiptRpcDTO> spliceGroupList,List<PurGrDRpcDTO> purGrDRpcDTOList,
                                                Long masId, String sceneCode){
        Map<Long,PurGrDRpcDTO> purGrDMap = purGrDRpcDTOList.stream().collect(Collectors.toMap(PurGrDRpcDTO::getId, t -> t, (t1, t2) -> t1));

        List<ApOrderDtl> apOrderDtlList = spliceGroupList.stream().map(invIoFinReceiptRpcDTO -> {
            PurGrDRpcDTO purGrDRpcDTO = purGrDMap.get(invIoFinReceiptRpcDTO.getSrcDocDid());

            ApOrderDtl apOrderDtl = new ApOrderDtl();

            //apOrderDtl.setId();
            apOrderDtl.setMasId(masId);
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            //根据inv_io.src_doc_did获取
            if (Objects.nonNull(purGrDRpcDTO) && Objects.nonNull(purGrDRpcDTO.getLineNo())){
                apOrderDtl.setSourceLine(purGrDRpcDTO.getLineNo().intValue());
            }else {
                apOrderDtl.setSourceLine(null);
            }
            apOrderDtl.setItemId(invIoFinReceiptRpcDTO.getItemId());
            apOrderDtl.setItemCode(invIoFinReceiptRpcDTO.getItemCode());
            apOrderDtl.setItemName(invIoFinReceiptRpcDTO.getItemName());
            // 库存流水没有就根据对应采购收货单明细查找
            apOrderDtl.setItemType(invIoFinReceiptRpcDTO.getSpec());
            // 库存流水没有就根据对应采购退货出库单明细查找
            apOrderDtl.setSmallCateCode(invIoFinReceiptRpcDTO.getItemCateCode());
            apOrderDtl.setSmallCateName(invIoFinReceiptRpcDTO.getItemCateName());
            apOrderDtl.setUom(invIoFinReceiptRpcDTO.getUom());
            apOrderDtl.setUomName(invIoFinReceiptRpcDTO.getUomName());

            BigDecimal qty = invIoFinReceiptRpcDTO.getQty();

            BigDecimal price = invIoFinReceiptRpcDTO.getPurchsaPrice();
            BigDecimal taxRate = invIoFinReceiptRpcDTO.getTaxRate();
            if(Objects.isNull(price)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的含税单价为空");
            }
            if(Objects.isNull(taxRate)){
                log.info("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
                throw new BusinessException("流水("+invIoFinReceiptRpcDTO.getId()+")的税率为空");
            }
            BigDecimal exclTaxPrice = price.divide((BigDecimal.ONE.add(taxRate)), 6, RoundingMode.HALF_UP);
            BigDecimal totalAmt = price.multiply(qty).setScale(2, RoundingMode.HALF_UP);
            BigDecimal exclTaxAmt = totalAmt.divide((BigDecimal.ONE.add(taxRate)).setScale(2, RoundingMode.HALF_UP));
            BigDecimal taxAmt = totalAmt.subtract(exclTaxAmt).setScale(2, RoundingMode.HALF_UP);

            if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RECEIPT)){
                apOrderDtl.setQty(qty);
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt);
                apOrderDtl.setExclTaxAmt(exclTaxAmt);
                apOrderDtl.setTaxAmt(taxAmt);
                apOrderDtl.setTotalCurAmt(totalAmt);
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt);
                apOrderDtl.setTaxCurAmt(taxAmt);
            }else if (Objects.equals(sceneCode,FinConstant.SCENE_CODE_PO_LOGIC_RETURN)){
                apOrderDtl.setQty(qty.negate());
                apOrderDtl.setExclTaxPrice(exclTaxPrice);
                apOrderDtl.setPrice(price);
                apOrderDtl.setTaxRate(taxRate);
                apOrderDtl.setTotalAmt(totalAmt.negate());
                apOrderDtl.setExclTaxAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxAmt(taxAmt.negate());
                apOrderDtl.setTotalCurAmt(totalAmt.negate());
                apOrderDtl.setExclTaxCurAmt(exclTaxAmt.negate());
                apOrderDtl.setTaxCurAmt(taxAmt.negate());
            }


             /*apOrderDtl.setTenantId();
            apOrderDtl.setBelongOrgId();
            apOrderDtl.setTenantOrgId);
            apOrderDtl.setRemark();*/
            apOrderDtl.setCreateUserId(invIoFinReceiptRpcDTO.getCreateUserId());
            apOrderDtl.setCreator(invIoFinReceiptRpcDTO.getCreator());
            apOrderDtl.setCreateTime(invIoFinReceiptRpcDTO.getCreateTime());
            /*apOrderDtl.setModifyUserId();
            apOrderDtl.setUpdater();
            apOrderDtl.setModifyTime();
            apOrderDtl.setDeleteFlag();
            apOrderDtl.setAuditDataVersion();
            apOrderDtl.setSecBuId();
            apOrderDtl.setSecUserId();
            apOrderDtl.setSecOuId();*/
            apOrderDtl.setSourceNo(invIoFinReceiptRpcDTO.getSrcDocNo());
            // 没有这个字段
            apOrderDtl.setSourceNoDid(invIoFinReceiptRpcDTO.getSrcDocDid());
            return apOrderDtl;
        }).collect(Collectors.toList());

        return apOrderDtlList;

    }


    /**
     * 查询应收单类型的配置规则
     *
     * @param sourceDoc 来源单据
     * @param sourceDocType 来源单据类型
     * @param sourceDocStatus 来源单据状态
     * @param ouId 公司ID
     * @param ouCode 公司编码
     * @return
     */
    private ArTypeDTO selectArType(String sourceDoc,String sourceDocType,String sourceDocStatus,Long ouId,String ouCode){

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(sourceDoc);
        arTypePageParam.setSourceDocType(sourceDocType);
        arTypePageParam.setSourceDocStatus(sourceDocStatus);
        List<ArTypeDTO> arTypeDTOList = arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)){
            log.error("未匹配到应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("未匹配到应收单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1 ){
            log.error("匹配到多条应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("匹配到多条应收单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)){
            log.error("应收单的分配公司为空, 应收单编码: {}", arTypeDTOList.get(0).getArTypeCode());
            throw new BusinessException("应收单的分配公司为空");
        }
        List<String> arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> arTypeOuIdList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!arTypeOuIdList.contains(ouId) && !arTypeOuCodeList.contains(ouCode)){
            log.error("应收单未分配该公司, 应收单编码: {},公司ID: {},公司编码: {}", arTypeDTOList.get(0).getArTypeCode(),ouId,ouCode);
            throw new BusinessException("应收单未分配该公司");
        }

        return arTypeDTOList.get(0);
    }

    /**
     * 查询应付单类型的配置规则
     *
     * @param sourceDoc 来源单据
     * @param sourceDocType 来源单据类型
     * @param sourceDocStatus 来源单据状态
     * @param ouId 公司ID
     * @param ouCode 公司编码
     * @return
     */
    private ApTypeDTO selectApType(String sourceDoc,String sourceDocType,String sourceDocStatus,Long ouId,String ouCode){

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ApTypePageParam apTypeParam = new ApTypePageParam();
        /*apTypeParam.setSourceDoc(sourceDoc);
        apTypeParam.setSourceDocType(sourceDocType);
        apTypeParam.setSourceDocStatus(sourceDocStatus);*/
        //传一个默认编码
        apTypeParam.setApTypeCode(FinConstant.AP_TYPE_CODE_YFD05_SYS);
        List<ApTypeDTO> apTypeDTOList = apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)){
            log.error("未匹配到应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("未匹配到应付单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1 ){
            log.error("匹配到多条应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType,sourceDocStatus);
            throw new BusinessException("匹配到多条应付单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        Long apTypeId = apTypeDTOList.get(0).getId();
        List<ApTypeOuDTO> apTypeOuDTOList = apTypeOuDomainService.queryByApTypeId(apTypeId);
        if (CollectionUtil.isEmpty(apTypeOuDTOList)){
            log.error("应付单的分配公司为空, 应付单编码: {}", apTypeDTOList.get(0).getApTypeCode());
            throw new BusinessException("应付单的分配公司为空");
        }
        List<String> apTypeOuCodeList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> apTypeOuIdList = apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!apTypeOuIdList.contains(ouId) && !apTypeOuCodeList.contains(ouCode)){
            log.error("应付单未分配该公司, 应付单编码: {},公司ID: {},公司编码: {}", apTypeDTOList.get(0).getApTypeCode(),ouId,ouCode);
            throw new BusinessException("应付单未分配该公司");
        }

        return apTypeDTOList.get(0);
    }

    private String arSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO){
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getBuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getCustId() + FinConstant.LINE_SPLIT +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreateUserId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreator() +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getWhId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getDeter2() +
                invIoFinReceiptRpcDTO.getCurrCode() + FinConstant.LINE_SPLIT +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocCls() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocId() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocNo() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSceneCode()
        ;

        return spliceGroupKey;
    }

    private String apSpliceGroupKey(InvIoFinReceiptRpcDTO invIoFinReceiptRpcDTO){
        String spliceGroupKey = invIoFinReceiptRpcDTO.getOuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getBuId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoDate().toLocalDate() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getSuppId() + FinConstant.LINE_SPLIT +
                invIoFinReceiptRpcDTO.getIoCode() + FinConstant.LINE_SPLIT +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreateUserId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getCreator() +
                //FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getWhId() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getDeter2() +
                invIoFinReceiptRpcDTO.getCurrCode() + FinConstant.LINE_SPLIT +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocCls() + FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocId() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSrcDocNo() +
                FinConstant.LINE_SPLIT + invIoFinReceiptRpcDTO.getSceneCode()
                ;

        return spliceGroupKey;
    }

    private List<SalDoDFinRespDTO> selectSalDodById(List<Long> srcDocDids){
        if (CollectionUtil.isEmpty(srcDocDids)){
            log.info("根据明细ID查询订单(sal_do_d)的入参为空");
            throw new BusinessException("根据明细ID查询订单(sal_do_d)的入参为空");
        }
        SalDoDFinQueryDTO salDoDFinQueryDTO = new SalDoDFinQueryDTO();
        salDoDFinQueryDTO.setIds(srcDocDids);
        ApiResult<List<SalDoDFinRespDTO>> apiResult = salDoDRpcService.queryDodByFinParam(salDoDFinQueryDTO);
        if (!apiResult.isSuccess()){
            log.info("根据明细ID查询订单失败："+apiResult.getMsg());
            throw new BusinessException("根据明细ID查询订单失败："+apiResult.getMsg());
        }
        List<SalDoDFinRespDTO> salDoDFinRespDTOList = apiResult.getData();
        if (CollectionUtil.isEmpty(salDoDFinRespDTOList)){
            log.info("根据明细ID查询订单(sal_do_d)的出参为空,明细ID :{}",srcDocDids);
            throw new BusinessException("根据明细ID查询订单(sal_do_d)的出参为空,明细ID: "+srcDocDids);
        }

        return salDoDFinRespDTOList;

    }

    private List<PurGrDRpcDTO> selectPurGrdById(List<Long> srcDocDids){
        if (CollectionUtil.isEmpty(srcDocDids)){
            log.info("根据明细ID查询采购(pur_gr_d)的入参为空");
            throw new BusinessException("根据明细ID查询采购(pur_gr_d)的入参为空");
        }
        PurGrDParamRpcDTO purGrDParamRpcDTO = new PurGrDParamRpcDTO();
        purGrDParamRpcDTO.setIds(srcDocDids);
        List<PurGrDRpcDTO> purGrDRpcDTOList = purGrDProvider.findGrdByParam(purGrDParamRpcDTO);
        if (CollectionUtil.isEmpty(purGrDRpcDTOList)){
            log.info("根据明细ID查询采购(pur_gr_d)的出参为空,明细ID :{}",srcDocDids);
            throw new BusinessException("根据明细ID查询采购(pur_gr_d)的出参为空,明细ID: "+srcDocDids);
        }

        return purGrDRpcDTOList;

    }



}
