package com.elitesland.fin.application.service.arorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.arorder
 * @date 2022/4/12 15:43
 */
public interface ArOrderService {


    PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam);
    public PagingVO<ArOrderVO> writeoffPage(ArOrderPageParam arOrderPageParam);

    ArOrderVO get(Long id);

    ApiResult<Long> audit(Long id);

    ApiResult<Long> refush(List<Long> id, String content);

    ApiResult<Long> del(List<Long> ids);

    /**
     * 新增-应收单
     * 状态为草稿状态
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> save(ArOrderSaveParam arOrderSaveParam);

    /**
     * 提交-校验明细金额，汇总金额，单头金额
     * 状态为-已提交
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> commit(ArOrderSaveParam arOrderSaveParam);


    /**
     * 取消审批
     * @param ids
     * @return
     */
    ApiResult<Void> cancelApprove(List<Long> ids);

    /**
     * 红冲
     * @param id
     * @return
     */
    ApiResult<Long> redPunch(Long id);


    /**
     * 修改-应收单
     *
     * @param arOrderSaveParam
     * @return
     */
    ApiResult<Long> update(ArOrderSaveParam arOrderSaveParam);

    /**
     * 获取应收单详情和明细汇总信息
     *
     * @param id
     * @return
     */
    ArOrderVO getArOrderAndDtl(Long id);

    /**
     * 自动生成应收单:命中配置项设置规则的业务单据则可以生成
     * <p>
     * 业务方提供公司，来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则，
     * 命中规则的数据按接口样式传输生成对应的应收单，状态是待审核；根据配置项判断是否自动审核。
     * 已生成应收单的业务单据需要打上标记ar_flag，1表示已经生成；0表示未生成。
     *（注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司）
     *
     * @param arOrderRecordSaveParam 入参
     * @return 出参
     */
    ApiResult<Void> autoCreate(ArOrderRecordSaveParam arOrderRecordSaveParam);

    /**
     * 定时任务自动生成应收单
     *
     * @param param 入参
     * @return 出参
     */
    void jobAutoCreate(String param);

    void jobAutoCreateArOrder(ArOrderRecordParam arOrderRecordParam);
    
    PagingVO<ArExportEntity> defaultExport(ArOrderPageParam arOrderPageParam);

    /**
     * 更新核销中金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     */
    void updateMiddleVerAmt(Long arDId, BigDecimal amt);

    /**
     * 更新核销金额.
     *
     * @param arDId 明细ID
     * @param amt   金额
     * @param verType   核销类型
     */
    void updateVerAmt(Long arDId, BigDecimal amt,String verType);
}
