package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlRecordConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.dto.writeoff.ArOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerificationDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderRecordParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderRecordDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderHandleDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderRecordDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.repo.writeoff.ArOrderDetailRepoProc;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import com.elitesland.order.service.SalDoRpcService;
import com.elitesland.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.sale.dto.CrmCustBaseDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import com.elitesland.sale.service.SalesmanRpcService;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgBuRpcService;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.arorder
 * @date 2022/4/12 15:46
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ArOrderServiceImpl implements ArOrderService {

    private final ArOrderDomainService arOrderDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ArOrderRecordDomainService arOrderRecordDomainService;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderFactory arOrderFactory;
    @Autowired
    private TaskExecutor taskExecutor;
    private final TransactionTemplate transactionTemplate;
    private final UdcProvider sysUdcRpcService;

    private final SalDoRpcService salDoRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final OrgBuRpcService orgBuRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final UdcProvider udcProvider;
    private final CrmCustRpcService crmCustRpcService;
    private final SalesmanRpcService salesmanRpcService;
    private final SaleInvDomainService saleInvDomainService;
    private final ArOrderDetailRepoProc arOrderDetailRepoProc;

    @SysCodeProc
    @Override
    public PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = arOrderDomainService.page(arOrderPageParam);
        return ArOrderConvert.INSTANCE.convertPage(page);
    }
    @Override
    public PagingVO<ArOrderVO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = arOrderDomainService.writeoffPage(arOrderPageParam);
        final PagingVO<ArOrderVO> arOrderVOPagingVO = ArOrderConvert.INSTANCE.convertPage(page);
        if(arOrderVOPagingVO.isEmpty()){
            return arOrderVOPagingVO;
        }
        final List<Long> masIds = arOrderVOPagingVO.getRecords().stream().map(ArOrderVO::getId).collect(Collectors.toList());
        final List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMasIds(masIds);
        final Map<Long, List<ArOrderDtlDTO>> arOrderDtlDTOMap= arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId, Collectors.toList()));
        arOrderVOPagingVO.getRecords().stream().forEach(v->{
            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
            final List<ArOrderDtlDTO> arOrderDtlDTOS1 = arOrderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty(arOrderDtlDTOS1)) {
                for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS1) {
                    verAmt = verAmt.add(arOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(arOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(arOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }

        });
        return arOrderVOPagingVO;
    }
    @SysCodeProc
    @Override
    public ArOrderVO get(Long id) {
        ArOrderDTO arOrderDTO = arOrderDomainService.get(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderDTO);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> audit(Long id) {

        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {

        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = arOrderDomainService.audit(ids, content, user);
        return ApiResult.ok(res);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = arOrderDomainService.del(ids);
        return ApiResult.ok(res);
    }

    @SysCodeProc
    @Override
    public ArOrderVO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderAndDtl = arOrderDomainService.getArOrderAndDtl(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderAndDtl);
        return res;
    }


    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> save(ArOrderSaveParam apOrderSaveParam) {
        // 新增只用于单据来源为手工的
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("新增的单据来源需为手工");
        }
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = arOrderDomainService.save(apOrder);
        return ApiResult.ok(res);
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = {Exception.class})
    public ApiResult<Long> commit(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Boolean isAuto = arTypeDomainService.queryIsAuto(apOrderSaveParam.getArTypeId());
        if (isAuto) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("系统自动审核");
            SysUserDTO user = systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
        }
        Long resId = arOrderDomainService.commit(apOrder, isAuto);
        if (!isAuto) {
            // 启动工作流
            startWorkFlow(apOrder, resId);
        }
        return ApiResult.ok(resId);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        // 重置状态
        arOrderDomainService.restDocState(ids);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        ArOrderDTO arOrderDTO = arOrderDomainService.get(id);
        this.checkRedPunch(arOrderDTO);
        ArOrderSaveParam saveParam = arOrderDomainService.redPunchCreate(id);
        //提交
        saveParam.setCheck(false);
        return this.commit(saveParam);
    }



    /**
     * 取消单据检查
     * @param arOrderDTO
     */
    void checkRedPunch(ArOrderDTO arOrderDTO) {
        if (Objects.isNull(arOrderDTO)){
            throw new BusinessException("单据不存在");
        }
        if (Boolean.TRUE.equals(arOrderDTO.getRedState())){
            throw new BusinessException("单据已红冲");
        }
        if (Objects.nonNull(arOrderDTO.getRedSourceNo())){
            throw new BusinessException("来源单据不可为红冲单据");
        }
        if (!(BigDecimal.ZERO.compareTo(arOrderDTO.getVerAmt())==0)){
            throw new BusinessException("已核销金额必须为0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(arOrderDTO.getOrderState())){
            throw new BusinessException("单据状态必须为审核通过");
        }

    }



    private void startWorkFlow(ArOrder apOrder, Long resId) {
        if (apOrder.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            // 启动流程
            String procInstName = "应收单审核-" + apOrder.getArOrderNo();
            String procKey = WorkFlowDefKey.FIN_AR_ORDER.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<>());
            arOrderDomainService.updateWorkInfo(processInfo, resId);
        }
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> update(ArOrderSaveParam apOrderSaveParam) {

        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = arOrderDomainService.save(apOrder);
        return ApiResult.ok(res);
    }


    /**
     * 自动生成应收单:命中配置项设置规则的业务单据则可以生成
     * <p>
     * 业务方提供公司，来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则，
     * 命中规则的数据按接口样式传输生成对应的应收单，状态是待审核；根据配置项判断是否自动审核。
     * 已生成应收单的业务单据需要打上标记ar_flag，1表示已经生成；0表示未生成。
     *（注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司）
     *
     * @param arOrderRecordSaveParam 入参
     * @return 出参
     */
    @Override
    public ApiResult<Void> autoCreate(ArOrderRecordSaveParam arOrderRecordSaveParam){
        log.info("自动生成应收单入参: {}", JSON.toJSONString(arOrderRecordSaveParam));

        //1.保存到记录表
        Long arOrderRecordId = saveArOrderRecord(arOrderRecordSaveParam);

        //2.查询应收单类型的配置规则
        ArTypeDTO arTypeDTO = selectArType(arOrderRecordSaveParam,arOrderRecordId);
        //3.生成应收单
        autoCreateArOrder(arOrderRecordSaveParam,arTypeDTO,arOrderRecordId);

        return ApiResult.ok();
    }

    /**
     * 查询应收单类型的配置规则
     *
     * @param arOrderRecordSaveParam 入参
     * @param arOrderRecordId 记录表ID
     * @return
     */
    private ArTypeDTO selectArType(ArOrderRecordSaveParam arOrderRecordSaveParam,Long arOrderRecordId){
        checkRequired(arOrderRecordSaveParam,arOrderRecordId);

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(arOrderRecordSaveParam.getCreateMode());
        arTypePageParam.setSourceDocType(arOrderRecordSaveParam.getSourceDocType());
        arTypePageParam.setSourceDocStatus(arOrderRecordSaveParam.getSourceDocStatus());
        List<ArTypeDTO> arTypeDTOList = arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)){
            log.error("未匹配到应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(),arOrderRecordSaveParam.getSourceDocStatus());
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"未匹配到应收单类型的配置规则");
            throw new BusinessException("未匹配到应收单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1 ){
            log.error("匹配到多条应收单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(),arOrderRecordSaveParam.getSourceDocStatus());
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"匹配到多条应收单类型的配置规则");
            throw new BusinessException("匹配到多条应收单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        //List<Long> arTypeIds = arTypeDTOList.stream().map(ArTypeDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)){
            log.error("应收单的分配公司为空, 应收单编码: {}", arTypeDTOList.get(0).getArTypeCode());
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"应收单的分配公司为空");
            throw new BusinessException("应收单的分配公司为空");
        }
        List<String> arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> arTypeOuIdList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!arTypeOuIdList.contains(arOrderRecordSaveParam.getOuId()) && !arTypeOuCodeList.contains(arOrderRecordSaveParam.getOuCode())){
            log.error("应收单未分配该公司, 应收单编码: {},公司ID: {},公司编码: {}", arTypeDTOList.get(0).getArTypeCode(),arOrderRecordSaveParam.getOuId(),arOrderRecordSaveParam.getOuCode());
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"应收单未分配该公司");
            throw new BusinessException("应收单未分配该公司");
        }

        return arTypeDTOList.get(0);
    }

    private void checkRepeat(ArOrderRecordSaveParam arOrderRecordSaveParam,Long arOrderRecordId){
        //if (Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_TYPE_DO.getValueCode())){
            ArOrderRecordParam arOrderRecordParam = new ArOrderRecordParam();
            /*arOrderRecordParam.setCreateModeList(Collections.singletonList(arOrderRecordSaveParam.getCreateMode()));
            arOrderRecordParam.setSourceDocTypeList(Collections.singletonList(arOrderRecordSaveParam.getSourceDocType()));
            arOrderRecordParam.setSourceDocStatusList(Collections.singletonList(arOrderRecordSaveParam.getSourceDocStatus()));*/
            arOrderRecordParam.setSourceNoList(Collections.singletonList(arOrderRecordSaveParam.getSourceNo()));
            List<ArOrderRecordDTO> arOrderRecordDTOList = arOrderRecordDomainService.selectByParam(arOrderRecordParam);
            if (CollectionUtil.isNotEmpty(arOrderRecordDTOList) && arOrderRecordDTOList.size() > 1){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"存在单号重复数据,不允许生成");
                throw new BusinessException("存在单号重复数据,不允许生成");
            }
        //}

    }

    private void checkRequired(ArOrderRecordSaveParam arOrderRecordSaveParam,Long arOrderRecordId){
        if (StringUtils.isBlank(arOrderRecordSaveParam.getCreateMode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"单据来源为空");
            throw new BusinessException("单据来源为空");
        }
        if (StringUtils.isBlank(arOrderRecordSaveParam.getSourceDocType())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"来源单据类型为空");
            throw new BusinessException("来源单据类型为空");
        }
        if (StringUtils.isBlank(arOrderRecordSaveParam.getSourceDocStatus())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"来源单据状态为空");
            throw new BusinessException("来源单据状态为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getOuId()) && StringUtils.isBlank(arOrderRecordSaveParam.getOuCode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"公司为空");
            throw new BusinessException("公司为空");
        }


        if (StringUtils.isBlank(arOrderRecordSaveParam.getSourceNo())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"来源单号为空");
            throw new BusinessException("来源单号为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getBuDate())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"业务日期为空");
            throw new BusinessException("业务日期为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTotalAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"含税总金额为空");
            throw new BusinessException("含税总金额为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExclTaxAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"不含税总金额为空");
            throw new BusinessException("不含税总金额为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTaxAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"税额为空");
            throw new BusinessException("税额为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTotalCurAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"含税总金额(本位币)为空");
            throw new BusinessException("含税总金额(本位币)为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExclTaxCurAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"不含税总金额(本位币)为空");
            throw new BusinessException("不含税总金额(本位币)为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getTaxCurAmt())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"税额(本位币)为空");
            throw new BusinessException("税额(本位币)为空");
        }
        if (StringUtils.isBlank(arOrderRecordSaveParam.getCurrCode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"币种编码为空");
            throw new BusinessException("币种编码为空");
        }
        if (StringUtils.isBlank(arOrderRecordSaveParam.getLocalCurrCode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"本位币编码为空");
            throw new BusinessException("本位币编码为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getExchangeRate())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"汇率为空");
            throw new BusinessException("汇率为空");
        }
        if (Objects.isNull(arOrderRecordSaveParam.getCustId()) && StringUtils.isBlank(arOrderRecordSaveParam.getCustCode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"客户为空");
            throw new BusinessException("客户为空");
        }
        if (!Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_CLS_SAINV.getValueCode())) {
            if (Objects.isNull(arOrderRecordSaveParam.getBuId()) && StringUtils.isBlank(arOrderRecordSaveParam.getBuCode())) {
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "部门为空");
                throw new BusinessException("部门为空");
            }
        }
        if (!Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_CLS_SAINV.getValueCode())) {
            if (Objects.isNull(arOrderRecordSaveParam.getSaleUserId()) && StringUtils.isBlank(arOrderRecordSaveParam.getSaleUserCode())) {
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "销售业务员为空");
                throw new BusinessException("销售业务员为空");
            }
        }
        if (StringUtils.isBlank(arOrderRecordSaveParam.getLocalCurrCode())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"本位币编码为空");
            throw new BusinessException("本位币编码为空");
        }
        /*if (StringUtils.isBlank(arOrderRecordSaveParam.getDocType2())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"doc_type2为空");
            throw new BusinessException("doc_type2为空");
        }*/
        if (StringUtils.isBlank(arOrderRecordSaveParam.getEs1())){
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"订单客户为空");
            throw new BusinessException("订单客户为空");
        }



        List<ArOrderDtlRecordSaveParam> dtlRecordSaveParams = arOrderRecordSaveParam.getArOrderDtlRecordSaveParams();
        dtlRecordSaveParams.forEach(dtlRecordSaveParam -> {
            /*if (StringUtils.isBlank(dtlRecordSaveParam.getDocType())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"doc_type为空");
                throw new BusinessException("doc_type为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getDocType2())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"doc_type2为空");
                throw new BusinessException("doc_type2为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getDocCls())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"doc_cls为空");
                throw new BusinessException("doc_cls为空");
            }*/
            if (StringUtils.isBlank(dtlRecordSaveParam.getSourceNo())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细来源单号为空");
                throw new BusinessException("明细来源单号为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getSourceLine())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细来源单号为空");
                throw new BusinessException("明细来源单号为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getItemCode())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细商品编码为空");
                throw new BusinessException("明细商品编码为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getUom())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细计量单位为空");
                throw new BusinessException("明细计量单位为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getQty())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细数量为空");
                throw new BusinessException("明细数量为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getExclTaxPrice())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细单价为空");
                throw new BusinessException("明细单价为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getPrice())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细含税单价为空");
                throw new BusinessException("明细含税单价为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTaxRate())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细税率为空");
                throw new BusinessException("明细税率为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTotalAmt())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细含税金额为空");
                throw new BusinessException("明细含税金额为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getExclTaxAmt())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细不含税金额为空");
                throw new BusinessException("明细不含税金额为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getTaxAmt())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细税额为空");
                throw new BusinessException("明细税额为空");
            }
            if (!Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_CLS_SAINV.getValueCode())) {
                if (Objects.isNull(arOrderRecordSaveParam.getBuId()) && StringUtils.isBlank(arOrderRecordSaveParam.getBuCode())) {
                    arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId, UdcEnum.AR_FLAG_TYPE_0.getValueCode(), "明细费用部门编码为空");
                    throw new BusinessException("明细费用部门编码为空");
                }
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getEs11())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细发货单号为空");
                throw new BusinessException("明细发货单号为空");
            }
            if (Objects.isNull(dtlRecordSaveParam.getEs12())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细发货单明细ID（开票申请单）为空");
                throw new BusinessException("明细发货单明细ID（开票申请单）为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getEs13())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细主客户为空");
                throw new BusinessException("明细主客户为空");
            }
            if (StringUtils.isBlank(dtlRecordSaveParam.getEs14())){
                arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_0.getValueCode(),"明细子客户为空");
                throw new BusinessException("明细子客户为空");
            }
        });

    }

    /**
     * 保存应收单记录表信息
     *
     * @param arOrderRecordSaveParam 入参
     * @return 记录表ID
     */
    @Transactional(rollbackFor = {Exception.class})
    public Long saveArOrderRecord(ArOrderRecordSaveParam arOrderRecordSaveParam){
        Long arOrderRecordId = arOrderRecordDomainService.save(arOrderRecordSaveParam);

        return arOrderRecordId;
    }

    /**
     * 生成应收单
     *
     * @param arOrderRecordSaveParam 入参
     * @param arTypeDTO 应收单类型的配置
     * @param arOrderRecordId 记录表ID
     * @return
     */
    public void autoCreateArOrder(ArOrderRecordSaveParam arOrderRecordSaveParam,ArTypeDTO arTypeDTO,Long arOrderRecordId){

        //设置事务传播行为
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        ArOrderHandleDTO orderHandleDTO = transactionTemplate.execute(trans -> {
            ArOrderHandleDTO arOrderHandleDTO = new ArOrderHandleDTO();
            Long arOrderId = null;
            try {
                //是否自动审核
                Boolean isAuto = arTypeDTO.getAutoAudit();
                ArOrder arOrder = ArOrderConvert.INSTANCE.convertRecord(arOrderRecordSaveParam);
                arOrder.setArTypeCode(arTypeDTO.getArTypeCode());
                arOrder.setArTypeId(arTypeDTO.getId());
                arOrder.setArTypeName(arTypeDTO.getArTypeName());

                autoCreateArOrderHandle(arOrder);

                //定时任务时创建人
                if (Objects.isNull(SecurityContextUtil.currentUser())){
                    arOrder.setCreator("系统自动创建");
                    arOrder.setCreateUserId(0L);
                }
                //自动审核
                if (isAuto) {
                    arOrder.setAuditDate(LocalDateTime.now());
                    arOrder.setAuditUser("系统自动审核");
                    SysUserDTO user = systemRpcService.getUserByName("admin");
                    arOrder.setAuditUserId(user.getId());
                    arOrderId = arOrderDomainService.commit(arOrder, isAuto);
                }else {
                    //新增为草稿
                    arOrderId = arOrderDomainService.save(arOrder);
                }



            } catch (Exception e) {
                log.error("单据: {}自动生成应收单发生错误,错误原因: {}", arOrderRecordSaveParam.getSourceNo(), e.getMessage());
                arOrderHandleDTO.setErrorMsg(e.getMessage());
                trans.setRollbackOnly();

            }
            arOrderHandleDTO.setId(arOrderId);

            return arOrderHandleDTO;
        });

        if (Objects.isNull(orderHandleDTO.getId())){
            //更新生成失败
            arOrderRecordDomainService.updateArFlagAndFailMsgById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_2.getValueCode(),orderHandleDTO.getErrorMsg());
        }else {
            //更新已生成
            arOrderRecordDomainService.updateArFlagById(arOrderRecordId,UdcEnum.AR_FLAG_TYPE_1.getValueCode());
            ArOrderRecordDTO arOrderRecordDTO = arOrderRecordDomainService.selectById(arOrderRecordId);
            if (Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_TYPE_DO.getValueCode())){
                salDoRpcService.updateArOrderFlag(Collections.singletonList(arOrderRecordDTO.getSourceNo()));

            }else if (Objects.equals(arOrderRecordSaveParam.getCreateMode(),UdcEnum.DOC_CLS_SAINV.getValueCode())){
                saleInvDomainService.updateArFlagByApplyNo(arOrderRecordDTO.getSourceNo(),UdcEnum.AR_FLAG_TYPE_1.getValueCode());
            }
            arOrderRecordDomainService.softDeleteByIds(Collections.singletonList(arOrderRecordId));
        }
    }

    private void autoCreateArOrderHandle(ArOrder arOrder){
        arOrder.setTaxFlag(true);
        arOrder.setInitFlag(false);


        //公司信息
        List<OrgOuRpcDTO> orgOuRpcDTOList = selectOu(arOrder);
        if (CollectionUtil.isEmpty(orgOuRpcDTOList)){
            throw new BusinessException("未查询到公司信息");
        }
        OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOList.get(0);
        arOrder.setOuName(orgOuRpcDTO.getOuName());
        arOrder.setOuCode(orgOuRpcDTO.getOuCode());
        arOrder.setOuId(orgOuRpcDTO.getId());
        //币种信息
        Map<String, String> currMap = selectCurr(arOrder);
        arOrder.setCurrName(currMap.getOrDefault(arOrder.getCurrCode(), null));
        arOrder.setLocalCurrName(currMap.getOrDefault(arOrder.getLocalCurrCode(), null));
        //客户
        List<CrmCustBaseDTO> crmCustBaseDTOList = selectCust(arOrder);
        Map<String, CrmCustBaseDTO> custMap = crmCustBaseDTOList.stream().collect(Collectors.toMap(CrmCustBaseDTO::getCustCode, t -> t));
        if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrder.getCustCode()))){
            arOrder.setCustId(custMap.get(arOrder.getCustCode()).getId());
            arOrder.setCustName(custMap.get(arOrder.getCustCode()).getCustName());
        }
        if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrder.getEs1()))) {
            arOrder.setEs1(custMap.get(arOrder.getEs1()).getCustName());
        }
        //部门
        List<OrgBuRpcDTO> orgBuRpcDTOList = selectBu(arOrder);
        Map<String, OrgBuRpcDTO> buCodeMap = orgBuRpcDTOList.stream().collect(Collectors.toMap(OrgBuRpcDTO::getBuCode, t -> t));
        if (MapUtil.isNotEmpty(buCodeMap) && Objects.nonNull(buCodeMap.get(arOrder.getBuCode()))){
            arOrder.setBuId(buCodeMap.get(arOrder.getBuCode()).getId());
            arOrder.setBuName(buCodeMap.get(arOrder.getBuCode()).getBuName());
        }
        Map<Long, OrgBuRpcDTO> buIdMap = orgBuRpcDTOList.stream().collect(Collectors.toMap(OrgBuRpcDTO::getId, t -> t));
        if (MapUtil.isNotEmpty(buIdMap) && Objects.nonNull(buIdMap.get(arOrder.getBuId()))){
            arOrder.setBuId(buIdMap.get(arOrder.getBuId()).getId());
            arOrder.setBuName(buIdMap.get(arOrder.getBuId()).getBuName());
        }
        //业务员
        List<SalesmanInfoSimpleRespVO> salesmanVOS = selectSalesman(arOrder);
        Map<Long, SalesmanInfoSimpleRespVO> salesmanMap = salesmanVOS.stream().collect(Collectors.toMap(SalesmanInfoSimpleRespVO::getId, t -> t));
        if (MapUtil.isNotEmpty(salesmanMap) && Objects.nonNull(salesmanMap.get(arOrder.getSaleUserId()))){
            arOrder.setSaleUser(salesmanMap.get(arOrder.getSaleUserId()).getFullName());
        }


        List<ArOrderDtl> dtlList = arOrder.getDtlList();
        List<String> dtlItemCodes = dtlList.stream().map(ArOrderDtl::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemRpcDtoParam = new ItmItemRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(dtlItemCodes);
        List<ItmItemRpcDTO> itmItemRpcDTOList = itmItemRpcService.findItemRpcDtoByParam(itmItemRpcDtoParam);
        Map<String, ItmItemRpcDTO> itmItemMap = itmItemRpcDTOList.stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, t -> t));

        //List<String> dtlUoms = dtlList.stream().map(ArOrderDtl::getUom).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, String> uomMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

        dtlList.forEach(arOrderDtl -> {

            // 含税金额(本位币)=含税金额*汇率
            BigDecimal totalCurAmt = arOrderDtl.getTotalAmt().multiply(arOrder.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getTotalCurAmt())){
                arOrderDtl.setTotalCurAmt(totalCurAmt);
            }
            // 不含税金额(本位币)=不含税金额*汇率
            BigDecimal exclTaxCurAmt = arOrderDtl.getExclTaxAmt().multiply(arOrder.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getExclTaxCurAmt())){
                arOrderDtl.setExclTaxCurAmt(exclTaxCurAmt);
            }
            // 税额(本位币) =含税金额(本位币)-不含税金额(本位币)
            BigDecimal taxCurAmt = totalCurAmt.subtract(exclTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            if (Objects.isNull(arOrderDtl.getTaxCurAmt())){
                arOrderDtl.setTaxCurAmt(taxCurAmt);
            }

            //客户
            if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrderDtl.getEs13()))) {
                arOrderDtl.setEs13(custMap.get(arOrderDtl.getEs13()).getCustName());
            }
            if (MapUtil.isNotEmpty(custMap) && Objects.nonNull(custMap.get(arOrderDtl.getEs14()))) {
                arOrderDtl.setEs14(custMap.get(arOrderDtl.getEs14()).getCustName());
            }
            //部门
            if (MapUtil.isNotEmpty(buCodeMap) && Objects.nonNull(buCodeMap.get(arOrderDtl.getBuCode()))){
                arOrderDtl.setBuId(buCodeMap.get(arOrderDtl.getBuCode()).getId());
                arOrderDtl.setBuName(buCodeMap.get(arOrderDtl.getBuCode()).getBuName());
            }
            if (MapUtil.isNotEmpty(buIdMap) && Objects.nonNull(buIdMap.get(arOrderDtl.getBuId()))){
                arOrderDtl.setBuId(buIdMap.get(arOrderDtl.getBuId()).getId());
                arOrderDtl.setBuName(buIdMap.get(arOrderDtl.getBuId()).getBuName());
            }
            //业务员
            if (MapUtil.isNotEmpty(salesmanMap) && Objects.nonNull(salesmanMap.get(arOrder.getSaleUserId()))){
                arOrderDtl.setEs20(salesmanMap.get(arOrder.getSaleUserId()).getSalesmanNo());
            }
            //商品
            if (MapUtil.isNotEmpty(itmItemMap) && Objects.nonNull(itmItemMap.get(arOrderDtl.getItemCode()))){
                ItmItemRpcDTO itmItemRpcDTO = itmItemMap.get(arOrderDtl.getItemCode());
                arOrderDtl.setItemName(itmItemRpcDTO.getItemName());

                if (StringUtils.isNotBlank(arOrderDtl.getItemType())){
                    arOrderDtl.setItemType(itmItemRpcDTO.getSpec());
                }
                if (StringUtils.isNotBlank(arOrderDtl.getSmallCateCode())){
                    arOrderDtl.setSmallCateCode(itmItemRpcDTO.getItemCateCode());
                }
                if (StringUtils.isNotBlank(arOrderDtl.getSmallCateName())){
                    arOrderDtl.setSmallCateName(itmItemRpcDTO.getItemCateFullName());
                }
            }
            arOrderDtl.setUomName(uomMap.get(arOrderDtl.getUom()));

        });

        arOrder.setDtlList(dtlList);
    }


    /**
     * 定时任务自动生成应收单
     *
     * @param param 入参
     * @return 出参
     */
    @Override
    public void jobAutoCreate(String param){

        ArOrderRecordParam arOrderRecordParam = new ArOrderRecordParam();
        if (StringUtils.isNotBlank(param)) {
            JSONObject jsonObject = JSONObject.parseObject(param);
            ArOrderRecordParam arOrderRecordJobParam = JSONObject.toJavaObject(jsonObject, ArOrderRecordParam.class);
            if (Objects.nonNull(arOrderRecordJobParam)) {
                ArOrderRecordConvert.INSTANCE.oldToNewParam(arOrderRecordJobParam,arOrderRecordParam);
            }
        }

        jobAutoCreateArOrder(arOrderRecordParam);
    }

    @Override
    public void jobAutoCreateArOrder(ArOrderRecordParam arOrderRecordParam) {
        log.info("登录人信息：{}", SecurityContextUtil.currentUser());
        log.info("自动生成应收单定时任务参数:{}", JSON.toJSONString(arOrderRecordParam));

        ArrayList arFlagList = new ArrayList<>();
        arFlagList.add(UdcEnum.AR_FLAG_TYPE_0.getValueCode());
        arOrderRecordParam.setArFlagList(arFlagList);
        List<ArOrderRecordDTO> arOrderRecordDTOList = arOrderRecordDomainService.selectDetailsByParam(arOrderRecordParam);

        if (CollectionUtil.isEmpty(arOrderRecordDTOList)){
            log.info("查询待生成应收单记录数据为空");
            return;
        }

        arOrderRecordDTOList.forEach(arOrderRecordDTO -> {

            //1.数据转换
            Long arOrderRecordId = arOrderRecordDTO.getId();
            ArOrderRecordSaveParam arOrderRecordSaveParam = ArOrderRecordConvert.INSTANCE.dtoToSaveParam(arOrderRecordDTO);
            List<ArOrderDtlRecordSaveParam> arOrderDtlRecordSaveParams = ArOrderDtlRecordConvert.INSTANCE.dtoToSaveParamBatch(arOrderRecordDTO.getArOrderDtlRecordDTOS());
            arOrderRecordSaveParam.setArOrderDtlRecordSaveParams(arOrderDtlRecordSaveParams);
            //2.校验
            //2.查询应收单类型的配置规则
            //设置事务传播行为
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            ArTypeDTO arTypeDTO = transactionTemplate.execute(trans -> {
                ArTypeDTO arTypeDto = null;
                try {
                    arTypeDto = selectArType(arOrderRecordSaveParam,arOrderRecordId);
                } catch (Exception e) {
                    trans.setRollbackOnly();
                }
                return arTypeDto;
            });
            //当查询的应付单类型配置不为空时才可继续生成应收单
            if (Objects.nonNull(arTypeDTO)){
                //3.生成应收单
                autoCreateArOrder(arOrderRecordSaveParam,arTypeDTO,arOrderRecordId);
            }

        });

    }


    private List<OrgOuRpcDTO> selectOu(ArOrder arOrder){
        List<OrgOuRpcDTO> orgOuAllList = new ArrayList<>();
        if (Objects.nonNull(arOrder.getOuId()) && StringUtils.isBlank(arOrder.getOuCode())){
            OrgOuRpcDtoParam orgOuByIdParam = new OrgOuRpcDtoParam();
            orgOuByIdParam.setOuIds(Collections.singletonList(arOrder.getOuId()));
            List<OrgOuRpcDTO> orgOuRpcDTOList = orgOuRpcService.findOuDtoByParam(orgOuByIdParam);
            if (CollectionUtil.isNotEmpty(orgOuRpcDTOList)){
                orgOuAllList.addAll(orgOuRpcDTOList);
            }
        }
        if (StringUtils.isNotBlank(arOrder.getOuCode())){
            OrgOuRpcDtoParam orgOuByCodeParam = new OrgOuRpcDtoParam();
            orgOuByCodeParam.setOuCodes(Collections.singletonList(arOrder.getOuCode()));
            List<OrgOuRpcDTO> orgOuRpcDTOList = orgOuRpcService.findOuDtoByParam(orgOuByCodeParam);
            if (CollectionUtil.isNotEmpty(orgOuRpcDTOList)){
                orgOuAllList.addAll(orgOuRpcDTOList);
            }
        }

        return orgOuAllList;
    }

    private Map<String, String> selectCurr(ArOrder arOrder){
        Set<String> currCodes = new HashSet<>();
        currCodes.add(arOrder.getCurrCode());
        currCodes.add(arOrder.getLocalCurrCode());
        List<SysCurrencyRespDTO> currencyRespDTOS = systemRpcService.findCurrByCodes(currCodes);
        if (CollectionUtil.isEmpty(currencyRespDTOS)){
            return new HashMap<>();
        }
        return currencyRespDTOS.stream().collect(Collectors.toMap(i -> i.getCurrCode(), i -> i.getCurrName(), (o, n) -> n));
    }

    private List<CrmCustBaseDTO> selectCust(ArOrder arOrder){
        List<String> custCodeAllList = new ArrayList<>();
        custCodeAllList.add(arOrder.getCustCode());
        custCodeAllList.add(arOrder.getEs1());
        List<String> es13s = arOrder.getDtlList().stream().map(ArOrderDtl::getEs13).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        custCodeAllList.addAll(es13s);
        List<String> es14s = arOrder.getDtlList().stream().map(ArOrderDtl::getEs14).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        custCodeAllList.addAll(es14s);

        List<CrmCustBaseDTO> crmCustBaseDTOList = findCustByCode(custCodeAllList);

        return crmCustBaseDTOList;
    }

    public List<CrmCustBaseDTO> findCustByCode(List<String> custCodeList) {
        if (CollectionUtil.isEmpty(custCodeList)){
            return Collections.emptyList();
        }

        ApiResult<List<CrmCustBaseDTO>> apiResult = crmCustRpcService.getBaseCustByParam(custCodeList);
        if (!apiResult.isSuccess()) {
            throw new com.elitescloud.boot.exception.BusinessException("查询客户失败:" + JSON.toJSONString(apiResult.getMsg()));
        }
        List<CrmCustBaseDTO> crmCustBaseDTOList = apiResult.getData();
        if (CollectionUtils.isNotEmpty(crmCustBaseDTOList)) {
            return crmCustBaseDTOList;
        }
        return Collections.emptyList();
    }

    private List<OrgBuRpcDTO> selectBu(ArOrder arOrder){
       /* OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<String> buCodeAllList = new ArrayList<>();
        buCodeAllList.add(arOrder.getBuCode());
        List<String> dtlBuCodes = arOrder.getDtlList().stream().map(ArOrderDtl::getBuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        buCodeAllList.addAll(dtlBuCodes);
        orgBuRpcDtoParam.setBuCodes(buCodeAllList);
        List<OrgBuRpcDTO> orgBuRpcDTOList = orgBuRpcService.findBuDtoByParam(orgBuRpcDtoParam);
        if (CollectionUtil.isEmpty(orgBuRpcDTOList)){
            return Collections.emptyList();
        }*/

        List<OrgBuRpcDTO> orgBuAllList = new ArrayList<>();

        List<Long> dtlBuIds = arOrder.getDtlList().stream().filter(arOrderDtl ->
            Objects.nonNull(arOrderDtl.getBuId()) && StringUtils.isBlank(arOrderDtl.getBuCode())
        ).map(ArOrderDtl::getBuId).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(dtlBuIds)){
            OrgBuRpcDtoParam orgBuIdParam = new OrgBuRpcDtoParam();
            orgBuIdParam.setBuIds(dtlBuIds);
            List<OrgBuRpcDTO> orgBuIdDTOList = orgBuRpcService.findBuDtoByParam(orgBuIdParam);
            if (CollectionUtil.isNotEmpty(orgBuIdDTOList)){
                orgBuAllList.addAll(orgBuIdDTOList);
            }
        }

        List<String> dtlBuCodes = arOrder.getDtlList().stream().filter(arOrderDtl ->
                StringUtils.isNotEmpty(arOrderDtl.getBuCode())
        ).map(ArOrderDtl::getBuCode).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(dtlBuCodes)){
            OrgBuRpcDtoParam orgBuCodeParam = new OrgBuRpcDtoParam();
            orgBuCodeParam.setBuCodes(dtlBuCodes);
            List<OrgBuRpcDTO> orgBuCodeDTOList = orgBuRpcService.findBuDtoByParam(orgBuCodeParam);
            if (CollectionUtil.isNotEmpty(orgBuCodeDTOList)){
                orgBuAllList.addAll(orgBuCodeDTOList);
            }
        }

        return orgBuAllList;
    }

    private List<SalesmanInfoSimpleRespVO> selectSalesman(ArOrder arOrder){
        if (Objects.isNull(arOrder.getSaleUserId())){
            return Collections.emptyList();
        }
        SalesmanInfoSimpleQueryVO salesmanInfoSimpleQueryVO = new SalesmanInfoSimpleQueryVO();
        salesmanInfoSimpleQueryVO.setIds(Collections.singletonList(arOrder.getSaleUserId()));
        List<SalesmanInfoSimpleRespVO> salesmanInfoSimpleRespVOS = salesmanRpcService.simpleQuery(salesmanInfoSimpleQueryVO);
        if (CollectionUtil.isEmpty(salesmanInfoSimpleRespVOS)){
            return Collections.emptyList();
        }

        return salesmanInfoSimpleRespVOS;
    }


    @Override
    public PagingVO<ArExportEntity> defaultExport(ArOrderPageParam arOrderPageParam) {
        // 1. invoke page method to get primary table data
        PagingVO<ArOrderDTO> page = arOrderDomainService.page(arOrderPageParam);

        // 2. find detail data by first step data
        if (page.isEmpty()) {
            return new PagingVO<>(page.getTotal(), List.of());
        }

        var arDocClsMap = sysUdcRpcService.getValueMapByUdcCode("yst-fin", "AR_DOC_CLS");
        var applyStatusMap = sysUdcRpcService.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        var verifyStatusMap = sysUdcRpcService.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        var settlementTypeMap = sysUdcRpcService.getValueMapByUdcCode("yst-fin", "SETTLEMENT_TYPE");
        HashMap<Long, ArOrderDTO> arOrderHashMap = new HashMap<>();
        List<ArOrderDTO> records = page.getRecords();
        Set<Long> ids = new HashSet<>(records.size());
        for (ArOrderDTO record : records) {
            record.setCreateMode(arDocClsMap.get(record.getCreateMode()));
            record.setOrderState(applyStatusMap.get(record.getOrderState()));
            record.setVerState(verifyStatusMap.get(record.getVerState()));
            record.setSettlementType(settlementTypeMap.get(record.getSettlementType()));
            Long id = record.getId();
            arOrderHashMap.put(id, record);
            ids.add(id);
        }
        List<ArOrderDtlDTO> arOrderDtlDTOS = arOrderDtlRepoProc.listByMasIds(ids);
        if(CollectionUtils.isEmpty(arOrderDtlDTOS)) {
            List<ArExportEntity> arExportEntities = ExcelConvertUtils.convertLoosely(records, ArExportEntity.class);
            return new PagingVO<>(page.getTotal(), arExportEntities);
        }

        ExcelConverterManager.refresh();
        ArrayList<ArExportEntity> arExportEntities = new ArrayList<>();
        for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS) {
            ArExportEntity arExportEntity = new ArExportEntity();
            ExcelConvertUtils.convertLoosely(arOrderDtlDTO, arExportEntity);
            ExcelConvertUtils.convertLoosely(arOrderHashMap.get(arOrderDtlDTO.getMasId()), arExportEntity);
            arExportEntities.add(arExportEntity);
        }
        return new PagingVO<>(arOrderFactory.pageCount(arOrderPageParam), arExportEntities);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long arDId, BigDecimal amt) {
        ArOrderDtlDO detail = findDetail(arDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }
    @NotNull
    private ArOrderDtlDO findDetail(Long arDId) {
        ArOrderDtlDO detail = arOrderDetailRepoProc.getExtArOrderDetailAmt(arDId);
        Assert.notNull(detail, "未查询到应收单明细，明细ID:" + arDId);
        return detail;
    }
    private void doUpdateVerAmt(ArOrderAmtUpdateDTO update) {
        if (arOrderDetailRepoProc.updateExtVerAmt(update) == 0) {
            throw new BusinessException("更新核销金额失败，请稍后重试");
        }
    }
    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, ArOrderDtlDO detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("请核对金额数据");
        }
        return ArOrderAmtUpdateDTO.builder()
                .arDId(detail.getId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getAuditDataVersion());

    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long arDId, BigDecimal amt, String verType) {
        ArOrderDtlDO detail = findDetail(arDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());
    }
    @NotNull
    private ArOrderAmtUpdateDTO.ArOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, ArOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算应收单核销金额,{}-{}", amt, infoStr);
        // 取消核销
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ArOrderAmtUpdateDTO.builder()
                    .arDId(detail.getId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        } else {
            // 核销通过
            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return ArOrderAmtUpdateDTO.builder()
                    .arDId(detail.getId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());
        }
    }
}
