package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_REC_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultRecOrderExportServiceImpl implements DataExport<RecOrderEntity, RecOrderPageParam> {
   private final RecOrderRepoProc recOrderRepoProc;
   private final UdcProvider udcProvider;
   private final static Map<String, String> emptyMap = Map.of();
    @Override
    public String getTmplCode() {
        return FIN_REC_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<RecOrderEntity> executeExport(RecOrderPageParam queryParam) {
        if (queryParam.getReDateStart() == null || queryParam.getReDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择收款日期!");
        }
        PagingVO<RecOrderEntity> page = recOrderRepoProc.defaultExport(queryParam);
        if (page == null || page.isEmpty()) {
            return new PagingVO<>(0, List.of());
        }
        List<RecOrderEntity> records = page.getRecords();
        var recDocClsMap = udcProvider.getValueMapByUdcCode("yst-fin", "REC_DOC_CLS");
        recDocClsMap = ObjectUtils.defaultIfNull(recDocClsMap, emptyMap);
        var orderStateMap = udcProvider.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        orderStateMap = ObjectUtils.defaultIfNull(orderStateMap, emptyMap);
        var verifyStatusMap = udcProvider.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        verifyStatusMap = ObjectUtils.defaultIfNull(verifyStatusMap, emptyMap);
        var proposedStatusMap = udcProvider.getValueMapByUdcCode("yst-fin", "DOC_PROPOSED_STATUS");
        proposedStatusMap = ObjectUtils.defaultIfNull(proposedStatusMap, emptyMap);
        ExcelConverterManager.refresh();
        for (RecOrderEntity record : records) {
            record.setCreateModeName(recDocClsMap.get(record.getCreateMode()));
            record.setOrderStateName(orderStateMap.get(record.getOrderState()));
            record.setVerStateName(verifyStatusMap.get(record.getVerState()));
            record.setProposedStatusName(proposedStatusMap.get(record.getProposedStatus()));
        }
        return page;
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}
