package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.fin.application.convert.recorder.RecOrderExConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerificationDTO;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderExDTO;
import com.elitesland.fin.application.facade.param.recorder.FinRecOrderDetailQuery;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlExPageParam;
import com.elitesland.fin.application.facade.param.recorder.RecOrderExPageParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderInfoVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.*;
import com.elitesland.fin.repo.writeoff.RecOrderDetailRepoProc;
import com.elitesland.fin.repo.writeoff.RecOrderExRepoProc;
import com.elitesland.fin.utils.BeanConvertUtils;
import com.elitesland.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.dto.CrmCustDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 查询服务实现类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@Service
@Log4j2
@RequiredArgsConstructor
public class RecOrderExServiceImpl extends BaseServiceImpl implements RecOrderExService {

    final QRecOrderExDo qRecOrderExDo = QRecOrderExDo.recOrderExDo;
    final QRecOrderExDtlDo qRecOrderExDtlDo = QRecOrderExDtlDo.recOrderExDtlDo;
    final QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
    final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;
    final JPAQueryFactory jpaQueryFactory;
    final OrgRpcService orgRpcService;

    //final OrgBuDomainService buService;

    //final CrmCustRpcServiceImpl crmCustRpcService;
    final SysCurrencyRpcService sysCurrencyRpcService;
    final RecOrderDetailRepoProc recOrderDetailRepoProc;
    final EmployeeRpcService employeeRpcService;
    final RecOrderExRepoProc recOrderExRepoProc;

    private final RecOrderService recOrderService;

    @Override
    @SysCodeProc
    public PagingVO<RecOrderExVo> getPage(RecOrderExPageParam recOrderExPageParam) {

        Integer size = recOrderExPageParam.size;
        Integer current = recOrderExPageParam.current;

        recOrderExPageParam.size = Integer.MAX_VALUE;
        recOrderExPageParam.current = 1;
        PagingVO<RecOrderExVo> page = recOrderExRepoProc.page(recOrderExPageParam);
        if (page.isEmpty()) {
            return page;
        }
        setPageInfo(page);


        if (Boolean.TRUE.equals(recOrderExPageParam.getHeadFlag())) {
            List<RecOrderExVo> records = page.getRecords();
            records = records.stream().filter(item -> BigDecimal.ZERO.compareTo(item.getUnVerAmt()) != 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(records)) {
                return PagingVO.empty();
            }
            recOrderExPageParam.size = size;
            recOrderExPageParam.current = current;
            recOrderExPageParam.setIds(records.stream().map(RecOrderExVo::getId).collect(Collectors.toList()));
            page = recOrderExRepoProc.page(recOrderExPageParam);
            setPageInfo(page);
        }

        return page;
    }

    /**
     * 列表查询
     *
     * @param page
     * @return
     */
    public void setPageInfo(PagingVO<RecOrderExVo> page) {
        Set<String> buCodes = new HashSet<>(8);
        Set<String> custCodes = new HashSet<>(8);
        Set<String> currCodes = new HashSet<>(8);
        Set<String> saleUserCodes = new HashSet<>(8);
        Set<Long> masIds = new HashSet<>(8);
        setCode(page, buCodes, custCodes, currCodes, saleUserCodes, masIds);

        List<RecOrderExDtlDo> recOrderExDtlDoList = recOrderDetailRepoProc.listByMasIds(masIds);
        List<SysOrgBasicDTO> orgList = getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = getEmployeeList(saleUserCodes);

        page.getRecords().forEach(recOrderExVo -> {
            recOrderExVo.setRecTypeName("收款单");
            try {
                // 部门名称
                if (!CollectionUtils.isEmpty(orgList)) {
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getBuCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderExVo.setBuName(opt.getName()));
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getRecOuCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderExVo.setRecOuName(opt.getName()));
                }
                // 客户名称
                if (!CollectionUtils.isEmpty(custResult)) {
                    custResult.stream().filter(fi -> fi.getCustCode().equals(recOrderExVo.getCustCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderExVo.setCustomName(opt.getCustName()));
                }
                // 币种名称
                if (!CollectionUtils.isEmpty(currList)) {
                    currList.stream().filter(fi -> fi.getCurrCode().equals(recOrderExVo.getCurrCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderExVo.setCurrName(opt.getCurrName()));
                }
                // 业务员信息
                if (!CollectionUtils.isEmpty(employeeList)) {
                    employeeList.stream().filter(fi -> fi.getCode().equals(recOrderExVo.getSaleUser()))
                            .findFirst()
                            .ifPresent(opt -> recOrderExVo.setBusinessName(opt.getLastName()));
                }
                List<RecOrderExDtlDo> extDList = recOrderExDtlDoList.stream().filter(fi -> fi.getMasId().equals(recOrderExVo.getExtId()))
                        .collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                if (CollUtil.isNotEmpty(extDList)) {
                    for (RecOrderExDtlDo recOrderExDtlDo : extDList) {
                        verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
                        verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
                    }
                }
                recOrderExVo.setVerAmt(verAmt);
                recOrderExVo.setApplyVerAmTing(verAmting);
                recOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(recOrderExVo.getTotalAmt()) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void setCode(PagingVO<RecOrderExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes, Set<Long> masIds) {
        for (RecOrderExVo vo : page.getRecords()) {
            buCodes.add(vo.getOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getSaleUser());
            masIds.add(vo.getExtId());
        }
    }

    private List<SysCurrencyRespDTO> getCurrList(Set<String> currCodes) {
        ApiResult<List<SysCurrencyRespDTO>> currResult = sysCurrencyRpcService.listByCodes(currCodes);
        if (currResult.isFailed()) {
            throw new BusinessException("获取币种信息失败");
        }
        return currResult.getData();
    }

    private List<SysEmployeeBasicDTO> getEmployeeList(Set<String> saleUserCodes) {
        EmployeeQueryDTO eeQuery = new EmployeeQueryDTO();
        eeQuery.setCodes(saleUserCodes);
        ApiResult<List<SysEmployeeBasicDTO>> eeResult = employeeRpcService.queryList(eeQuery);
        if (eeResult.isFailed()) {
            throw new BusinessException("获取业务员信息失败");
        }
        return eeResult.getData();
    }

    private List<LmSaveCustRespVO> getCustList(Set<String> custCodes) {
        CustCode2BaseParam custQuery = new CustCode2BaseParam();
        custQuery.setCustCode(new ArrayList<>(custCodes));
        return null;//crmCustRpcService.findBaseCustInfo(custQuery);
    }

    private List<SysOrgBasicDTO> getOrgList(Set<String> buCodes) {
        SysOrgQueryDTO orgQuery = new SysOrgQueryDTO();
        orgQuery.setCodes(buCodes);
        ApiResult<List<SysOrgBasicDTO>> orgResult = orgRpcService.queryList(orgQuery);
        if (orgResult.isFailed()) {
            throw new BusinessException("获取公司信息失败");
        }
        return orgResult.getData();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.selectDistinct(Projections.bean(cls,
                qRecOrderExDo.id,
                qRecOrderExDo.invoiceNumber,
                qRecOrderExDo.relateId,
                qRecOrderExDo.redFlushSign,
                qRecOrderExDo.thirdPaymentAssistance,
                qRecOrderExDo.consumerCardSsistance,
                qRecOrderExDo.creditCardAssistance,
                qRecOrderExDo.payType,
                qRecOrderExDo.recBank,
                qRecOrderExDo.payBank,
                qRecOrderExDo.deleteFlag,
                qRecOrderExDo.tenantId,
                qRecOrderExDo.belongOrgId,
                qRecOrderExDo.tenantOrgId,
                qRecOrderExDo.createTime,
                qRecOrderExDo.updater,
                qRecOrderExDo.modifyTime,
                qRecOrderExDo.creator,
                qRecOrderExDo.remark
        )).from(qRecOrderExDo)
                .leftJoin(recOrderDO).on(recOrderDO.relateId.eq(qRecOrderExDo.relateId))
                .leftJoin(qRecOrderExDtlDo).on(qRecOrderExDtlDo.masId.eq(qRecOrderExDo.id));
    }


    /**
     * 明细列表查询
     *
     * @param recOrderDtlExPageParam
     * @return
     */
    @Override
    @SysCodeProc
    public PagingVO<RecOrderDtlExVo> getDtlPage(RecOrderDtlExPageParam recOrderDtlExPageParam) {
        PagingVO<RecOrderDtlExVo> page = recOrderDetailRepoProc.getDtlPage(recOrderDtlExPageParam);
        if (page.isEmpty()) {
            return page;
        }
        setInfo(page);
        return page;
    }

    public void setInfo(PagingVO<RecOrderDtlExVo> page) {
        Set<String> buCodes = new HashSet<>(8);
        Set<String> custCodes = new HashSet<>(8);
        Set<String> currCodes = new HashSet<>(8);
        Set<String> saleUserCodes = new HashSet<>(8);
        setCode(page, buCodes, custCodes, currCodes, saleUserCodes);

        List<SysOrgBasicDTO> orgList = getOrgList(buCodes);
        List<LmSaveCustRespVO> custResult = getCustList(custCodes);
        List<SysCurrencyRespDTO> currList = getCurrList(currCodes);
        List<SysEmployeeBasicDTO> employeeList = getEmployeeList(saleUserCodes);
        page.getRecords().forEach(recOrderDtlExVo -> {
            recOrderDtlExVo.setRecTypeName("收款单");
            try {
                // 部门名称
                if (!CollectionUtils.isEmpty(orgList)) {
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getBuCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderDtlExVo.setBuName(opt.getName()));
                    orgList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getRecOuCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderDtlExVo.setRecOuName(opt.getName()));
                }
                // 客户名称
                if (!CollectionUtils.isEmpty(custResult)) {
                    custResult.stream().filter(fi -> fi.getCustCode().equals(recOrderDtlExVo.getCustCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderDtlExVo.setCustName(opt.getCustName()));
                }
                // 币种名称
                if (!CollectionUtils.isEmpty(currList)) {
                    currList.stream().filter(fi -> fi.getCurrCode().equals(recOrderDtlExVo.getCurrCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderDtlExVo.setCurrName(opt.getCurrName()));
                }
                // 业务员信息
                if (!CollectionUtils.isEmpty(employeeList)) {
                    employeeList.stream().filter(fi -> fi.getCode().equals(recOrderDtlExVo.getBusinessCode()))
                            .findFirst()
                            .ifPresent(opt -> recOrderDtlExVo.setBusinessName(opt.getLastName()));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }


    /**
     * 整理编码集合
     *
     * @param page
     * @param buCodes
     * @param custCodes
     * @param currCodes
     * @param saleUserCodes
     */
    private void setCode(PagingVO<RecOrderDtlExVo> page, Set<String> buCodes, Set<String> custCodes, Set<String> currCodes, Set<String> saleUserCodes) {
        for (RecOrderDtlExVo vo : page.getRecords()) {
            buCodes.add(vo.getRecOuCode());
            buCodes.add(vo.getBuCode());
            custCodes.add(vo.getCustCode());
            currCodes.add(vo.getCurrCode());
            saleUserCodes.add(vo.getBusinessCode());
        }
    }

    /**
     * 明细表头
     *
     * @param recOrderVO
     * @return
     */
    @Override
    public RecOrderExVo getDetailExInfo(RecOrderVO recOrderVO) {
        RecOrderExDTO arOrderExDTO = select(RecOrderExDTO.class).where(qRecOrderExDo.relateId.eq(recOrderVO.getRelateId())).fetchOne();
        RecOrderExVo recOrderExVo = new RecOrderExVo();
        if (ObjectUtil.isNotNull(arOrderExDTO)) {
            RecOrderExVo arOrderExVo1 = RecOrderExConvert.INSTANCE.qeryDto2Vo(arOrderExDTO);
            RecOrderExVo arOrderExVo2 = RecOrderExConvert.INSTANCE.Vo2ExVo(recOrderVO);
            recOrderExVo = (RecOrderExVo) BeanConvertUtils.beanConvert(arOrderExVo1, arOrderExVo2);
            log.info("转换之后的类，recOrderExVo:{}", JSONUtil.toJsonStr(recOrderExVo));
            try {
                final SysOrgBasicDTO data = orgRpcService.getByCode(recOrderExVo.getBuCode()).getData();
                recOrderExVo.setBuName(data == null ? "" : data.getName());//销售组织
                final CrmCustDTO data1 = null;//crmCustRpcService.getCustInfo(recOrderExVo.getCustCode()).getData();
                recOrderExVo.setCustomName(data1 == null ? "" : data1.getCustName());//客户名称
                final SysOrgBasicDTO data2 = orgRpcService.getByCode(recOrderExVo.getRecOuCode()).getData();
                recOrderExVo.setRecOuName(data2 == null ? "" : data2.getName());//收款公司名称
                SysCurrencyRespDTO data3 = sysCurrencyRpcService.getByCode(recOrderExVo.getCurrCode()).getData();
                recOrderExVo.setCurrName(data3 == null ? "" : data3.getCurrName());//币种名称
                final SysEmployeeBasicDTO data4 = employeeRpcService.getByCode(recOrderExVo.getSaleUser()).getData();
                recOrderExVo.setBusinessName(data4 == null ? "" : data4.getLastName());//业务员名称
                recOrderExVo.setRecTypeName("收款单");


                List<Long> masIds = Arrays.asList(arOrderExDTO.getId());
                List<RecOrderExDtlDo> recOrderExDtlDos = recOrderDetailRepoProc.listByMasIds(masIds);

                List<RecOrderExDtlDo> extDList = recOrderExDtlDos.stream().filter(fi -> fi.getMasId().equals(arOrderExDTO.getId()))
                        .collect(Collectors.toList());
                BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
                BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
                BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
                if (CollUtil.isNotEmpty(extDList)) {
                    for (RecOrderExDtlDo recOrderExDtlDo : extDList) {
                        verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
                        verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
                    }
                }
                recOrderExVo.setVerAmt(verAmt);
                recOrderExVo.setApplyVerAmTing(verAmting);
                recOrderExVo.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(recOrderExVo.getTotalAmt()) == 0) {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    recOrderExVo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recOrderExVo;
    }

    @Override
    public List<RecOrderDtlExVo> listRecOrderDetail(FinRecOrderDetailQuery query) {
        return recOrderDetailRepoProc.listRecOrderDetail(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
       /* RecOrderExDtlDo detail = findDetail(recDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());*/
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long recDId, BigDecimal amt) {
        RecOrderDtlDO detail = findDetail(recDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    /**
     * 获取收款单详情信息
     *
     * @param id
     * @return
     */
    @Override
    public ApiResult<RecOrderInfoVo> info(Long id) {
        RecOrderInfoVo vo = new RecOrderInfoVo();
        // 查询收款单主表数据信息
        RecOrderVO recOrderVO = recOrderService.queryById(id);

        if (ObjectUtil.isNull(recOrderVO)) {
            throw new BusinessException("查询收款单主表数据信息为空");
        }

        // 赋值
        BeanUtil.copyProperties(recOrderVO, vo);

        // code转name
        handleRecOrderCode2Name(vo);

        // 查询拓展表数据
        RecOrderExDTO arOrderExDTO = select(RecOrderExDTO.class).where(qRecOrderExDo.relateId.eq(recOrderVO.getRelateId())).fetchOne();

        if (ObjectUtil.isNotNull(arOrderExDTO)) {
            vo.setInvoiceNumber(arOrderExDTO.getInvoiceNumber());
            vo.setRedFlushSign(arOrderExDTO.getRedFlushSign());
            vo.setThirdPaymentAssistance(arOrderExDTO.getThirdPaymentAssistance());
            vo.setConsumerCardSsistance(arOrderExDTO.getConsumerCardSsistance());
            vo.setCreditCardAssistance(arOrderExDTO.getCreditCardAssistance());
            vo.setPayType(arOrderExDTO.getPayType());
            vo.setRecBank(arOrderExDTO.getRecBank());
            vo.setPayBank(arOrderExDTO.getPayBank());
            vo.setExtId(arOrderExDTO.getId());
            handleRecOrderDtl(vo);
        }
        return ApiResult.ok(vo);
    }

    /**
     * code2Name，公司，业务员，客户，币种
     *
     * @param vo
     */
    private void handleRecOrderCode2Name(RecOrderInfoVo vo) {
        vo.setRecTypeName("收款单");
        try {
            SysOrgBasicDTO data = orgRpcService.getByCode(vo.getBuCode()).getData();
            vo.setBuName(data == null ? "" : data.getName());//销售组织
        } catch (Exception e) {
            log.error("销售组织code2Name转换异常", JSONUtil.toJsonStr(vo), e.getMessage());
        }

        try {
            CrmCustDTO data1 = null;//crmCustRpcService.getCustInfo(vo.getCustCode()).getData();
            vo.setCustomName(data1 == null ? "" : data1.getCustName());//客户名称
        } catch (Exception e) {
            log.error("客户名称code2Name转换异常", JSONUtil.toJsonStr(vo), e.getMessage());
        }

        try {
            SysOrgBasicDTO data2 = orgRpcService.getByCode(vo.getRecOuCode()).getData();
            vo.setRecOuName(data2 == null ? "" : data2.getName());//收款公司名称
        } catch (Exception e) {
            log.error("收款公司名称code2Name转换异常", JSONUtil.toJsonStr(vo), e.getMessage());
        }

        try {
            SysCurrencyRespDTO data3 = sysCurrencyRpcService.getByCode(vo.getCurrCode()).getData();
            vo.setCurrName(data3 == null ? "" : data3.getCurrName());//币种名称
        } catch (Exception e) {
            log.error("币种名称code2Name转换异常", JSONUtil.toJsonStr(vo), e.getMessage());
        }

        try {
            SysEmployeeBasicDTO data4 = employeeRpcService.getByCode(vo.getSaleUser()).getData();
            vo.setBusinessName(data4 == null ? "" : data4.getLastName());//业务员名称
        } catch (Exception e) {
            log.error("业务员名称code2Name转换异常", JSONUtil.toJsonStr(vo), e.getMessage());
        }
    }

    /**
     * 处理明细数据
     *
     * @param vo
     */
    private void handleRecOrderDtl(RecOrderInfoVo vo) {
        // 根据收款单主表id获取收款单明细数据
        List<RecOrderExDtlDo> dtlDos = recOrderDetailRepoProc.listByMasIds(Arrays.asList(vo.getExtId()));
        log.info("根据收款单主表id获取收款单明细数据：{}", JSONUtil.toJsonStr(dtlDos));
        if (CollUtil.isEmpty(dtlDos)) {
            log.error("根据收款单主表id获取收款单明细数据为空，", JSONUtil.toJsonStr(vo));
            return;
        }

        BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
        BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
        BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
        for (RecOrderExDtlDo recOrderExDtlDo : dtlDos) {
            verAmt = verAmt.add(recOrderExDtlDo.getVerAmt());
            verAmting = verAmting.add(recOrderExDtlDo.getApplyVerAmTing());
            unVerAmt = unVerAmt.add(recOrderExDtlDo.getUnVerAmt());
        }
        vo.setVerAmt(verAmt);
        vo.setApplyVerAmTing(verAmting);
        vo.setUnVerAmt(unVerAmt);
        if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCodeName());
        } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCodeName());
        } else {
            vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            vo.setVerStateName(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCodeName());
        }
    }

    private RecOrderDtlDO findDetail(Long recDId) {
        RecOrderDtlDO detail = recOrderDetailRepoProc.getExtRecOrderDetailAmt(recDId);
        Assert.notNull(detail, "未查询到收款单明细，明细ID:" + recDId);
        return detail;
    }

    private void doUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (recOrderDetailRepoProc.updateExtVerAmt(update) == 0) {
            throw new BusinessException("更新核销金额失败，请稍后重试");
        }
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("请核对金额数据");
        }

        return RecOrderAmtUpdateDTO.builder()
                .arDId(detail.getId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getAuditDataVersion());

    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, RecOrderExDtlDo detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算收款单核销金额,{}-{}", amt, infoStr);
        // 取消核销
        if (FinArRecVerificationDTO.VerType.CANCEL.equals(verType)) {

            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return RecOrderAmtUpdateDTO.builder()
                    .arDId(detail.getExtId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getVersion());

        } else {

            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new BusinessException("请核对金额数据");
            }

            return RecOrderAmtUpdateDTO.builder()
                    .arDId(detail.getExtId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getVersion());

        }

    }

    private <T> JPAQuery<T> selectDtEx(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecOrderExDtlDo.id,
                qRecOrderExDtlDo.relateId,
                qRecOrderExDtlDo.thirdOrderDtId,
                qRecOrderExDtlDo.currCode,
                qRecOrderExDtlDo.custCode,
                qRecOrderExDtlDo.naturePayment,
                qRecOrderExDtlDo.buCode,
                qRecOrderExDtlDo.recBank,
                qRecOrderExDtlDo.payBank,
                qRecOrderExDtlDo.businessCode,
                qRecOrderExDtlDo.exchangeRate,
                qRecOrderExDtlDo.deleteFlag,
                qRecOrderExDtlDo.tenantId,
                qRecOrderExDtlDo.belongOrgId,
                qRecOrderExDtlDo.tenantOrgId,
                qRecOrderExDtlDo.createTime,
                qRecOrderExDtlDo.updater,
                qRecOrderExDtlDo.modifyTime,
                qRecOrderExDtlDo.creator,
                qRecOrderExDtlDo.remark,
                qRecOrderExDtlDo.unVerAmt,
                qRecOrderExDtlDo.applyVerAmTing,
                qRecOrderExDtlDo.verAmt,
                recOrderDO.recOuCode,
                qRecOrderExDo.invoiceNumber,
                qRecOrderDtlDO.recKind,
                qRecOrderDtlDO.id.as("recDId"),
                recOrderDO.sourceNo,
                recOrderDO.id.as("recOrderId"),
                recOrderDO.recOrderNo
        )).from(qRecOrderExDtlDo)
                .leftJoin(qRecOrderExDo).on(qRecOrderExDtlDo.masId.eq(qRecOrderExDo.id))
                .leftJoin(recOrderDO).on(recOrderDO.relateId.eq(qRecOrderExDo.relateId))
                .leftJoin(qRecOrderDtlDO).on(qRecOrderDtlDO.relateId.eq(qRecOrderExDtlDo.relateId));

    }

    private void checkParam(RecOrderExPageParam recOrderExPageParam, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(recOrderExPageParam.getRecOrderNo())) {
            predicates.add(recOrderDO.recOrderNo.like("%" + recOrderExPageParam.getRecOrderNo() + "%"));
        }
        if (StringUtils.isNotBlank(recOrderExPageParam.getRecOuCode())) {
            predicates.add(recOrderDO.recOuCode.eq(recOrderExPageParam.getRecOuCode()));
        }
        if (StringUtils.isNotBlank(recOrderExPageParam.getBuCode())) {
            predicates.add(recOrderDO.buCode.eq(recOrderExPageParam.getBuCode()));
        }
        if (StringUtils.isNotBlank(recOrderExPageParam.getCustCode())) {
            predicates.add(recOrderDO.custCode.eq(recOrderExPageParam.getCustCode()));
        }
        if (null != recOrderExPageParam.getTotalAmtFrom() || null != recOrderExPageParam.getTotalAmtTo()) {
            predicates.add(recOrderDO.totalAmt.between(recOrderExPageParam.getTotalAmtFrom(), recOrderExPageParam.getTotalAmtTo()));
        }
        if (StringUtils.isNotBlank(recOrderExPageParam.getSourceNo())) {
            predicates.add(recOrderDO.sourceNo.like("%" + recOrderExPageParam.getSourceNo() + "%"));
        }
        // 收款日期
        if (null != recOrderExPageParam.getCreateTimeStart() || null != recOrderExPageParam.getCreateTimeEnd()) {
            predicates.add(qRecOrderExDo.createTime.between(recOrderExPageParam.getCreateTimeStart(), recOrderExPageParam.getCreateTimeEnd()));
        }
        if (StringUtils.isNotBlank(recOrderExPageParam.getBusinessCode())) {
            predicates.add(qRecOrderExDtlDo.businessCode.eq(recOrderExPageParam.getBusinessCode()));
        }
        // 发票号码
        if (StringUtils.isNotBlank(recOrderExPageParam.getInvoiceNumber())) {
            predicates.add(qRecOrderExDo.invoiceNumber.eq(recOrderExPageParam.getInvoiceNumber()));
        }
        // 创建日期
        if (null != recOrderExPageParam.getCreateTimeStart() || null != recOrderExPageParam.getCreateTimeEnd()) {
            predicates.add(qRecOrderExDo.createTime.between(recOrderExPageParam.getCreateTimeStart(), recOrderExPageParam.getCreateTimeEnd()));
        }
        // 开票备注
        if (StringUtils.isNotBlank(recOrderExPageParam.getRemark())) {
            predicates.add(qRecOrderExDo.remark.eq(recOrderExPageParam.getRemark()));
        }
        // 红冲标志
        if (recOrderExPageParam.getRedFlushSign() != null) {
            predicates.add(qRecOrderExDo.redFlushSign.eq(recOrderExPageParam.getRedFlushSign()));
        }
        if (recOrderExPageParam.getInitFlag() != null) {
            predicates.add(recOrderDO.initFlag.eq(recOrderExPageParam.getInitFlag()));
        }
    }
}
