package com.elitesland.fin.application.service.workflow.recorder;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/5/7 13:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RecOrderProcessServiceImpl implements RecOrderProcessService {

    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final RecOrderRepoProc recOrderRepoProc;

    private final JPAQueryFactory jpaQueryFactory;
    private final FinArRecVerApplyService finArRecVerApplyService;

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(id);
        if (recOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QRecOrderDO recOrderDO = QRecOrderDO.recOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(recOrderDO)
                .set(recOrderDO.procInstStatus, procInstStatus)
                .where(recOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
                // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(recOrderDO.procInstId, (String) null);
                break;
                //审批中 业务依旧是待审批
            case APPROVING:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(recOrderDO.submitTime,LocalDateTime.now());
                break;
            // 审批拒绝 业务数据草稿
            case REJECTED:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditRejection, commentInfo.getComment())
                        .set(recOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_VOID.getValueCode())
                        .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditRejection, commentInfo.getComment())
                        .set(recOrderDO.auditUser, commentInfo.getUserName())
                        .set(recOrderDO.procInstId, (String) null);
                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(recOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(recOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                    .set(recOrderDO.approvedTime, LocalDateTime.now())
                        .set(recOrderDO.auditDate, LocalDateTime.now())
                        .set(recOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(recOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //自动核销
            finArRecVerApplyService.autoWriteoffRec(recOrderDTO);
        }
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        RecOrderDTO recOrderDTO = recOrderRepoProc.queryById(businessId);
        if (recOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(recOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }
}
