package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyArHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArHeadSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArHeadVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArHeadDO;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArHeadRepo;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArHeadRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyArHeadServiceImpl implements FinArRecVerApplyArHeadService {

    private final FinArRecVerApplyArHeadRepo finArRecVerApplyArHeadRepo;

    private final FinArRecVerApplyArHeadRepoProc finArRecVerApplyArHeadRepoProc;

    @Override
    public Long create(Long masId, FinArRecVerApplyArHeadSaveDTO param) {
        Assert.notNull(masId, "主表ID不能为Null");

        FinArRecVerApplyArHeadDO entity = FinArRecVerApplyArHeadConvert.INSTANCE.DTO2DO(param);
        entity.setMasId(masId);
        return finArRecVerApplyArHeadRepo.save(entity).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyArHeadRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinArRecVerApplyArHeadVO> listByMasIds(Collection<Long> masIds) {
        return finArRecVerApplyArHeadRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyArHeadConvert.INSTANCE::DO2VO)
                .collect(Collectors.toList());
    }

	@Override
	@SysCodeProc
	public List<FinArRecVerApplyArHeadVO> listByIds(Collection<Long> ids) {
		return finArRecVerApplyArHeadRepoProc.listByIds(ids)
				.stream()
				.map(FinArRecVerApplyArHeadConvert.INSTANCE::DO2VO)
				.collect(Collectors.toList());
	}
}
