package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyArConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyArQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyArVO;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyArDO;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyArRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Service
@RequiredArgsConstructor
public class FinArRecVerApplyArServiceImpl implements FinArRecVerApplyArService {

    private final FinArRecVerApplyArRepoProc finArRecVerApplyArRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinArRecVerApplyArSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        finArRecVerApplyArRepoProc.save(saveList.stream()
                .map(e -> {
                    FinArRecVerApplyArDO entity = FinArRecVerApplyArConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Collection<Long> masIds) {
        finArRecVerApplyArRepoProc.deleteByMasId(masIds);
    }

    @Override
    @SysCodeProc
    public List<FinArRecVerApplyArVO> listByMasIds(Collection<Long> masIds) {
        return finArRecVerApplyArRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

	/**
	 * 根据条件查询核销应收单明细
	 *
	 * @param query
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyArVO> listByQuery(FinArRecVerApplyArQuery query) {
		return finArRecVerApplyArRepoProc.listByQuery(query)
				.stream()
				.map(FinArRecVerApplyArConvert.INSTANCE::entity2Vo)
				.collect(Collectors.toList());
	}

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	@Override
	public List<FinArRecVerApplyArVO> listByOutArDocNoOrDId(FinArRecVerApplyQuery applyQuery) {
	/*	if(StrUtil.isEmpty(applyQuery.getOutArDocNo()) && StrUtil.isEmpty(applyQuery.getOutArDId())){
			return null;
		}*/
		return finArRecVerApplyArRepoProc.listByOutArDocNoOrDId(applyQuery);
	}
}
