package com.elitesland.fin.application.web.arorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/01
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/fin/apArOrder")
@RequiredArgsConstructor
@Api(value = "逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)", tags = {"逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)"})
public class ApArOrderController {

    private final ApArOrderService apArOrderService;

    @PostMapping("/logicInvIoCreateApArOrder")
    @ApiOperation("定时任务手动执行逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)")
    public ApiResult<Long> logicInvIoCreateApArOrder(@RequestBody ApArOrderParam apArOrderParam) {
         apArOrderService.logicInvIoCreateApArOrder(apArOrderParam);
        return ApiResult.ok();
    }

}
