package com.elitesland.fin.domain.entity.writeoff;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;
/**
 * 应付付款核销申请单-付款单
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Entity
@Table(name = "fin_ap_pay_ver_apply_pay_head")
@DynamicInsert
@DynamicUpdate
@Comment("应付付款核销申请单-付款单")
@Getter
@Setter
@Accessors(chain = true)
public class FinApPayVerApplyPayHeadDO   extends BaseModel{
private static final long serialVersionUID =6251521152183340863L;

	/**
	 * 主表id
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表id")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "mas_id", nullable = true)
	private Long masId;

	/**
	 * 来源单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "来源单号")
	@Column(name = "source_no", nullable = true, length = 32)
	private String sourceNo;
	/**
	 * 销售公司编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售公司编码")
	@Column(name = "ou_code", nullable = true, length = 32)
	private String ouCode;

	/**
	 * 销售公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ou_id", nullable = true)
	private Long ouId;

	/**
	 * 销售公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售公司名称")
	@Column(name = "ou_name", nullable = true, length = 32)
	private String ouName;

	/**
	 * 应付单类型定义ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型定义ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ap_type_id", nullable = true)
	private Long apTypeId;

	/**
	 * 应付单类型名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型名称")
	@Column(name = "ap_type_name", nullable = true, length = 32)
	private String apTypeName;

	/**
	 * 应付单类型代码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "应付单类型代码")
	@Column(name = "ap_type_code", nullable = true, length = 32)
	private String apTypeCode;

	/**
	 * 付款单类型ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_type_id", nullable = true)
	private Long payTypeId;

	/**
	 * 收款单类型代码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单类型代码")
	@Column(name = "pay_type_code", nullable = true, length = 32)
	private String payTypeCode;

	/**
	 * 收款单类型名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单类型名称")
	@Column(name = "pay_type_name", nullable = true, length = 32)
	private String payTypeName;

	/**
	 * 付款单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单号")
	@Column(name = "pay_order_no", nullable = true, length = 32)
	private String payOrderNo;

	/**
	 * 币种编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "币种编码")
	@Column(name = "curr_code", nullable = true, length = 32)
	private String currCode;

	/**
	 * 币种
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "币种")
	@Column(name = "curr_name", nullable = true, length = 32)
	private String currName;

	/**
	 * 本位币编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "本位币编码")
	@Column(name = "local_curr_code", nullable = true, length = 32)
	private String localCurrCode;

	/**
	 * 本位币名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "本位币名称")
	@Column(name = "local_curr_name", nullable = true, length = 32)
	private String localCurrName;

	/**
	 * 含税总金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "含税总金额")
	@Column(name = "total_amt", nullable = true, length = 18)
	private Double totalAmt;

	/**
	 * 含税总金额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "含税总金额(本位币)")
	@Column(name = "total_cur_amt", nullable = true, length = 18)
	private Double totalCurAmt;

	/**
	 * 审核人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核人ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "audit_user_id", nullable = true)
	private Long auditUserId;

	/**
	 * 审核人
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核人")
	@Column(name = "audit_user", nullable = true, length = 32)
	private String auditUser;

	/**
	 * 审核时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核时间")
	@Column(name = "audit_date", nullable = true)
	private LocalDateTime auditDate;

	/**
	 * 单据状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据状态")
	@Column(name = "order_state", nullable = true, length = 32)
	private String orderState;

	/**
	 * 汇率
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "汇率")
	@Column(name = "exchange_rate", nullable = true, length = 18)
	private Double exchangeRate;

	/**
	 * 是否期初
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否期初")
	@Column(name = "init_flag", nullable = true, length = 1)
	private Boolean initFlag;

	/**
	 * 实际收款金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "实际收款金额")
	@Column(name = "real_rec_amt", nullable = true, length = 18)
	private Double realRecAmt;

	/**
	 * 实际收款金额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "实际收款金额(本位币)")
	@Column(name = "real_rec_cur_amt", nullable = true, length = 18)
	private Double realRecCurAmt;

	/**
	 * 付款日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款日期")
	@Column(name = "pay_date", nullable = true)
	private LocalDateTime payDate;

	/**
	 * 是否预付
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "是否预付")
	@Column(name = "pay_flag", nullable = true, length = 1)
	private Boolean payFlag;

	/**
	 * 审核拒绝理由
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审核拒绝理由")
	@Column(name = "audit_rejection", nullable = true, length = 128)
	private String auditRejection;

	/**
	 * 单据来源
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据来源")
	@Column(name = "create_mode", nullable = true, length = 32)
	private String createMode;

	/**
	 * 核销状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销状态")
	@Column(name = "ver_state", nullable = true, length = 32)
	private String verState;

	/**
	 * 已核销金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "已核销金额")
	@Column(name = "ver_amt", nullable = true, length = 18)
	private Double verAmt;

	/**
	 * 未核销金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "未核销金额")
	@Column(name = "un_ver_amt", nullable = true, length = 18)
	private Double unVerAmt;

	/**
	 * 供应商ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "supp_id", nullable = true)
	private Long suppId;

	/**
	 * 供应商编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商编号")
	@Column(name = "supp_code", nullable = true, length = 32)
	private String suppCode;

	/**
	 * 供应商名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商名称")
	@Column(name = "supp_name", nullable = true, length = 32)
	private String suppName;

	/**
	 * 销售部门ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "bu_id", nullable = true)
	private Long buId;

	/**
	 * 销售部门编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售部门编码")
	@Column(name = "bu_code", nullable = true, length = 32)
	private String buCode;

	/**
	 * 销售部门名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售部门名称")
	@Column(name = "bu_name", nullable = true, length = 32)
	private String buName;

	/**
	 * 付款公司编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款公司编码")
	@Column(name = "pay_ou_code", nullable = true, length = 32)
	private String payOuCode;

	/**
	 * 付款公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_ou_id", nullable = true)
	private Long payOuId;

	/**
	 * 付款公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款公司名称")
	@Column(name = "pay_ou_name", nullable = true, length = 32)
	private String payOuName;

	/**
	 * 销售组织编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售组织编码")
	@Column(name = "org_code", nullable = true, length = 32)
	private String orgCode;

	/**
	 * 销售组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "org_id", nullable = true)
	private Long orgId;

	/**
	 * 销售组织名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "销售组织名称")
	@Column(name = "org_name", nullable = true, length = 32)
	private String orgName;

	/**
	 * 税额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税额")
	@Column(name = "tax_amt", nullable = true, length = 18)
	private Double taxAmt;

	/**
	 * 单据类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "单据类型")
	@Column(name = "pay_order_type", nullable = true, length = 32)
	private String payOrderType;

	/**
	 * 税额(本位币)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "税额(本位币)")
	@Column(name = "tax_cur_amt", nullable = true, length = 18)
	private Double taxCurAmt;

	/**
	 * 流程实例ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "流程实例ID")
	@Column(name = "proc_inst_id", nullable = true, length = 64)
	private String procInstId;

	/**
	 * 流程实例状态
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "流程实例状态")
	@Column(name = "proc_inst_status", nullable = true, length = 32)
	private String procInstStatus;

	/**
	 * 提交时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "提交时间")
	@Column(name = "submit_time", nullable = true)
	private LocalDateTime submitTime;

	/**
	 * 审批通过时间
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "审批通过时间")
	@Column(name = "approved_time", nullable = true)
	private LocalDateTime approvedTime;

	/**
	 * 地址号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "地址号")
	@Column(name = "addr_no", nullable = true, length = 32)
	private String addrNo;

	/**
	 * 供应商地址号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商地址号")
	@Column(name = "supp_addr_no", nullable = true, length = 32)
	private String suppAddrNo;

	/**
	 * 具体订单场景
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "具体订单场景")
	@Column(name = "doc_type", nullable = true, length = 32)
	private String docType;

	/**
	 * B端订单/C端订单
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "B端订单/C端订单")
	@Column(name = "doc_type2", nullable = true, length = 32)
	private String docType2;

	/**
	 * 传PO代表正向，传RNS代表退货负向
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "传PO代表正向，传RNS代表退货负向")
	@Column(name = "doc_cls", nullable = true, length = 32)
	private String docCls;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;

	/**
	 * 付款单关联id
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单关联id")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "relate_id", nullable = true)
	private Long relateId;

	/**
	 * 发票号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票号")
	@Column(name = "invoice_number", nullable = true, length = 32)
	private String invoiceNumber;

	/**
	 * 红冲标志
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "红冲标志")
	@Column(name = "red_flush_sign", nullable = true, length = 32)
	private String redFlushSign;

	/**
	 * 第三方支付辅助
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "第三方支付辅助")
	@Column(name = "third_payment_assistance", nullable = true, length = 32)
	private String thirdPaymentAssistance;

	/**
	 * 消费卡辅助
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "消费卡辅助")
	@Column(name = "consumer_card_ssistance", nullable = true, length = 32)
	private String consumerCardSsistance;

	/**
	 * 信用卡辅助
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "信用卡辅助")
	@Column(name = "credit_card_assistance", nullable = true, length = 32)
	private String creditCardAssistance;

	/**
	 * 收款银行账户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款银行账户")
	@Column(name = "rec_bank", nullable = true, length = 500)
	private String recBank;

	/**
	 * 付款银行账户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款银行账户")
	@Column(name = "pay_bank", nullable = true, length = 500)
	private String payBank;

	/**
	 * 结算方式
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "结算方式")
	@Column(name = "pay_type", nullable = true, length = 32)
	private String payType;

	/**
	 * 核销申请中金额
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "核销申请中金额")
	@Column(name = "apply_ver_amting", nullable = true, length = 16)
	private Double applyVerAmting;

	/**
	 * 业务员编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员编码")
	@Column(name = "salesman_code", nullable = true, length = 32)
	private String salesmanCode;
	/**
	 * 经办人ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "经办人ID")
	@JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "oper_user_id", nullable = true)
	private Long operUserId;

	/**
	 * 经办人
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "经办人")
	@Column(name = "operator", nullable = true, length = 32)
	private String operator;

	@ApiModelProperty(value = "预计付款日期")
	@Column(name = "ap_date")
	private LocalDateTime apDate;
}
