package com.elitesland.fin.domain.service.arverconfig;

import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigDtlConvert;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfig;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfigDO;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfigDtlDO;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepo;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigDtlRepoProc;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigRepo;
import com.elitesland.fin.infr.repo.arverconfig.ArVerConfigRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 14:56
 */
@Service
@RequiredArgsConstructor
public class ArVerConfigDomainServiceImpl implements ArVerConfigDomainService {

    private final ArVerConfigRepo arVerConfigRepo;
    private final ArVerConfigRepoProc arVerConfigRepoProc;
    private final ArVerConfigDtlRepo arVerConfigDtlRepo;
    private final ArVerConfigDtlRepoProc arVerConfigDtlRepoProc;

    private final SeqNumProvider sysNumberRuleService;


    @Transactional(rollbackFor = {Exception.class})
    @Override
    public String save(ArVerConfig arVerConfig) {
        //校验非空
        arVerConfig.checkNotNull();
        //设置默认值
        arVerConfig.defaultValue();
        //数据库第一条数据设置为默认  如果是修改不用设置是否默认
        if (arVerConfig.getId() == null) {
            arVerConfig.setDefaultFlag(!arVerConfigRepoProc.isFirst());
            Boolean nameByName = arVerConfigRepoProc.existNameByName(arVerConfig.getSchemeName());
            if(nameByName){
                throw new BusinessException("已存在的方案名称!");
            }
        }else{
            Boolean existNameById = arVerConfigRepoProc.existNameById(arVerConfig.getSchemeName(), arVerConfig.getId());
            if(existNameById){
                throw new BusinessException("已存在的方案名称!");
            }
        }

        return saveOrUpdate(arVerConfig).toString();
    }

    @Override
    public ArVerConfigDTO queryById(Long id) {
        ArVerConfigDTO apVerConfigDTO = arVerConfigRepoProc.queryById(id);
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = arVerConfigDtlRepoProc.queryByMasId(id);
        apVerConfigDTO.setArVerConfigDtlDTOS(arVerConfigDtlDTOS);
        return apVerConfigDTO;
    }

    @Override
    public PagingVO<ArVerConfigDTO> page(ArVerConfigPageParam param) {
        return arVerConfigRepoProc.page(param);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void updateEnable(List<Long> ids,boolean state) {
        List<ArVerConfigDTO> arVerConfigDTOS = arVerConfigRepoProc.queryByIds(ids);
        if(!state){
            arVerConfigDTOS.forEach(dto -> {
                if (!dto.getEnableFlag()) {
                    throw new BusinessException("已停用状态不允许停用!");
                }
            });
        }else{
            arVerConfigDTOS.forEach(dto -> {
                if (dto.getEnableFlag()) {
                    throw new BusinessException("已启用状态不允许启用!");
                }
            });
        }
        arVerConfigRepoProc.updateEnable(ids,state);
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long updateDef(Long id) {
        ArVerConfigDTO arVerConfigDTO = arVerConfigRepoProc.queryById(id);
        if (arVerConfigDTO.getDefaultFlag()) {
            throw new BusinessException("已默认状态不允许再次默认!");
        }
        //先更新其他默认数据为否
        arVerConfigRepoProc.updateDefault();
        //更新自己为默认
        return arVerConfigRepoProc.updateDefaultById(id, true);
    }

    @Override
    public List<ArVerConfigDTO> queryAll() {
        return arVerConfigRepoProc.queryAll();
    }

    @Override
    public ArVerConfigDTO queryDef() {
        return arVerConfigRepoProc.queryDef();
    }

    @Override
    public List<ArVerConfigDtlDTO> queryDtl() {
        return arVerConfigDtlRepoProc.queryNoMasId();
    }

    @Override
    public List<ArVerConfigDtlDTO> queryByMasId(Long masId) {
        return arVerConfigDtlRepoProc.queryByMasId(masId);
    }

    private Long saveOrUpdate(ArVerConfig arVerConfig) {
        ArVerConfigDO arVerConfigDO = ArVerConfigConvert.INSTANCE.convert(arVerConfig);
        //先删除明细
        if (arVerConfig.getId() != null) {
            arVerConfigDtlRepoProc.deleteByMasId(arVerConfig.getId());
        } else {
            String payOrderNo = sysNumberRuleService.generateCode(FinConstant.FIN,FinConstant.HXFA, null);
            arVerConfigDO.setSchemeNo(payOrderNo);
        }
        ArVerConfigDO arVerConfigDO1 = arVerConfigRepo.save(arVerConfigDO);
        arVerConfig.getConfigDtlList().forEach(dtl -> {
            dtl.setMasId(arVerConfigDO1.getId());
        });
        List<ArVerConfigDtlDO> arVerConfigDtlDOS = ArVerConfigDtlConvert.INSTANCE.convertDo(arVerConfig.getConfigDtlList());
        arVerConfigDtlRepo.saveAll(arVerConfigDtlDOS);
        return arVerConfigDO1.getId();
    }

}
