package com.elitesland.fin.domain.service.payment;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDO;

import java.util.List;
import java.util.Optional;


/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface PaymentRuleConfigDomainService {
    void updateDynamically(PaymentRuleConfigDO paymentRuleConfigDO);

    PagingVO<PaymentRuleConfigPageVO> searchPage(PaymentRuleConfigParam param);

    List<PaymentRuleConfigQueryVO> findRuleConfigByRuleCode(String ruleCode);

    PaymentRuleConfigDTO findByRuleCode(String ruleCode);

    void deleteById(Long id);

    Optional<PaymentRuleConfigDO> findById(Long id);

    List<PaymentRuleConfigDtlDTO> queryAccountAmount(PaymentRuleConfigParam param);

    List<PaymentRuleConfigDtlDTO> pay(PaymentRuleConfigParam param);

    List<PaymentRuleConfigDtlDTO> queryPaymentRuleConfigDtl(PaymentRuleConfigParam paymentRuleConfigParam);

}
