package com.elitesland.fin.infr.factory.arorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.factory.arorder
 * @date 2022/4/12 17:52
 */
@RequiredArgsConstructor
@Component
public class ArOrderFactory {

    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        PagingVO<ArOrderDTO> page = arOrderRepoProc.page(arOrderPageParam, masId);
        page.getRecords().forEach(x -> {
                    x.setTotalCount(arOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO,BigDecimal::add));
                    x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
                }
        );
        return page;
    }
    
    public Long pageCount(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        return 0l;
    }
    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        List<Long> masIds = arOrderDtlRepoProc.findUnverBySourceId(arOrderPageParam);
        if(CollectionUtils.isEmpty(masIds)){
            return new PagingVO<>(0,new ArrayList<>());
        }
        PagingVO<ArOrderDTO> page = arOrderRepoProc.unverPage(arOrderPageParam, masIds);
        return page;
    }
}
