package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleValueDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinJournalDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFlexibleValueDO;
import com.elitesland.fin.entity.limitadjustorder.QLimitAdjustOrderDO;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import net.sf.cglib.core.Local;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinFlexibleValueRepoProc {


    private final JPAQueryFactory jpaQueryFactory;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final QFinFlexibleValueDO qFinFlexibleValueDO = QFinFlexibleValueDO.finFlexibleValueDO;


    public List<FinFlexibleValueDO> findByMasIdInAndValidTime(List<Long> ids, LocalDateTime localDateTime) {

        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }

        Predicate where = where(ids, localDateTime);
        JPAQuery<FinFlexibleValueDO> query = select(FinFlexibleValueDO.class).where(ExpressionUtils.allOf(where));

        List<FinFlexibleValueDO> finFlexibleValueDOList = query.fetch();
        Assert.notEmpty(finFlexibleValueDOList, "查不到有效的值集明细");

        return finFlexibleValueDOList;
    }

    private Predicate where(List<Long> ids, LocalDateTime localDateTime) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andIn(CollectionUtils.isNotEmpty(ids), qFinFlexibleValueDO.masId, ids)
                .andLoe(localDateTime != null, qFinFlexibleValueDO.activeStartTime, localDateTime)
                .andGoe(localDateTime != null, qFinFlexibleValueDO.activeEndTime, localDateTime)
                .build();
    }
    private Predicate wherenew(FinFlexibleValueParam finFlexibleValueParam) {
        BaseRepoProc.PredicateBuilder builder = BaseRepoProc.PredicateBuilder.builder();
        if(finFlexibleValueParam.getMasId()!=null){
            builder.andEq(qFinFlexibleValueDO.masId, finFlexibleValueParam.getMasId());
        }
        if(finFlexibleValueParam.getDescendantsFlag()!=null){
            builder.andEq(qFinFlexibleValueDO.descendantsFlag, finFlexibleValueParam.getDescendantsFlag());
        }
        if(finFlexibleValueParam.getActiveFlag()!=null){
            builder.andEq(qFinFlexibleValueDO.activeFlag, finFlexibleValueParam.getActiveFlag());
        }
        if(finFlexibleValueParam.getAccountFlag()!=null){
            builder.andEq(qFinFlexibleValueDO.accountFlag, finFlexibleValueParam.getAccountFlag());
        }
        if(finFlexibleValueParam.getFlexibleValueCode()!=null){
            builder.andLike(qFinFlexibleValueDO.flexibleValueCode, finFlexibleValueParam.getFlexibleValueCode());
        }
        if(finFlexibleValueParam.getFlexibleValueName()!=null){
            builder.andLike(qFinFlexibleValueDO.flexibleValueName, finFlexibleValueParam.getFlexibleValueName());
        }
        if(finFlexibleValueParam.getMasFlexibleValueCode()!=null){
            builder.andLike(qFinFlexibleValueDO.masFlexibleValueCode, finFlexibleValueParam.getMasFlexibleValueCode());
        }
        if(finFlexibleValueParam.getMasFlexibleValueName()!=null){
            builder.andLike(qFinFlexibleValueDO.masFlexibleValueName, finFlexibleValueParam.getMasFlexibleValueName());
        }
        if(finFlexibleValueParam.getParentFlexibleValueCode()!=null){
            builder.andLike(qFinFlexibleValueDO.parentFlexibleValueCode, finFlexibleValueParam.getParentFlexibleValueCode());
        }
        if(finFlexibleValueParam.getParentFlexibleValueName()!=null){
            builder.andLike(qFinFlexibleValueDO.parentFlexibleValueName, finFlexibleValueParam.getParentFlexibleValueName());
        }
        return builder.build();
    }
    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.fields(cls,
                qFinFlexibleValueDO.id,
                qFinFlexibleValueDO.masId,
                qFinFlexibleValueDO.serialNum,
                qFinFlexibleValueDO.flexibleValueCode,
                qFinFlexibleValueDO.flexibleValueName,
                qFinFlexibleValueDO.descendantsFlag,
                qFinFlexibleValueDO.activeFlag,
                qFinFlexibleValueDO.accountFlag,
                qFinFlexibleValueDO.parentFlexibleValueCode,
                qFinFlexibleValueDO.parentFlexibleValueName,
                qFinFlexibleValueDO.masFlexibleValueCode,
                qFinFlexibleValueDO.masFlexibleValueName,
                qFinFlexibleValueDO.activeStartTime,
                qFinFlexibleValueDO.activeEndTime
        )).from(qFinFlexibleValueDO);
    }
    public PagingVO<FinFlexibleValueDTO> page(FinFlexibleValueParam finFlexibleValueParam) {
        Predicate where = wherenew(finFlexibleValueParam);
        JPAQuery<FinFlexibleValueDTO> query = select(FinFlexibleValueDTO.class).where(ExpressionUtils.allOf(where));
        finFlexibleValueParam.setPaging(query);
        finFlexibleValueParam.fillOrders(query, qFinFlexibleValueDO);
        List<FinFlexibleValueDTO> finFlexibleValueDTOS = query.fetch();
        return PagingVO.<FinFlexibleValueDTO>builder()
                .total(query.fetchCount())
                .records(finFlexibleValueDTOS)
                .build();
    }
}
