package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinJournalDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFlexibleValueDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinJournalDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinJournalRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinJournalRepo finJournalRepo;

    private final QFinJournalDO qFinJournalDO = QFinJournalDO.finJournalDO;

    public PagingVO<FinJournalDTO> page(FinJournalParam finJournalParam) {
        Predicate where = where(finJournalParam);
        JPAQuery<FinJournalDTO> query = select(FinJournalDTO.class).where(ExpressionUtils.allOf(where));
        finJournalParam.setPaging(query);
        finJournalParam.fillOrders(query, qFinJournalDO);

        List<FinJournalDTO> finFlexibleDTOList = query.fetch();

        return PagingVO.<FinJournalDTO>builder()
                .total(query.fetchCount())
                .records(finFlexibleDTOList)
                .build();
    }

    private Predicate where(FinJournalParam finJournalParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finJournalParam.getId() != null, qFinJournalDO.id, finJournalParam.getId())
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSobLedgerCode()), qFinJournalDO.sobLedgerCode, StringUtil.buildLikeString(finJournalParam.getSobLedgerCode()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSobLedgerName()), qFinJournalDO.sobLedgerName, StringUtil.buildLikeString(finJournalParam.getSobLedgerName()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSystemSourceCode()), qFinJournalDO.systemSourceCode, StringUtil.buildLikeString(finJournalParam.getSystemSourceCode()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSystemSourceName()), qFinJournalDO.systemSourceName, StringUtil.buildLikeString(finJournalParam.getSystemSourceName()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getDocNum()), qFinJournalDO.docNum, StringUtil.buildLikeString(finJournalParam.getDocNum()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getDocType()), qFinJournalDO.docType, StringUtil.buildLikeString(finJournalParam.getDocType()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getVoucherTypeCode()), qFinJournalDO.voucherTypeCode, StringUtil.buildLikeString(finJournalParam.getVoucherTypeCode()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getVoucherTypeName()), qFinJournalDO.voucherTypeName, StringUtil.buildLikeString(finJournalParam.getVoucherTypeName()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment1()), qFinJournalDO.segment1, StringUtil.buildLikeString(finJournalParam.getSegment1()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment2()), qFinJournalDO.segment2, StringUtil.buildLikeString(finJournalParam.getSegment2()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment3()), qFinJournalDO.segment3, StringUtil.buildLikeString(finJournalParam.getSegment3()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment4()), qFinJournalDO.segment4, StringUtil.buildLikeString(finJournalParam.getSegment4()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment5()), qFinJournalDO.segment5, StringUtil.buildLikeString(finJournalParam.getSegment5()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment6()), qFinJournalDO.segment6, StringUtil.buildLikeString(finJournalParam.getSegment6()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment7()), qFinJournalDO.segment7, StringUtil.buildLikeString(finJournalParam.getSegment7()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment8()), qFinJournalDO.segment8, StringUtil.buildLikeString(finJournalParam.getSegment8()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment9()), qFinJournalDO.segment9, StringUtil.buildLikeString(finJournalParam.getSegment9()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment10()), qFinJournalDO.segment10, StringUtil.buildLikeString(finJournalParam.getSegment10()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment11()), qFinJournalDO.segment11, StringUtil.buildLikeString(finJournalParam.getSegment11()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment12()), qFinJournalDO.segment12, StringUtil.buildLikeString(finJournalParam.getSegment12()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment13()), qFinJournalDO.segment13, StringUtil.buildLikeString(finJournalParam.getSegment13()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment14()), qFinJournalDO.segment14, StringUtil.buildLikeString(finJournalParam.getSegment14()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment15()), qFinJournalDO.segment15, StringUtil.buildLikeString(finJournalParam.getSegment15()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment16()), qFinJournalDO.segment16, StringUtil.buildLikeString(finJournalParam.getSegment16()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment17()), qFinJournalDO.segment17, StringUtil.buildLikeString(finJournalParam.getSegment17()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getSegment18()), qFinJournalDO.segment18, StringUtil.buildLikeString(finJournalParam.getSegment18()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getCurrCode()), qFinJournalDO.currCode, StringUtil.buildLikeString(finJournalParam.getCurrCode()))
                .andLike(StringUtils.isNotEmpty(finJournalParam.getAccountPeriod()), qFinJournalDO.accountPeriod, StringUtil.buildLikeString(finJournalParam.getAccountPeriod()))
                .andAfter(finJournalParam.getGlDateStart() != null, qFinJournalDO.glDate, finJournalParam.getGlDateStart())
                .andBefore(finJournalParam.getGlDateEnd() != null, qFinJournalDO.glDate, finJournalParam.getGlDateEnd())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinJournalDO.id,
                qFinJournalDO.docNum,
                qFinJournalDO.docType,
                qFinJournalDO.systemSourceCode,
                qFinJournalDO.systemSourceName,
                qFinJournalDO.voucherTypeCode,
                qFinJournalDO.voucherTypeName,
                qFinJournalDO.segment1,
                qFinJournalDO.segment2,
                qFinJournalDO.segment3,
                qFinJournalDO.segment4,
                qFinJournalDO.segment5,
                qFinJournalDO.segment6,
                qFinJournalDO.segment7,
                qFinJournalDO.segment8,
                qFinJournalDO.segment9,
                qFinJournalDO.segment10,
                qFinJournalDO.segment11,
                qFinJournalDO.segment12,
                qFinJournalDO.segment13,
                qFinJournalDO.segment14,
                qFinJournalDO.segment15,
                qFinJournalDO.segment16,
                qFinJournalDO.segment17,
                qFinJournalDO.segment18,
                qFinJournalDO.dC.as("dc"),
                qFinJournalDO.debitAmt,
                qFinJournalDO.creditAmt,
                qFinJournalDO.debitCurAmt,
                qFinJournalDO.creditCurAmt,
                qFinJournalDO.currCode,
                qFinJournalDO.currName,
                qFinJournalDO.exchangeRate,
                qFinJournalDO.glDate,
                qFinJournalDO.accountPeriod,
                qFinJournalDO.sobLedgerCode,
                qFinJournalDO.sobLedgerName,

                qFinJournalDO.createTime,
                qFinJournalDO.creator,
                qFinJournalDO.modifyTime,
                qFinJournalDO.updater
        )).from(qFinJournalDO);
    }
}
