package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyApQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyApVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyApDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;
import com.elitesland.fin.domain.entity.writeoff.QFinApPayVerApplyApDO;
import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinApPayVerApplyApRepoProc extends BaseRepoProc<FinApPayVerApplyApDO> {

    private static final QFinApPayVerApplyApDO QDO = QFinApPayVerApplyApDO.finApPayVerApplyApDO;

    protected FinApPayVerApplyApRepoProc() {
        super(QDO);
    }

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinApPayVerApplyApDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .orderBy(QDO.verAmt.desc())
                .fetch();
    }

	/**
	 * 通过第三方应收单号或者第三方应收单明细ID查询
	 * @param applyQuery
	 * @return
	 */
	public List<FinApPayVerApplyApVO> listByOutApDocNoOrDId(FinApPayVerApplyQuery applyQuery) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();
		// 应收单号
		if(StrUtil.isNotEmpty(applyQuery.getApOrderNo())){
			predicate = ExpressionUtils.and(
					predicate,QDO.apDocNo.like("%"+applyQuery.getApOrderNo()+"%")
			);
		}
		// 第三方应收单明细ID
		if(StrUtil.isNotEmpty(applyQuery.getOutApDId())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outApDId.eq(applyQuery.getOutApDId())
			);
		}
		return jpaQueryFactory.select(Projections.bean(
						FinApPayVerApplyApVO.class,
						QDO.id,
						QDO.masId
				))
				.from(QDO)
				.where(predicate)
				.fetch();
	}

	/**
	 * 根据条件查询核销应收单明细
	 * @param query
	 * @return
	 */
	public List<FinApPayVerApplyApDO> listByQuery(FinApPayVerApplyApQuery query) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// id
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}

		// masIds
		if(CollUtil.isNotEmpty(query.getMasIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.masId.in(query.getMasIds())
			);
		}

		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.orderBy(QDO.verAmt.desc())
				.fetch();
	}
}
