package com.elitesland.fin.repo.writeoff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyPayQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinApPayVerApplyQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplyPayVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplyPayDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;
import com.elitesland.fin.domain.entity.writeoff.QFinApPayVerApplyPayDO;
import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Repository
public class FinApPayVerApplyPayRepoProc extends BaseRepoProc<FinApPayVerApplyPayDO> {

    private static final QFinApPayVerApplyPayDO QDO = QFinApPayVerApplyPayDO.finApPayVerApplyPayDO;

    protected FinApPayVerApplyPayRepoProc() {
        super(QDO);
    }

    public long deleteByMasId(Collection<Long> masIds) {
        return jpaQueryFactory.delete(QDO)
                .where(QDO.masId.in(masIds))
                .execute();
    }

    public List<FinApPayVerApplyPayDO> listByMasIds(Collection<Long> masIds) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.masId.in(masIds))
                .orderBy(QDO.verAmt.desc())
                .fetch();
    }

	/**
	 * 通过第三方收款单号或者明细ID查询
	 * @param applyQuery
	 * @return
	 */
	public List<FinApPayVerApplyPayVO> listByOutRecDocNoOrDId(FinApPayVerApplyQuery applyQuery) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// 收款单号
		if(StrUtil.isNotEmpty(applyQuery.getPayOrderNo())){
			predicate = ExpressionUtils.and(
					predicate,QDO.payDocNo.like("%"+applyQuery.getPayOrderNo()+"%")
			);
		}

		// 第三方收款单明细ID
		if(StrUtil.isNotEmpty(applyQuery.getOutPayDId())){
			predicate = ExpressionUtils.and(
					predicate,QDO.outPayDId.eq(applyQuery.getOutPayDId())
			);
		}

		return jpaQueryFactory.select(Projections.bean(
						FinApPayVerApplyPayVO.class,
						QDO.id,
						QDO.masId
				))
				.from(QDO)
				.where(predicate)
				.fetch();
	}

	/**
	 * 根据条件查询核销收款单明细
	 * @param query
	 * @return
	 */
	public List<FinApPayVerApplyPayDO> listByQuery(FinApPayVerApplyPayQuery query) {
		Predicate predicate = JpaPredicateBuilder.builder().getPredicate();

		// id
		if(CollUtil.isNotEmpty(query.getIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.id.in(query.getIds())
			);
		}

		// masIds
		if(CollUtil.isNotEmpty(query.getMasIds())){
			predicate = ExpressionUtils.and(
					predicate,QDO.masId.in(query.getMasIds())
			);
		}

		return jpaQueryFactory.select(QDO)
				.from(QDO)
				.where(predicate)
				.orderBy(QDO.verAmt.desc())
				.fetch();
	}
}
