/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleInvRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;

    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam, List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != saleInvPageParam.getOuId()) {
            predicates.add(this.qSaleInvDO.ouId.eq((Object)saleInvPageParam.getOuId()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getCreateMode())) {
            predicates.add(this.qSaleInvDO.createMode.eq((Object)saleInvPageParam.getCreateMode()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getApplyNo())) {
            predicates.add(this.qSaleInvDO.invRegNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getSourceSysNo())) {
            predicates.add(this.qSaleInvDO.sourceSysNo.eq((Object)saleInvPageParam.getSourceSysNo()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getCustName())) {
            predicates.add(this.qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add(this.qSaleInvDO.custId.eq((Object)saleInvPageParam.getCustId()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add(this.qSaleInvDO.custCode.eq((Object)saleInvPageParam.getCustCode()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInvType())) {
            predicates.add(this.qSaleInvDO.invType.eq((Object)saleInvPageParam.getInvType()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInfoNo())) {
            predicates.add(this.qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getExpressNo())) {
            predicates.add(this.qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicates.add(this.qSaleInvDO.id.in(ids));
        }
        predicates.add(this.qSaleInvDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(SaleInvDTO.class).where(ExpressionUtils.allOf(predicates));
        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, this.qSaleInvDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qSaleInvDO.id, this.qSaleInvDO.createTime, this.qSaleInvDO.updater, this.qSaleInvDO.modifyTime, this.qSaleInvDO.creator, this.qSaleInvDO.remark, this.qSaleInvDO.sourceSysNo, this.qSaleInvDO.applyNo, this.qSaleInvDO.ouCode, this.qSaleInvDO.ouId, this.qSaleInvDO.ouName, this.qSaleInvDO.taxRate, this.qSaleInvDO.invRegNo, this.qSaleInvDO.currCode, this.qSaleInvDO.currName, this.qSaleInvDO.localCurrCode, this.qSaleInvDO.localCurrName, this.qSaleInvDO.totalAmt, this.qSaleInvDO.totalCurAmt, this.qSaleInvDO.saleInvTitle, this.qSaleInvDO.saleTaxNo, this.qSaleInvDO.saleTel, this.qSaleInvDO.saleAdd, this.qSaleInvDO.saleBank, this.qSaleInvDO.saleBankAcc, this.qSaleInvDO.saleRemark, this.qSaleInvDO.saleId, this.qSaleInvDO.saleName, this.qSaleInvDO.saleCode, this.qSaleInvDO.custInvTitle, this.qSaleInvDO.custTaxNo, this.qSaleInvDO.custAdd, this.qSaleInvDO.custTel, this.qSaleInvDO.custBank, this.qSaleInvDO.custBankAcc, this.qSaleInvDO.custRemark, this.qSaleInvDO.custId, this.qSaleInvDO.custName, this.qSaleInvDO.custCode, this.qSaleInvDO.invUser, this.qSaleInvDO.recUser, this.qSaleInvDO.revUser, this.qSaleInvDO.auditUserId, this.qSaleInvDO.pushMethod, this.qSaleInvDO.phone, this.qSaleInvDO.email, this.qSaleInvDO.infoNo, this.qSaleInvDO.expressNo, this.qSaleInvDO.invState, this.qSaleInvDO.auditUser, this.qSaleInvDO.auditDate, this.qSaleInvDO.orderState, this.qSaleInvDO.exchangeRate, this.qSaleInvDO.auditRejection, this.qSaleInvDO.createMode, this.qSaleInvDO.invType, this.qSaleInvDO.procInstId, this.qSaleInvDO.procInstStatus, this.qSaleInvDO.approvedTime, this.qSaleInvDO.submitTime, this.qSaleInvDO.mainCustName, this.qSaleInvDO.mainCustCode, this.qSaleInvDO.mainCustId, this.qSaleInvDO.invMerge, this.qSaleInvDO.invCustCode, this.qSaleInvDO.invCustId, this.qSaleInvDO.invCustName, this.qSaleInvDO.drawDate})).from((EntityPath)this.qSaleInvDO);
    }

    public SaleInvDTO get(Long id) {
        SaleInvDTO saleInvDTO = (SaleInvDTO)((JPAQuery)this.select(SaleInvDTO.class).where((Predicate)this.qSaleInvDO.id.eq((Object)id))).fetchOne();
        return saleInvDTO;
    }

    public Long del(List<Long> ids) {
        long res = this.jpaQueryFactory.delete((EntityPath)this.qSaleInvDO).where(new Predicate[]{this.qSaleInvDO.id.in(ids)}).execute();
        return res;
    }

    public Long updateInvInfo(SaleInvParam saleInvParam) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.remark, (Object)saleInvParam.getRemark()).set((Path)this.qSaleInvDO.expressNo, (Object)saleInvParam.getExpressNo()).set((Path)this.qSaleInvDO.infoNo, (Object)saleInvParam.getInfoNo()).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)saleInvParam.getId())}).execute();
        return res;
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qSaleInvDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qSaleInvDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
            jpaUpdateClause.set((Path)this.qSaleInvDO.orderState, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        jpaUpdateClause.execute();
    }

    public void deleteById(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set(this.qSaleInvDO.deleteFlag, (Object)1).where(new Predicate[]{this.qSaleInvDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void updateArFlagByApplyNo(String applyNo, Boolean arFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qSaleInvDO).set((Path)this.qSaleInvDO.arFlag, (Object)arFlag).where(new Predicate[]{this.qSaleInvDO.applyNo.eq((Object)applyNo)}).execute();
    }

    public SaleInvRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

