/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.service.account.AccountBalanceService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepo;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountBalanceServiceImpl
implements AccountBalanceService {
    private static final Logger log = LoggerFactory.getLogger(AccountBalanceServiceImpl.class);
    private final AccountRepoProc accountRepoProc;
    private final AccountRepo accountRepo;
    private final CreditAccountRepo creditAccountRepo;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final PaymentRuleConfigRepo paymentRuleConfigRepo;
    private final PaymentRuleConfigRepoProc paymentRuleConfigRepoProc;
    private static final BigDecimal DIVISOR = BigDecimal.valueOf(100L);
    private final UdcProvider udcProvider;

    @Override
    public List<AccountBalanceVO> selectAccountBalanceByParam(AccountBalanceParam param) {
        log.info("\u67e5\u8be2\u6807\u51c6\u8d26\u6237\u4f59\u989d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isBlank((CharSequence)param.getOuCode())) {
            throw new BusinessException("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)param.getCustCode())) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        AccountPageParam accountPageParam = new AccountPageParam();
        accountPageParam.setSecOuCode(param.getOuCode());
        accountPageParam.setAccountHolderCode(param.getCustCode());
        accountPageParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountVO> accountVOList = this.accountRepoProc.queryList(accountPageParam);
        Map<String, List<AccountVO>> accountListMap = null;
        if (CollectionUtil.isNotEmpty(accountVOList)) {
            accountListMap = accountVOList.stream().collect(Collectors.groupingBy(i -> i.getAccountType()));
            accountListMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    AccountVO accountVO = (AccountVO)value.get(0);
                    throw new BusinessException("\u6309\u7167\u516c\u53f8(" + accountVO.getSecOuCode() + ")+\u5ba2\u6237(" + accountVO.getAccountHolderCode() + ")+\u8d26\u6237\u7c7b\u578b(" + accountVO.getAccountType() + ")\u7ef4\u5ea6\u67e5\u51fa\u591a\u4e2a\u8d26\u6237\u6570\u636e");
                }
            });
        }
        CreditAccountPageParam creditAccountPageParam = new CreditAccountPageParam();
        creditAccountPageParam.setOuCode(param.getOuCode());
        creditAccountPageParam.setObjectCode(param.getCustCode());
        creditAccountPageParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountPageVO> creditAccountVOList = this.creditAccountRepoProc.queryList(creditAccountPageParam);
        Map<String, List<CreditAccountPageVO>> creditAccountListMap = null;
        if (CollectionUtil.isNotEmpty(creditAccountVOList)) {
            creditAccountListMap = creditAccountVOList.stream().collect(Collectors.groupingBy(i -> i.getCreditAccountType()));
            creditAccountListMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    CreditAccountPageVO creditAccountPageVO = (CreditAccountPageVO)value.get(0);
                    throw new BusinessException("\u6309\u7167\u516c\u53f8(" + creditAccountPageVO.getOuCode() + ")+\u5ba2\u6237(" + creditAccountPageVO.getObjectCode() + ")+\u8d26\u6237\u7c7b\u578b(" + creditAccountPageVO.getCreditAccountType() + ")\u7ef4\u5ea6\u67e5\u51fa\u591a\u4e2a\u4fe1\u7528\u8d26\u6237\u6570\u636e");
                }
            });
        }
        if (CollectionUtil.isEmpty(accountVOList) && CollectionUtil.isEmpty(creditAccountVOList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f");
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f");
        }
        Map accountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map creditAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
        ArrayList<AccountBalanceVO> accountBalanceAllList = new ArrayList<AccountBalanceVO>();
        if (Objects.isNull(param.getAmt())) {
            List<AccountBalanceVO> accountBalanceVOList = this.handleAccountBalance01(accountListMap, creditAccountListMap);
            if (CollectionUtil.isNotEmpty(accountBalanceVOList)) {
                accountBalanceAllList.addAll(accountBalanceVOList);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)param.getOptDoc()) || StringUtils.isBlank((CharSequence)param.getOptDocType()) || StringUtils.isBlank((CharSequence)param.getOptDocStatus())) {
                throw new BusinessException("\u6263\u6b3e\u5355\u636e\u3001\u6263\u6b3e\u5355\u636e\u7c7b\u578b\u3001\u6263\u6b3e\u5355\u636e\u72b6\u6001\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PaymentRuleConfigParam paymentRuleConfigParam = new PaymentRuleConfigParam();
            paymentRuleConfigParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
            paymentRuleConfigParam.setOptDoc(param.getOptDoc());
            paymentRuleConfigParam.setOptDocType(param.getOptDocType());
            paymentRuleConfigParam.setOptDocStatus(param.getOptDocStatus());
            List<PaymentRuleConfigPageVO> paymentRuleConfigList = this.paymentRuleConfigRepoProc.selectPaymentRuleConfigByParam(paymentRuleConfigParam);
            if (CollectionUtil.isEmpty(paymentRuleConfigList)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f");
            }
            Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap = paymentRuleConfigList.stream().collect(Collectors.groupingBy(i -> i.getOptAccountType()));
            paymentRuleConfigMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    throw new BusinessException("\u6309\u7167\u8d26\u6237\u7c7b\u578b(" + key + ")\u7ef4\u5ea6\u67e5\u51fa\u591a\u4e2a\u652f\u4ed8\u914d\u7f6e\u6570\u636e");
                }
            });
            List<AccountBalanceVO> accountBalanceVOList = this.handleAccountBalance02(accountVOList, creditAccountVOList, accountListMap, creditAccountListMap, paymentRuleConfigMap, param);
            if (CollectionUtil.isNotEmpty(accountBalanceVOList)) {
                accountBalanceAllList.addAll(accountBalanceVOList);
            }
        }
        if (CollectionUtil.isNotEmpty(accountBalanceAllList)) {
            accountBalanceAllList.forEach(accountBalanceVO -> {
                String accType = accountBalanceVO.getAccType();
                if (StringUtils.isNotBlank((CharSequence)accType)) {
                    if (MapUtil.isNotEmpty((Map)accountTypeUdc) && StringUtils.isNotBlank((CharSequence)((CharSequence)accountTypeUdc.get(accType)))) {
                        accountBalanceVO.setAccTypeName((String)accountTypeUdc.get(accType));
                    } else if (MapUtil.isNotEmpty((Map)creditAccountTypeUdc) && StringUtils.isNotBlank((CharSequence)((CharSequence)creditAccountTypeUdc.get(accType)))) {
                        accountBalanceVO.setAccTypeName((String)creditAccountTypeUdc.get(accType));
                    }
                }
            });
        }
        return accountBalanceAllList;
    }

    private List<AccountBalanceVO> handleAccountBalance01(Map<String, List<AccountVO>> accountListMap, Map<String, List<CreditAccountPageVO>> creditAccountListMap) {
        ArrayList<AccountBalanceVO> accountBalanceVOList = new ArrayList<AccountBalanceVO>();
        if (MapUtil.isNotEmpty(accountListMap)) {
            accountListMap.forEach((key, value) -> {
                AccountVO accountVO = (AccountVO)value.get(0);
                AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
                accountBalanceVO.setAccType(accountVO.getAccountType());
                accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                accountBalanceVO.setAccountName(accountVO.getAccountName());
                accountBalanceVO.setAccountAvailableAmount(accountVO.getAccountAvailableAmount());
                if (accountVO.getAccountAvailableAmount().compareTo(BigDecimal.ZERO) < 1) {
                    accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                } else {
                    accountBalanceVO.setThisBillAvailableAmount(accountVO.getAccountAvailableAmount());
                }
                accountBalanceVOList.add(accountBalanceVO);
            });
        }
        if (MapUtil.isNotEmpty(creditAccountListMap)) {
            creditAccountListMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = (CreditAccountPageVO)value.get(0);
                AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
                accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                accountBalanceVO.setAccountAvailableAmount(creditAccountVO.getCreditAccountAvailableLimit());
                if (creditAccountVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) < 1) {
                    accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                } else {
                    accountBalanceVO.setThisBillAvailableAmount(creditAccountVO.getCreditAccountAvailableLimit());
                }
                accountBalanceVOList.add(accountBalanceVO);
            });
        }
        return accountBalanceVOList;
    }

    private List<AccountBalanceVO> handleAccountBalance02(List<AccountVO> accountList, List<CreditAccountPageVO> creditAccountList, Map<String, List<AccountVO>> accountMap, Map<String, List<CreditAccountPageVO>> creditAccountMap, Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap, AccountBalanceParam accountBalanceParam) {
        ArrayList<AccountBalanceVO> accountBalanceVOList = new ArrayList<AccountBalanceVO>();
        Boolean accountTypeFlag = false;
        if (CollectionUtil.isNotEmpty(accountList)) {
            accountTypeFlag = accountList.stream().anyMatch(accountVO -> Objects.equals(accountVO.getAccountType(), UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()));
        }
        Boolean creditAccountTypeFlag = false;
        if (CollectionUtil.isNotEmpty(creditAccountList)) {
            creditAccountTypeFlag = creditAccountList.stream().anyMatch(creditAccountVO -> Objects.equals(creditAccountVO.getCreditAccountType(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()));
        }
        if (accountTypeFlag.booleanValue() && creditAccountTypeFlag.booleanValue()) {
            accountMap.forEach((key, value) -> {
                AccountVO accountVO = (AccountVO)value.get(0);
                if (Objects.equals(key, UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())) {
                    AccountBalanceVO accountBalanceVO;
                    CreditAccountPageVO creditAccountCheckVO = (CreditAccountPageVO)((List)creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode())).get(0);
                    if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) > -1) {
                        AccountBalanceVO accountBalanceVO2 = this.handleAccountBalance0201(accountVO.getAccountType(), accountVO.getAccountAvailableAmount(), paymentRuleConfigMap, accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO2)) {
                            accountBalanceVO2.setAccType(accountVO.getAccountType());
                            accountBalanceVO2.setAccountCode(accountVO.getAccountCode());
                            accountBalanceVO2.setAccountName(accountVO.getAccountName());
                            accountBalanceVOList.add(accountBalanceVO2);
                        }
                    } else if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) == -1 && Objects.nonNull(accountBalanceVO = this.handleAccountBalance0202(accountVO.getAccountType(), accountVO.getAccountAvailableAmount(), accountMap, creditAccountMap, paymentRuleConfigMap, accountBalanceParam))) {
                        accountBalanceVO.setAccType(accountVO.getAccountType());
                        accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                        accountBalanceVO.setAccountName(accountVO.getAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                } else {
                    AccountBalanceVO accountBalanceVO = this.handleAccountBalance0201(accountVO.getAccountType(), accountVO.getAccountAvailableAmount(), paymentRuleConfigMap, accountBalanceParam);
                    if (Objects.nonNull(accountBalanceVO)) {
                        accountBalanceVO.setAccType(accountVO.getAccountType());
                        accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                        accountBalanceVO.setAccountName(accountVO.getAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                }
            });
            creditAccountMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = (CreditAccountPageVO)value.get(0);
                if (Objects.equals(key, UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())) {
                    AccountBalanceVO accountBalanceVO;
                    CreditAccountPageVO creditAccountCheckVO = (CreditAccountPageVO)((List)creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode())).get(0);
                    if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) > -1) {
                        AccountBalanceVO accountBalanceVO2 = this.handleAccountBalance0201(creditAccountVO.getCreditAccountType(), creditAccountVO.getCreditAccountAvailableLimit(), paymentRuleConfigMap, accountBalanceParam);
                        if (Objects.nonNull(accountBalanceVO2)) {
                            accountBalanceVO2.setAccType(creditAccountVO.getCreditAccountType());
                            accountBalanceVO2.setAccountCode(creditAccountVO.getCreditAccountCode());
                            accountBalanceVO2.setAccountName(creditAccountVO.getCreditAccountName());
                            accountBalanceVOList.add(accountBalanceVO2);
                        }
                    } else if (creditAccountCheckVO.getCreditAccountAvailableLimit().compareTo(BigDecimal.ZERO) == -1 && Objects.nonNull(accountBalanceVO = this.handleAccountBalance0202(creditAccountVO.getCreditAccountType(), creditAccountVO.getCreditAccountAvailableLimit(), accountMap, creditAccountMap, paymentRuleConfigMap, accountBalanceParam))) {
                        accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                        accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                        accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                } else {
                    AccountBalanceVO accountBalanceVO = this.handleAccountBalance0201(creditAccountVO.getCreditAccountType(), creditAccountVO.getCreditAccountAvailableLimit(), paymentRuleConfigMap, accountBalanceParam);
                    if (Objects.nonNull(accountBalanceVO)) {
                        accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                        accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                        accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                        accountBalanceVOList.add(accountBalanceVO);
                    }
                }
            });
        } else {
            accountMap.forEach((key, value) -> {
                AccountVO accountVO = (AccountVO)value.get(0);
                AccountBalanceVO accountBalanceVO = this.handleAccountBalance0201(accountVO.getAccountType(), accountVO.getAccountAvailableAmount(), paymentRuleConfigMap, accountBalanceParam);
                if (Objects.nonNull(accountBalanceVO)) {
                    accountBalanceVO.setAccType(accountVO.getAccountType());
                    accountBalanceVO.setAccountCode(accountVO.getAccountCode());
                    accountBalanceVO.setAccountName(accountVO.getAccountName());
                    accountBalanceVOList.add(accountBalanceVO);
                }
            });
            creditAccountMap.forEach((key, value) -> {
                CreditAccountPageVO creditAccountVO = (CreditAccountPageVO)value.get(0);
                AccountBalanceVO accountBalanceVO = this.handleAccountBalance0201(creditAccountVO.getCreditAccountType(), creditAccountVO.getCreditAccountAvailableLimit(), paymentRuleConfigMap, accountBalanceParam);
                if (Objects.nonNull(accountBalanceVO)) {
                    accountBalanceVO.setAccType(creditAccountVO.getCreditAccountType());
                    accountBalanceVO.setAccountCode(creditAccountVO.getCreditAccountCode());
                    accountBalanceVO.setAccountName(creditAccountVO.getCreditAccountName());
                    accountBalanceVOList.add(accountBalanceVO);
                }
            });
        }
        return accountBalanceVOList;
    }

    private AccountBalanceVO handleAccountBalance0201(String accountType, BigDecimal accountAvailableAmount, Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap, AccountBalanceParam accountBalanceParam) {
        AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
        accountBalanceVO.setAccountAvailableAmount(accountAvailableAmount);
        BigDecimal amt = accountBalanceParam.getAmt();
        String optAccountType = this.convertOptAccountType(accountType);
        if (StringUtils.isBlank((CharSequence)optAccountType)) {
            throw new BusinessException("\u8d26\u6237\u7c7b\u578b(" + accountType + ")\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e\u7684\u8d26\u6237\u7c7b\u578b");
        }
        List<PaymentRuleConfigPageVO> paymentRuleConfigList = paymentRuleConfigMap.get(optAccountType);
        if (CollectionUtil.isEmpty(paymentRuleConfigList)) {
            throw new BusinessException("\u8d26\u6237\u7c7b\u578b(" + accountType + ")\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e\u6570\u636e");
        }
        PaymentRuleConfigPageVO paymentRuleConfigDTO = paymentRuleConfigList.get(0);
        if (Objects.isNull(paymentRuleConfigDTO.getCalculatePercent())) {
            throw new BusinessException("\u652f\u4ed8\u914d\u7f6e(" + paymentRuleConfigDTO.getRuleName() + "-" + paymentRuleConfigDTO.getOptAccountType() + ")\u7684\u6263\u6b3e\u6bd4\u4f8b\u4e3a\u7a7a\uff01");
        }
        Integer priorityNo = paymentRuleConfigDTO.getPriorityNo();
        accountBalanceVO.setPriorityNo(priorityNo);
        BigDecimal calculatePercent = paymentRuleConfigDTO.getCalculatePercent();
        BigDecimal calculatePercentAmt = amt.multiply(calculatePercent.divide(DIVISOR));
        if (calculatePercentAmt.compareTo(accountAvailableAmount) == 1) {
            if (accountAvailableAmount.compareTo(BigDecimal.ZERO) == 1) {
                accountBalanceVO.setThisBillAvailableAmount(accountAvailableAmount);
                return accountBalanceVO;
            }
            if (accountAvailableAmount.compareTo(BigDecimal.ZERO) < 1) {
                accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                return accountBalanceVO;
            }
        } else if (calculatePercentAmt.compareTo(BigDecimal.ZERO) > -1 && calculatePercentAmt.compareTo(accountAvailableAmount) < 1) {
            accountBalanceVO.setThisBillAvailableAmount(calculatePercentAmt);
            return accountBalanceVO;
        }
        return null;
    }

    private AccountBalanceVO handleAccountBalance0202(String accountType, BigDecimal accountAvailableAmount, Map<String, List<AccountVO>> accountMap, Map<String, List<CreditAccountPageVO>> creditAccountMap, Map<String, List<PaymentRuleConfigPageVO>> paymentRuleConfigMap, AccountBalanceParam accountBalanceParam) {
        AccountBalanceVO accountBalanceVO = new AccountBalanceVO();
        accountBalanceVO.setAccountAvailableAmount(accountAvailableAmount);
        BigDecimal amt = accountBalanceParam.getAmt();
        String optAccountType = this.convertOptAccountType(accountType);
        if (StringUtils.isBlank((CharSequence)optAccountType)) {
            throw new BusinessException("\u8d26\u6237\u7c7b\u578b(" + accountType + ")\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e\u7684\u8d26\u6237\u7c7b\u578b");
        }
        List<PaymentRuleConfigPageVO> paymentRuleConfigList = paymentRuleConfigMap.get(optAccountType);
        if (CollectionUtil.isEmpty(paymentRuleConfigList)) {
            throw new BusinessException("\u8d26\u6237\u7c7b\u578b(" + accountType + ")\u672a\u5339\u914d\u5230\u652f\u4ed8\u914d\u7f6e\u6570\u636e");
        }
        PaymentRuleConfigPageVO paymentRuleConfigDTO = paymentRuleConfigList.get(0);
        if (Objects.isNull(paymentRuleConfigDTO.getCalculatePercent())) {
            throw new BusinessException("\u652f\u4ed8\u914d\u7f6e(" + paymentRuleConfigDTO.getRuleName() + "-" + paymentRuleConfigDTO.getOptAccountType() + ")\u7684\u6263\u6b3e\u6bd4\u4f8b\u4e3a\u7a7a\uff01");
        }
        Integer priorityNo = paymentRuleConfigDTO.getPriorityNo();
        accountBalanceVO.setPriorityNo(priorityNo);
        BigDecimal calculatePercent = paymentRuleConfigDTO.getCalculatePercent();
        BigDecimal calculatePercentAmt = amt.multiply(calculatePercent.divide(DIVISOR));
        AccountVO czAccountVO = accountMap.get(UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()).get(0);
        CreditAccountPageVO xyCreditAccountPageVO = creditAccountMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()).get(0);
        BigDecimal sumAmt = czAccountVO.getAccountAvailableAmount().add(xyCreditAccountPageVO.getCreditAccountAvailableLimit());
        if (calculatePercentAmt.compareTo(sumAmt) == 1) {
            if (sumAmt.compareTo(BigDecimal.ZERO) == 1) {
                accountBalanceVO.setThisBillAvailableAmount(sumAmt);
                return accountBalanceVO;
            }
            if (sumAmt.compareTo(BigDecimal.ZERO) < 1) {
                accountBalanceVO.setThisBillAvailableAmount(BigDecimal.ZERO);
                return accountBalanceVO;
            }
        } else if (calculatePercentAmt.compareTo(BigDecimal.ZERO) > -1 && calculatePercentAmt.compareTo(sumAmt) < 1) {
            accountBalanceVO.setThisBillAvailableAmount(calculatePercentAmt);
            return accountBalanceVO;
        }
        return null;
    }

    private String convertOptAccountType(String accountType) {
        String optAccountType = null;
        if (Objects.equals(accountType, UdcEnum.ACCOUNT_TYPE_STORE.getValueCode())) {
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_STORE.getValueCode();
        }
        if (Objects.equals(accountType, UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode())) {
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_FLZH.getValueCode();
        }
        if (Objects.equals(accountType, UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode())) {
            optAccountType = UdcEnum.DEDUCTION_ACCOUNT_TYPE_CREDIT.getValueCode();
        }
        return optAccountType;
    }

    public AccountBalanceServiceImpl(AccountRepoProc accountRepoProc, AccountRepo accountRepo, CreditAccountRepo creditAccountRepo, CreditAccountRepoProc creditAccountRepoProc, PaymentRuleConfigRepo paymentRuleConfigRepo, PaymentRuleConfigRepoProc paymentRuleConfigRepoProc, UdcProvider udcProvider) {
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.creditAccountRepo = creditAccountRepo;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.paymentRuleConfigRepo = paymentRuleConfigRepo;
        this.paymentRuleConfigRepoProc = paymentRuleConfigRepoProc;
        this.udcProvider = udcProvider;
    }
}

