/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DefaultSaleInvExportServiceImpl
implements DataExport<SaleInvVO, SaleInvPageParam> {
    private final SaleInvDomainService saleInvDomainService;
    private final UdcProvider udcProvider;
    private static final Map<String, String> emptyMap = Map.of();

    public String getTmplCode() {
        return "FIN_SALE_INV_EXPORT_DEFAULT";
    }

    public PagingVO<SaleInvVO> executeExport(SaleInvPageParam queryParam) {
        PagingVO<SaleInvDTO> page = this.saleInvDomainService.page(queryParam);
        if (page.isEmpty()) {
            return new PagingVO(0L, List.of());
        }
        List records = page.getRecords();
        Map<String, String> docClsMap = this.getUdcMap("yst-supp", "DOC_CLS");
        Map<String, String> orderStateMap = this.getUdcMap("yst-supp", "APPLY_STATUS");
        Map<String, String> invTypeMap = this.getUdcMap("yst-fin", "INV_TYPE");
        Map<String, String> pushMethodMap = this.getUdcMap("yst-fin", "PUSH_METHOD");
        ExcelConverterManager.refresh();
        ArrayList<SaleInvVO> saleInvVOS = new ArrayList<SaleInvVO>();
        for (SaleInvDTO record : records) {
            SaleInvVO saleInvVO = new SaleInvVO();
            ExcelConvertUtils.convertLoosely(record, saleInvVO);
            saleInvVO.setCreateModeName(docClsMap.get(record.getCreateMode()));
            saleInvVO.setOrderStateName(orderStateMap.get(record.getOrderState()));
            saleInvVO.setInvTypeName(invTypeMap.get(record.getInvType()));
            saleInvVO.setPushMethodName(pushMethodMap.get(record.getPushMethod()));
            saleInvVOS.add(saleInvVO);
        }
        return new PagingVO(page.getTotal(), saleInvVOS);
    }

    public Integer pageSize() {
        return 1000;
    }

    private Map<String, String> getUdcMap(String appCode, String udcCode) {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)udcCode)) {
            return emptyMap;
        }
        Map valueMapByUdcCode = this.udcProvider.getValueMapByUdcCode(appCode, udcCode);
        return (Map)ObjectUtils.defaultIfNull((Object)valueMapByUdcCode, emptyMap);
    }

    public DefaultSaleInvExportServiceImpl(SaleInvDomainService saleInvDomainService, UdcProvider udcProvider) {
        this.saleInvDomainService = saleInvDomainService;
        this.udcProvider = udcProvider;
    }
}

