/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.paymentperiod;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementPagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.paymentperiod.ReceiptPaymentAgreementService;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDtlDomainService;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementDtlRepoProc;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementRepo;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementRepoProc;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ReceiptPaymentAgreementServiceImpl
implements ReceiptPaymentAgreementService {
    private static final Logger log = LoggerFactory.getLogger(ReceiptPaymentAgreementServiceImpl.class);
    private final ReceiptPaymentAgreementDomainService domainService;
    private final ReceiptPaymentAgreementDtlDomainService dtlDomainService;
    private final ReceiptPaymentAgreementRepo receiptPaymentAgreementRepo;
    private final ReceiptPaymentAgreementRepoProc receiptPaymentAgreementRepoProc;
    private final ReceiptPaymentAgreementDtlRepo receiptPaymentAgreementDtlRepo;
    private final ReceiptPaymentAgreementDtlRepoProc receiptPaymentAgreementDtlRepoProc;
    private final SysNumberGenerator sysNumberGeneratorWrapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ReceiptPaymentAgreementSaveParam saveParam) {
        List<ReceiptPaymentAgreementDtlSaveParam> dtlSaveParamList = saveParam.getDtlSaveParamList();
        this.checkMandatoryField(saveParam);
        this.checkMandatoryFieldDtlList(dtlSaveParamList);
        ReceiptPaymentAgreementVO receiptPaymentAgreementVO = null;
        Boolean flag = true;
        if (Objects.nonNull(saveParam.getId())) {
            receiptPaymentAgreementVO = this.domainService.findById(saveParam.getId());
            this.checkUpdateBusiness(receiptPaymentAgreementVO);
            flag = false;
        }
        this.checkAllowShipItemGroup(saveParam, flag);
        this.checkAllowShipItemGroupDtl(saveParam, dtlSaveParamList, flag);
        this.saveDefaultValue(flag, saveParam, receiptPaymentAgreementVO);
        Long id = this.domainService.save(saveParam);
        saveParam.setId(id);
        this.dtlDomainService.deleteByMasId(id);
        this.saveDtlDefaultValue(dtlSaveParamList, saveParam);
        this.dtlDomainService.saveDtl(dtlSaveParamList);
        return id;
    }

    private void saveDefaultValue(Boolean flag, ReceiptPaymentAgreementSaveParam saveVO, ReceiptPaymentAgreementVO respVO) {
        if (flag.booleanValue()) {
            saveVO.setProtocolCode(this.getProtocolCode());
        } else if (StringUtils.isBlank((CharSequence)saveVO.getProtocolCode())) {
            saveVO.setProtocolCode(respVO.getProtocolCode());
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getStatus())) {
            saveVO.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        }
    }

    private void saveDtlDefaultValue(List<ReceiptPaymentAgreementDtlSaveParam> dtlSaveVOList, ReceiptPaymentAgreementSaveParam saveVO) {
        dtlSaveVOList.forEach(dtlSaveVO -> dtlSaveVO.setMasId(saveVO.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ReceiptPaymentAgreementSaveParam saveParam) {
        return null;
    }

    private void checkAllowShipItemGroup(ReceiptPaymentAgreementSaveParam saveVO, Boolean flag) {
        ReceiptPaymentAgreementPageParam pageParam1 = new ReceiptPaymentAgreementPageParam();
        pageParam1.setProtocolCode(saveVO.getProtocolCode());
        pageParam1.setProtocolType(saveVO.getProtocolType());
        ReceiptPaymentAgreementVO agreementVO1 = this.domainService.checkSelectByParam(pageParam1);
        if (flag != false ? Objects.nonNull(agreementVO1) && Objects.equals(agreementVO1.getProtocolCode(), saveVO.getProtocolCode()) : Objects.nonNull(agreementVO1) && Objects.equals(agreementVO1.getProtocolCode(), saveVO.getProtocolCode()) && !Objects.equals(saveVO.getId(), agreementVO1.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.judgmentPrompt(saveVO.getProtocolType()) + "\u7f16\u7801\u5df2\u5b58\u5728!");
        }
        ReceiptPaymentAgreementPageParam pageParam2 = new ReceiptPaymentAgreementPageParam();
        pageParam2.setProtocolName(saveVO.getProtocolName());
        pageParam2.setProtocolType(saveVO.getProtocolType());
        ReceiptPaymentAgreementVO agreementVO2 = this.domainService.checkSelectByParam(pageParam2);
        if (flag != false ? Objects.nonNull(agreementVO2) && Objects.equals(agreementVO2.getProtocolName(), saveVO.getProtocolName()) : Objects.nonNull(agreementVO2) && Objects.equals(agreementVO2.getProtocolName(), saveVO.getProtocolName()) && !Objects.equals(saveVO.getId(), agreementVO2.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, this.judgmentPrompt(saveVO.getProtocolType()) + "\u540d\u79f0\u5df2\u5b58\u5728!");
        }
    }

    private void checkAllowShipItemGroupDtl(ReceiptPaymentAgreementSaveParam saveVO, List<ReceiptPaymentAgreementDtlSaveParam> dtlSaveVOList, Boolean flag) {
    }

    private String judgmentPrompt(String type) {
        if (Objects.equals(type, UdcEnum.AGREEMENT_PROTOCOL_TYPE_RECEIPT.getValueCode())) {
            return UdcEnum.AGREEMENT_PROTOCOL_TYPE_RECEIPT.getValueCodeName();
        }
        if (Objects.equals(type, UdcEnum.AGREEMENT_PROTOCOL_TYPE_PAYMENT.getValueCode())) {
            return UdcEnum.AGREEMENT_PROTOCOL_TYPE_PAYMENT.getValueCodeName();
        }
        return "";
    }

    private void checkUpdateBusiness(ReceiptPaymentAgreementVO respVO) {
    }

    private void checkMandatoryField(ReceiptPaymentAgreementSaveParam saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getProtocolName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u534f\u8bae\u540d\u79f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getProtocolType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u534f\u8bae\u7c7b\u578b\u4e3a\u7a7a!");
        }
    }

    private void checkMandatoryFieldDtlList(List<ReceiptPaymentAgreementDtlSaveParam> saveVOList) {
        if (!CollectionUtils.isEmpty(saveVOList)) {
            saveVOList.forEach(saveVO -> this.checkMandatoryFieldDtl((ReceiptPaymentAgreementDtlSaveParam)saveVO));
        }
    }

    private void checkMandatoryFieldDtl(ReceiptPaymentAgreementDtlSaveParam saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getPeriodType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getStartEffectiveDate())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d77\u6548\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (Objects.equals(saveVO.getPeriodType(), UdcEnum.AGREEMENT_PERIOD_TYPE_IMMOBILIZATION.getValueCode())) {
            if (Objects.isNull(saveVO.getEffectiveAdditionalMonth())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u7c7b\u578b=\u56fa\u5b9a\u65f6,\u751f\u6548\u9644\u52a0\u6708\u5fc5\u586b!");
            }
            if (Objects.isNull(saveVO.getEffectiveDate())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u7c7b\u578b=\u56fa\u5b9a\u65f6,\u751f\u6548\u65e5\u5fc5\u586b!");
            }
        } else if (Objects.equals(saveVO.getPeriodType(), UdcEnum.AGREEMENT_PERIOD_TYPE_ROUTINE.getValueCode())) {
            if (Objects.isNull(saveVO.getValidityDateDelayDays())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u7c7b\u578b=\u5e38\u89c4\u65f6,\u8d77\u6548\u65e5\u671f\u5ef6\u8fdf\u5929\u6570\u5fc5\u586b!");
            }
            if (Objects.isNull(saveVO.getPeriodDays())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u671f\u7c7b\u578b=\u5e38\u89c4\u65f6,\u8d26\u671f\u5929\u6570\u5fc5\u586b!");
            }
        }
    }

    private String getProtocolCode() {
        String code = this.sysNumberGeneratorWrapper.generate("AGREEMENT_PROTOCOL_CODE");
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u751f\u6210\u6536\u4ed8\u6b3e\u534f\u8bae\u7f16\u7801\u5931\u8d25!");
        }
        return code;
    }

    @Override
    @SysCodeProc
    public PagingVO<ReceiptPaymentAgreementPagingVO> page(ReceiptPaymentAgreementPageParam pageParam) {
        return this.domainService.page(pageParam);
    }

    @Override
    @SysCodeProc
    public ReceiptPaymentAgreementVO findIdOne(Long id) {
        ReceiptPaymentAgreementVO agreementVO = this.domainService.selectById(id);
        List<ReceiptPaymentAgreementDtlVO> agreementDtlVOList = this.dtlDomainService.selectByMasId(agreementVO.getId());
        if (CollectionUtils.isEmpty(agreementDtlVOList)) {
            return agreementVO;
        }
        this.translateDtl(agreementDtlVOList);
        agreementVO.setDtlVOList(agreementDtlVOList);
        return agreementVO;
    }

    @Override
    @SysCodeProc
    public ReceiptPaymentAgreementVO findCodeOne(String code) {
        ReceiptPaymentAgreementVO agreementVO = this.domainService.selectByCode(code);
        List<ReceiptPaymentAgreementDtlVO> agreementDtlVOList = this.dtlDomainService.selectByMasId(agreementVO.getId());
        if (CollectionUtils.isEmpty(agreementDtlVOList)) {
            return agreementVO;
        }
        this.translateDtl(agreementDtlVOList);
        agreementVO.setDtlVOList(agreementDtlVOList);
        return agreementVO;
    }

    private void translateDtl(List<ReceiptPaymentAgreementDtlVO> respVOList) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ReceiptPaymentAgreementPageParam queryVO = new ReceiptPaymentAgreementPageParam();
        queryVO.setIdList(ids);
        List<ReceiptPaymentAgreementVO> respVOList = this.domainService.selectByParam(queryVO);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.domainService.updateDeleteFlagBatch(1, idList);
        this.dtlDomainService.updateDeleteFlagBatch(1, idList);
    }

    @Override
    public void enableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528\u7684\u6570\u636e!");
        }
        ReceiptPaymentAgreementPageParam checkEqualParam = new ReceiptPaymentAgreementPageParam();
        checkEqualParam.setIdList(ids);
        checkEqualParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<ReceiptPaymentAgreementVO> checkEqualList = this.domainService.selectByParam(checkEqualParam);
        if (!CollectionUtils.isEmpty(checkEqualList)) {
            String checkItemResult = checkEqualList.stream().map(checkVO -> this.judgmentPrompt(checkVO.getProtocolType()) + ":(" + checkVO.getProtocolName() + ")").collect(Collectors.joining(";", "\u5df2\u542f\u7528\u7684\u4e0d\u53ef\u91cd\u590d\u542f\u7528.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.FAIL, checkItemResult);
        }
        this.domainService.updateStatusBatch(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u9700\u8981\u7981\u7528\u7684\u6570\u636e!");
        }
        ReceiptPaymentAgreementPageParam checkEqualParam = new ReceiptPaymentAgreementPageParam();
        checkEqualParam.setIdList(ids);
        checkEqualParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode());
        List<ReceiptPaymentAgreementVO> checkEqualList = this.domainService.selectByParam(checkEqualParam);
        if (!CollectionUtils.isEmpty(checkEqualList)) {
            String checkItemResult = checkEqualList.stream().map(checkVO -> this.judgmentPrompt(checkVO.getProtocolType()) + ":(" + checkVO.getProtocolName() + ")").collect(Collectors.joining(";", "\u5df2\u7981\u7528\u7684\u4e0d\u53ef\u91cd\u590d\u7981\u7528.[", "],\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.FAIL, checkItemResult);
        }
        this.domainService.updateStatusBatch(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode(), ids);
    }

    public ReceiptPaymentAgreementServiceImpl(ReceiptPaymentAgreementDomainService domainService, ReceiptPaymentAgreementDtlDomainService dtlDomainService, ReceiptPaymentAgreementRepo receiptPaymentAgreementRepo, ReceiptPaymentAgreementRepoProc receiptPaymentAgreementRepoProc, ReceiptPaymentAgreementDtlRepo receiptPaymentAgreementDtlRepo, ReceiptPaymentAgreementDtlRepoProc receiptPaymentAgreementDtlRepoProc, SysNumberGenerator sysNumberGeneratorWrapper) {
        this.domainService = domainService;
        this.dtlDomainService = dtlDomainService;
        this.receiptPaymentAgreementRepo = receiptPaymentAgreementRepo;
        this.receiptPaymentAgreementRepoProc = receiptPaymentAgreementRepoProc;
        this.receiptPaymentAgreementDtlRepo = receiptPaymentAgreementDtlRepo;
        this.receiptPaymentAgreementDtlRepoProc = receiptPaymentAgreementDtlRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
    }
}

