package com.elitesland.fin.application.convert.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.excel.account.AccountImportEntity;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.excel.entity.AccountExportEntity;
import com.elitesland.fin.application.service.excel.entity.AccountSnapshotExportEntity;
import com.elitesland.fin.dto.account.AccountRpcDTO;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import com.elitesland.fin.param.account.AccountRpcParam;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.convert.account
 * @date 2023/2/16 15:15
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AccountConvert {

    AccountConvert INSTANCE = Mappers.getMapper(AccountConvert.class);


    AccountDO p2En(AccountParam accountParam);

    List<AccountDO> accountParamList2AccountDOList(List<AccountParam> param);

    List<AccountDO> accountImportEntityList2AccountDOList(List<AccountImportEntity> param);

    AccountVO en2Vo(AccountDO accountDO);

    List<AccountParam> accountImportEntityToAccountParam(List<AccountImportEntity> accountImportEntityList);

    List<AccountBankInfoVo> rpcBankVos2Vos(List<RmiOrgBankAccRpcVO> bankAccRpcVOS);

    List<AccountParam> rpcParam2Param(List<AccountRpcParam> param);

    PagingVO<AccountSnapshotExportEntity> pageVo2Entity(PagingVO<AccountSnapshotVo> pagingVO);

    List<AccountSnapshotDO> accountDos2Snapshots(List<AccountDO> accountDOList);

    AccountParam rpc2Param(AccountRpcParam accountRpcParam);

    List<AccountRpcDTO> dtos2RpcDtos(List<AccountDTO> accountDTOS);

    PagingVO<AccountExportEntity> pageVo2ExportEntity(PagingVO<AccountVO> page);

    AccountDO VO2DO(AccountVO AccountVO);
}
