package com.elitesland.fin.application.facade.dto.flowrepair;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/12
 * @Version 1.0
 * @Content:
 */

@Data
@Entity  // 该注解声明一个实体类，与数据库中的表对应
@NamedStoredProcedureQueries({
        @NamedStoredProcedureQuery(name =  "account_flow_repair2", procedureName = "account_flow_repair2",
                //resultClasses = { AccountFlowProcedureResultDTO.class },
                parameters = {
                        @StoredProcedureParameter(mode = ParameterMode.IN, name = "account_code_i", type = String.class),
                        @StoredProcedureParameter(mode = ParameterMode.IN, name = "audit_date_i", type = LocalDateTime.class)
                        /*@StoredProcedureParameter(mode = ParameterMode.OUT, name = "row_cnt", type = Integer.class),
                        @StoredProcedureParameter(mode = ParameterMode.OUT, name = "account_code_i", type = Integer.class),
                        @StoredProcedureParameter(mode = ParameterMode.OUT, name = "audit_date_i", type = Integer.class),
                        @StoredProcedureParameter(mode = ParameterMode.OUT, name = "notfoundmsg", type = Integer.class),
                        @StoredProcedureParameter(mode = ParameterMode.OUT, name = "cnt", type = Integer.class)*/
                        //@StoredProcedureParameter(mode = ParameterMode.OUT, name = "result", type = void.class)

                }),
})
@ApiModel(value = "accountFlowProcedureResultDTO",description = "账户流水修复的存储过程重算返回结果")
public class AccountFlowProcedureResultDTO implements Serializable {
    private static final long serialVersionUID = 4313573424380671121L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)   //  自动生成
    private Integer id = 1;

    @ApiModelProperty(value = "row_cnt")
    @Column(name = "row_cnt")
    private Integer rowCnt;

    @ApiModelProperty(value = "account_code_i")
    @Column(name = "account_code_i")
    private String accountCodeI;

    @ApiModelProperty(value = "audit_date_i")
    @Column(name = "audit_date_i")
    private LocalDateTime auditDateI;

    @ApiModelProperty(value = "没有数据退出")
    @Column(name = "notfoundmsg")
    private String notfoundmsg;

    @ApiModelProperty(value = "cnt")
    @Column(name = "cnt")
    private Integer cnt;

}
