package com.elitesland.fin.application.facade.param.payorder;


import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:37
 */
@Data
public class PayOrderSaveParam implements Serializable {

    private static final long serialVersionUID = -8770674076481608290L;
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("付款单类型代码")
    private String payTypeCode;

    @ApiModelProperty("付款单类型名称")
    private String payTypeName;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("业务类型")
    private String buType;

    @ApiModelProperty("是否预付")
    private Boolean apFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("预计付款日期")
    private LocalDateTime apDate;

    @ApiModelProperty("实际支付金额")
    private BigDecimal realPayAmt;

    @ApiModelProperty("实际支付金额(本位币)")
    private BigDecimal realPayCurAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审核拒绝原因")
    private String auditRejection;

    @ApiModelProperty("本位币名称")
    private String localCurrCode;

    @ApiModelProperty("本位币编码")
    private String localCurrName;

    @ApiModelProperty("订单状态 默认草稿")
    private String orderState;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("付款单明细数据")
    private List<PayOrderDtlSaveParam> payOrderDtlSaveParams;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    private String proposedStatus;

    @ApiModelProperty("是否检验")
    private Boolean check = Boolean.TRUE;
}
