package com.elitesland.fin.application.facade.param.writeoff;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "查询参数")
public class FinArRecVerApplyQuery extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 8260393831859846184L;

    /**
     * 核销申请单单号，精确查询
     */
    @ApiModelProperty("核销申请单单号，精确查询")
    private String applyDocNo;

    /**
     * 单据状态，精确查询
     */
    @ApiModelProperty(value = "单据状态，精确查询")
    private String state;

    /**
     * 审核状态，精确查询
     */
    @ApiModelProperty(value = "审核状态，精确查询")
    private String verState;

    /**
     * 销售公司ID，精确查询
     */
    @ApiModelProperty("销售公司ID，精确查询")
    private Long arOuId;

    /**
     * 销售公司编码，精确查询
     */
    @ApiModelProperty("销售公司编码，精确查询")
    private String arOuCode;

    /**
     * 应收业务员ID，精确查询
     */
    @ApiModelProperty(value = "应收业务员ID，精确查询")
    private Long arSalesmanId;

    /**
     * 应收业务员编码，精确查询
     */
    @ApiModelProperty(value = "应收业务员编码，精确查询")
    private String arSalesmanCode;

    /**
     * 应收客户ID，精确查询
     */
    @ApiModelProperty(value = "应收客户ID，精确查询")
    private Long arCustId;

    /**
     * 应收客户编码，精确查询
     */
    @ApiModelProperty(value = "应收客户编码，精确查询")
    private String arCustCode;

    /**
     * 应收子客户ID，精确查询
     */
    @ApiModelProperty(value = "应收子客户ID，精确查询")
    private Long arSubCustId;

    /**
     * 应收子客户编码，精确查询
     */
    @ApiModelProperty(value = "应收子客户编码，精确查询")
    private String arSubCustCode;

    /**
     * 应收发票号，模糊查询
     */
    @ApiModelProperty(value = "应收发票号，模糊查询")
    private String arInvoiceNumber;

    /**
     * 收款公司ID，精确查询
     */
    @ApiModelProperty("收款公司ID，精确查询")
    private Long recOuId;

    /**
     * 收款公司编码，精确查询
     */
    @ApiModelProperty("收款公司编码，精确查询")
    private String recOuCode;

    /**
     * 收款业务员编码，精确查询
     */
    @ApiModelProperty(value = "收款业务员编码，精确查询")
    private Long recSalesmanId;

    /**
     * 收款业务员编码，精确查询
     */
    @ApiModelProperty(value = "收款业务员编码，精确查询")
    private String recSalesmanCode;

    /**
     * 收款客户ID，精确查询
     */
    @ApiModelProperty(value = "收款客户ID，精确查询")
    private Long recCustId;

    /**
     * 收款客户编码，精确查询
     */
    @ApiModelProperty(value = "收款客户编码，精确查询")
    private String recCustCode;

    /**
     * 收款发票号，模糊查询
     */
    @ApiModelProperty(value = "收款发票号，模糊查询")
    private String recInvoiceNumber;

    /**
     * 申请日期，开始
     */
    @ApiModelProperty(value = "申请日期，开始")
    private LocalDateTime applyDateS;

    /**
     * 申请日期，结束
     */
    @ApiModelProperty(value = "申请日期，结束")
    private LocalDateTime applyDateE;

    /**
     * 审批日期，开始
     */
    @ApiModelProperty(value = "审批日期，开始")
    private LocalDateTime approvalDateS;

    /**
     * 审批日期，结束
     */
    @ApiModelProperty(value = "审批日期，结束")
    private LocalDateTime approvalDateE;

    /**
     * 审批人ID，精确查询
     */
    @ApiModelProperty(value = "审批人ID，精确查询")
    private Long approvalUserId;

    /**
     * 审批人编码，精确查询
     */
    @ApiModelProperty(value = "审批人编码，精确查询")
    private String approvalUserCode;

    /**
     * 审批人名称，模糊查询
     */
    @ApiModelProperty(value = "审批人名称，模糊查询")
    private String approvalUserName;

    /**
     * 申请人ID，精确查询
     */
    @ApiModelProperty(value = "申请人ID，精确查询")
    private Long applyUserId;

    /**
     * 申请人编码，精确查询
     */
    @ApiModelProperty(value = "申请人编码，精确查询")
    private String applyUserCode;


    /**
     * 申请人名称，模糊查询
     */
    @ApiModelProperty(value = "申请人名称，模糊查询")
    private String applyUserName;

    @ApiModelProperty(value = "表头标识符")
    private Boolean headFlag;

    private String writeOffArCustCode;
    private String writeOffArOuCode;
    private String writeOffArSalesmanCode;
    private String writeOffRecCustCode;
    private String writeOffRecOuCode;
    private String writeOffRecSalesmanCode;

	@ApiModelProperty(value = "第三方应收单号")
	private String outArDocNo;

	@ApiModelProperty(value = "第三方应收单明细ID")
	private String outArDId;

	@ApiModelProperty(value = "第三方收款单号")
	private String outRecDocNo;

	@ApiModelProperty(value = "第三方收款单明细ID")
	private String outRecDId;

	@ApiModelProperty(value = "主表id")
	private List<Long> ids;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    private String proposedStatus;
}
