package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎数据行")
public class FinAccEngDetDataVO extends BaseModelVO {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("行名称")
    private String name;

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("行说明")
    private String description;

    @ApiModelProperty("借贷方 D/C")
    private String debitCredit;

    @ApiModelProperty("是否合并")
    private Boolean combineFlag;

    private List<FinAccEngDetDataLineVO> finAccEngDetDataLineList;
}
