package com.elitesland.fin.application.facade.vo.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.elitesland.fin.application.facade.excel.convert.IntegerToBooleanConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "待开发票返回实体")
public class InvoiceAwaitVO implements Serializable {

    private static final long serialVersionUID = 2617718744779453725L;

    @ApiModelProperty("表头ID")
    private Long id;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal amt;

    @ApiModelProperty("待开发票状态")
    @SysCode(sys = "yst-fin", mod = "INVOICE_AWAIT_STATUS")
    private String invoiceAwaitStatus;
    private String invoiceAwaitStatusName;


    @ApiModelProperty("来源单据名称")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String optDocCls;
    private String optDocClsName;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-supp",mod = "DOC_TYPE")
    private String optDocType;
    private String optDocTypeName;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("来源单据状态")
    @SysCode(sys = "yst-supp",mod = "DOC_STATUS")
    private String optDocStatus;
    private String optDocStatusName;

    @ApiModelProperty("发票文件编码")
    private String invoiceFileCode;

    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-supp",mod = "INV_TYPE")
    private String invoiceType;
    private String invoiceTypeName;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;


    @ApiModelProperty("来源单据主键id")
    private Long optDocId;

    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal currRate;

    @ApiModelProperty("币种")
    private String currCode;

    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty(value = "是否允许修改发票抬头 1-是 0-否")
    @JsonSerialize(using = IntegerToBooleanConverter.class)
    private Integer editInvTitle;


}
