package com.elitesland.fin.application.facade.vo.writeoff;

import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.time.LocalDateTime;
/**
 * 应付付款核销申请单明细-付款单
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
@Data
public class FinApPayVerApplyPayVO extends BaseModelVO {
private static final long serialVersionUID =2921254737894930667L;

	/**
	 * 主表ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "mas_id", nullable = true)
	private Long masId;

	/**
	 * 外部收款单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部收款单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "out_pay_id", nullable = true)
	private Long outPayId;

	/**
	 * 收款单ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_id", nullable = true)
	private Long payId;

	/**
	 * 收款单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单号")
	@Column(name = "pay_doc_no", nullable = true, length = 64)
	private String payDocNo;

	/**
	 * 第三方收款单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "第三方收款单号")
	@Column(name = "out_pay_doc_no", nullable = true, length = 64)
	private String outPayDocNo;

	/**
	 * 收款单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_d_id", nullable = true)
	private Long payDId;

	/**
	 * 外部收款单明细ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "外部收款单明细ID")
	@Column(name = "out_pay_d_id", nullable = true, length = 32)
	private String outPayDId;

	/**
	 * 收款单类型ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单类型ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "pay_type_id", nullable = true)
	private Long payTypeId;

	/**
	 * 收款单类型编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单类型编码")
	@Column(name = "pay_type_code", nullable = true, length = 32)
	private String payTypeCode;

	/**
	 * 收款单类型名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款单类型名称")
	@Column(name = "pay_type_name", nullable = true, length = 32)
	private String payTypeName;

	/**
	 * 公司ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "ou_id", nullable = true)
	private Long ouId;

	/**
	 * 公司编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司编码")
	@Column(name = "ou_code", nullable = true, length = 32)
	private String ouCode;

	/**
	 * 公司名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "公司名称")
	@Column(name = "ou_name", nullable = true, length = 32)
	private String ouName;

	/**
	 * 部门ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "bu_id", nullable = true)
	private Long buId;

	/**
	 * 部门编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门编码")
	@Column(name = "bu_code", nullable = true, length = 32)
	private String buCode;

	/**
	 * 部门名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "部门名称")
	@Column(name = "bu_name", nullable = true, length = 32)
	private String buName;

	/**
	 * 业务员ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "salesman_id", nullable = true)
	private Long salesmanId;

	/**
	 * 业务员编码
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员编码")
	@Column(name = "salesman_code", nullable = true, length = 32)
	private String salesmanCode;

	/**
	 * 业务员名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "业务员名称")
	@Column(name = "salesman_name", nullable = true, length = 32)
	private String salesmanName;

	/**
	 * 发票号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票号")
	@Column(name = "invoice_number", nullable = true, length = 32)
	private String invoiceNumber;

	/**
	 * 开票日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "开票日期")
	@Column(name = "inv_date", nullable = true)
	private LocalDateTime invDate;

	/**
	 * 发票类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "发票类型")
	@Column(name = "inv_type", nullable = true, length = 16)
	private String invType;

	/**
	 * 供应商ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "supp_id", nullable = true)
	private Long suppId;

	/**
	 * 供应商编号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商编号")
	@Column(name = "supp_code", nullable = true, length = 32)
	private String suppCode;

	/**
	 * 供应商名称
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "供应商名称")
	@Column(name = "supp_name", nullable = true, length = 32)
	private String suppName;

	/**
	 * 付款业务类型
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款业务类型")
	@Column(name = "pay_bu_type", nullable = true, length = 32)
	private String payBuType;

	/**
	 * 付款性质
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款性质")
	@Column(name = "pay_nat", nullable = true, length = 32)
	private String payNat;

	/**
	 * totalAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "totalAmt")
	@Column(name = "total_amt", nullable = true, length = 20)
	private Double totalAmt;

	/**
	 * 收款银行账户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "收款银行账户")
	@Column(name = "rec_bank", nullable = true, length = 500)
	private String recBank;

	/**
	 * 付款银行账户
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款银行账户")
	@Column(name = "pay_bank", nullable = true, length = 500)
	private String payBank;

	/**
	 * 付款单单据日期
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "付款单单据日期")
	@Column(name = "pay_date", nullable = true)
	private LocalDateTime payDate;

	/**
	 * notVerAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "notVerAmt")
	@Column(name = "not_ver_amt", nullable = true, length = 20)
	private BigDecimal notVerAmt;

	/**
	 * verAmt
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "verAmt")
	@Column(name = "ver_amt", nullable = true, length = 20)
	private BigDecimal verAmt;

	/**
	 * 所属组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "belong_org_id", nullable = true)
	private Long belongOrgId;

	/**
	 * 租户组织ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
	@Column(name = "tenant_org_id", nullable = true)
	private Long tenantOrgId;
	@ApiModelProperty(value = "pay_type")
	private String payType;
	@ApiModelProperty(value = "pay_account")
	private String payAccount;
	/**
	 * 来源单号
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "来源单号")
	private String sourceNo;

	@ApiModelProperty(value = "source_line")
	private Integer sourceLine;
}
