package com.elitesland.fin.application.service.account;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountRuleConfigDTO;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigQueryVO;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface AccountRuleConfigService {
    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<AccountRuleConfigPageVO> searchPage(AccountRuleConfigQueryParam param);

    /**
     * 保存/更新
     * @param param
     */
    void saveOrUpdate(AccountRuleConfigSaveParam param);

    /**
     * 删除主+明细信息
     * @param id
     */
    void del(Long id);

    /**
     * 详情信息
     * @param masId
     * @return
     */
    AccountRuleConfigQueryVO detail(Long masId);

    /**
     * 根据场景码获取账户规则操作配置，优先缓存
     * @param ruleCode
     * @return
     */
    AccountRuleConfigDTO getByRuleCode(String ruleCode);
}
