package com.elitesland.fin.application.service.accountingengine;

import com.elitesland.fin.application.facade.dto.accountingengine.PageParam;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineConfigDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *会计引擎凭证生成jdbc相关功能
 */
public interface FinAccountEngineJdbcService {
    public void closeConnection(Connection connection);

    public Connection getJournalConnection(FinAccountEngineDO finAccountEngineDO) throws ClassNotFoundException, SQLException;

    public Connection getEventTableConnection(FinEventTableDO finEventTableDO) throws ClassNotFoundException, SQLException;

    public int updateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Long masId, String proposedStatus) throws SQLException;

    public int batchUpdateProposedStatus(FinEventTableDO finEventTableDO, Connection connection, Set<Long> masIds, String proposedStatus) throws SQLException;

    public List<Map> queryEventTableData(Connection connection, FinAccountEngineConfigDO finAccountEngineConfigDO, boolean manualFlag, List<Long> docIds) throws SQLException;

    public void deleteExistJournal(Connection eventTableConnection, Connection journalConnection, FinAccountEngineConfigDO finAccountEngineConfigDO, List<String> docNums);

    public String getDocNumStrsFromDocIds(Connection eventTableConnection, FinAccountEngineConfigDO finAccountEngineConfigDO, List<Long> docIds);

    public void finJournalBatchSave(FinAccountEngineDO finAccountEngineDO, Connection journalConnection, List<Map> saveMapList);

    public List<Map> pageQueryEventTableData(Connection connection, FinAccountEngineConfigDO finAccountEngineConfigDO, boolean manualFlag, List<Long> docIds, PageParam pageParam) throws SQLException;

}
