package com.elitesland.fin.application.service.creditaccount;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountRuleConfigDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigQueryVO;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface CreditAccountRuleConfigService {
    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<CreditAccountRuleConfigPageVO> searchPage(CreditAccountRuleConfigQueryParam param);

    /**
     * 保存/更新
     * @param param
     */
    void saveOrUpdate(CreditAccountRuleConfigSaveParam param);

    /**
     * 删除主+明细信息
     * @param id
     */
    void del(Long id);

    /**
     * 详情信息
     * @param masId
     * @return
     */
    CreditAccountRuleConfigQueryVO detail(Long masId);

    /**
     * 根据场景码获取账户规则操作配置，优先缓存
     *
     * @param ruleCode
     * @return
     */
    CreditAccountRuleConfigDTO getByRuleCode(String ruleCode);
}
