package com.elitesland.fin.application.service.creditaccountflow;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowDealerParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;

import java.util.List;

/**
 * @Author gyj
 * @Date 2023/02/25
 */
public interface CreditAccountFlowService {

    PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowParam creditAccountFlowParam);

    void approve(CreditAccountFlowParam creditAccountFlowParam);

    void reject(CreditAccountFlowParam creditAccountFlowParam);

    void accountFlowCallBack(String doc, CreditAccountFlowDO creditAccountFlowDO, boolean isApprove);

    String generateCreditAccountFlow(CreditAccountFlowParam creditAccountFlowParam);

    /**
     * 校验信用账户余额
     */
    Boolean checkCreditAccountBalance(CreditAccountFlowParam creditAccountFlowParam);

    List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam);

    List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowParam pageParam);

    List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam pageParam);

}
