package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DefaultDateTimeConverter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class AdjustToExportEntity implements Serializable {
    @ApiModelProperty("单号")
    private String docNo;
    
    @ApiModelProperty("单据状态")
    private String docStateName;
    
    @ApiModelProperty("从账户类型")
    private String accountTypeFromName;
    
    @ApiModelProperty("从账户编码")
    private String accountCodeFrom;
    
    @ApiModelProperty("从账户名称")
    private String accountNameFrom;
    
    @ApiModelProperty("至账户名称")
    private String accountNameTo;
    
    @ApiModelProperty("至账户类型")
    private String accountTypeToName;
    
    @ApiModelProperty("至账户编码")
    private String accountCodeTo;
    
    @ApiModelProperty("调整原因")
    private String adjustReasonName;
    
    @ApiModelProperty("调整金额")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal adjustAmount;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核人ID")
    private Long auditUserId;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;
    
    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;
    
    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty("创建时间")
    @ExcelConvert(converter = DateTimeToDateConverter.class, name = "createTime")
    private LocalDate createDate;
    
    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "修改人")
    private String updater;
    
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("创建人")
    private String creator;
}
