package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.excel.entity.CreditAccountFlowEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_CREDIT_ACC_FLOW_EXPORT_DEFAULT_IMPL;

@Service
@AllArgsConstructor
public class DefaultCreditAccountFlowExportServiceImpl implements DataExport<CreditAccountFlowEntity, CreditAccountFlowParam> {
    private final CreditAccountFlowService creditAccountFlowService;
    @Override
    public String getTmplCode() {
        return FIN_CREDIT_ACC_FLOW_EXPORT_DEFAULT_IMPL;
    }
    @Override
    public PagingVO<CreditAccountFlowEntity> executeExport(CreditAccountFlowParam queryParam) {
        PagingVO<CreditAccountFlowDTO> page = creditAccountFlowService.page(queryParam);
        return new PagingVO<>(
            page.getTotal(), ExcelConvertUtils.convertLoosely(page.getRecords(), CreditAccountFlowEntity.class)
        );
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
}