package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_PAY_EXPORT_DEFAULT;

@Service
@AllArgsConstructor
public class DefaultPayOrderExportServiceImpl implements DataExport<PayOrderVO, PayOrderPageParam> {
    private final PayOrderDomainService payOrderDomainService;
    
    private final UdcProvider udcProvider;
    
    private final static Map<String, String> emptyMap = Map.of();
    
    @Override
    public String getTmplCode() {
        return FIN_PAY_EXPORT_DEFAULT;
    }
    @Override
    public PagingVO<PayOrderVO> executeExport(PayOrderPageParam queryParam) {
        PagingVO<PayOrderDTO> page = payOrderDomainService.page(queryParam);
        if(page == null || page.isEmpty()) {
            return new PagingVO<>(0, List.of());
        }
        List<PayOrderDTO> records = page.getRecords();
        var payOrderVOs = new ArrayList<PayOrderVO>(records.size());
        var recDocClsMap = getUdcMap("yst-fin", "PAY_DOC_CLS");
        var orderStateMap = getUdcMap("yst-supp", "APPLY_STATUS");
        var verifyStatusMap = getUdcMap("yst-fin", "VERIFY_STATUS");
        var proposedStatusMap = getUdcMap("yst-fin", "DOC_PROPOSED_STATUS");
        ExcelConverterManager.refresh();
        for (PayOrderDTO payOrderDTO : records) {
            PayOrderVO record = new PayOrderVO();
            ExcelConvertUtils.convertLoosely(payOrderDTO, record);
            record.setCreateModeName(recDocClsMap.get(record.getCreateMode()));
            record.setOrderStateName(orderStateMap.get(record.getOrderState()));
            record.setVerStateName(verifyStatusMap.get(record.getVerState()));
            record.setProposedStatusName(proposedStatusMap.get(record.getProposedStatus()));
            payOrderVOs.add(record);
        }
        return new PagingVO<>(page.getTotal(), payOrderVOs);
    }
    @Override
    public Integer pageSize() {
        return 1000;
    }
    
    private Map<String, String> getUdcMap(String appCode, String udcCode) {
        if(StringUtils.isBlank(appCode) || StringUtils.isBlank(udcCode)) {
            return emptyMap;
        }
        Map<String, String> valueMapByUdcCode = udcProvider.getValueMapByUdcCode(appCode, udcCode);
        return ObjectUtils.defaultIfNull(valueMapByUdcCode, emptyMap);
    }
}
