package com.elitesland.fin.application.service.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;

import java.util.List;

public interface InvoiceAwaitService {

    PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param);

    List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId);

    Object invoiceApply(InvoiceApplyParam param);

    List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam);

    List<InvoiceAwaitDTO> invoiceAwaitOrder(String param);

    /**
     * 更新开票状态
     * @param param
     */
    void updateInvedState(SaleInvStatusParam param);

    void updateRedState(SaleInvStatusParam statusParam);

    /**
     * 根据来源单号批量逻辑删除
     *
     * @param optDocNos 来源单号
     * @return
     */
    void updateDeleteFlagByOptDocNoBatch(List<String> optDocNos);

    /**
     * 根据来源单据主键id批量逻辑删除
     *
     * @param optDocIds 来源单据主键id
     * @return
     */
    void updateDeleteFlagByOptDocIdBatch(List<Long> optDocIds);

}
