package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplySettleDO;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplySettleRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 核销申请明细拆分.
 *
 * @author shihao.ma
 * @since 2023/9/19
 */
@Service
@RequiredArgsConstructor
public class FinApPayVerApplySettleServiceImpl implements FinApPayVerApplySettleService {

    private final FinApPayVerApplySettleRepoProc finApPayVerApplySettleRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(Long masId, List<FinApPayVerApplySettleSaveDTO> saveList) {
        Assert.notNull(masId, "主表ID不能为Null");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
		finApPayVerApplySettleRepoProc.save(saveList.stream()
                .map(e -> {
                    FinApPayVerApplySettleDO entity = FinApPayVerApplySettleConvert.INSTANCE.save2Do(e);
                    entity.setMasId(masId);
                    return entity;
                }).collect(Collectors.toList()));
    }

    @Override
    public List<FinApPayVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        return finApPayVerApplySettleRepoProc.listByMasIds(masIds)
                .stream()
                .map(FinApPayVerApplySettleConvert.INSTANCE::entity2Vo)
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (finApPayVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <=0) {
            throw new BusinessException("更新核销处理编号失败!");
        }
    }

	/**
	 * 更新核销处理核销类型
	 * @param masIds
	 * @param verFlag
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateVerFlag(Collection<Long> masIds, String verFlag) {
		if (finApPayVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <=0) {
			throw new BusinessException("更新核销处理编号失败!");
		}
	}

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 *//*
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByArDid(String arDid, String batchNo) {
		if (finApPayVerApplySettleRepoProc.updateBatchNoByApDid(arDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}*/

	/**
	 * 更新核销批次号-应收
	 * @param rcDid
	 * @param batchNo
	 *//*
	@Override
	@Transactional(rollbackFor = Exception.class)
	public void updateBatchNoByRcDid(String rcDid, String batchNo) {
		if (finArRecVerApplySettleRepoProc.updateBatchNoByRcDid(rcDid, batchNo) <=0) {
			throw new BusinessException("更新核销批次号失败!");
		}
	}*/
}
